/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.EquationSolverBiSearch;
import hec.statistics.EquationSolverNewton;
import hec.statistics.GumbelDist;
import hec.statistics.LinearMoments;
import hec.statistics.MaximumLikelihood;
import hec.statistics.ProductMoments;
import hec.statistics.SpecialFunctions;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class GevDist
extends AbstractContDist {
    private static final double MIN_SCALE = 1.0E-5;
    private double _loctn;
    private double _scale;
    private double _shape;
    GumbelDist _encapsulatedDist = new GumbelDist();

    public GevDist() {
        this(0.0, 1.0, 0.0);
    }

    public GevDist(double loctn, double scale, double shape) {
        this.setLoctn(loctn);
        this.setScale(scale);
        this.setShape(shape);
    }

    public GevDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public GevDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        if (pm.getSkew() < -2.0) {
            EquationSolverNewton solverShapeP1 = new EquationSolverNewton(){

                @Override
                public double f(double x) {
                    double termG1 = SpecialFunctions.gamma(1.0 + x);
                    double termG2 = SpecialFunctions.gamma(1.0 + 2.0 * x);
                    double termG3 = SpecialFunctions.gamma(1.0 + 3.0 * x);
                    return Math.log(Math.signum(x) * (termG3 - 3.0 * termG2 * termG1 + 2.0 * termG1 * termG1 * termG1) / Math.pow(termG2 - termG1 * termG1, 1.5));
                }
            };
            this.setShape(solverShapeP1.newton(Math.log(-pm.getSkew()), 1.0, 1.0E-8, 100, 1.0E-10));
        } else {
            EquationSolverBiSearch solverShapeP2 = new EquationSolverBiSearch(){

                @Override
                public double f(double x) {
                    if (Math.abs(x) < 1.0E-5) {
                        return 1.13954709940465;
                    }
                    double termG1 = SpecialFunctions.gamma(1.0 + x);
                    double termG2 = SpecialFunctions.gamma(1.0 + 2.0 * x);
                    double termG3 = SpecialFunctions.gamma(1.0 + 3.0 * x);
                    return -Math.signum(x) * (termG3 - 3.0 * termG2 * termG1 + 2.0 * termG1 * termG1 * termG1) / Math.pow(termG2 - termG1 * termG1, 1.5);
                }
            };
            this.setShape(solverShapeP2.biSearch(pm.getSkew(), -0.33333333, 1.0, 1.0E-8));
        }
        if (Math.abs(this.getShape()) < 1.0E-5) {
            this.setScale(Math.sqrt(6.0) * pm.getStDv() / Math.PI);
            this.setLoctn(pm.getMean() - this.getScale() * 0.5772156649015329);
        } else {
            double termG1 = SpecialFunctions.gamma(1.0 + this.getShape());
            double termG2 = SpecialFunctions.gamma(1.0 + 2.0 * this.getShape());
            this.setScale(pm.getStDv() * Math.abs(this.getShape()) / Math.sqrt(termG2 - termG1 * termG1));
            this.setLoctn(pm.getMean() - this.getScale() * (1.0 - termG1) / this.getShape());
        }
        return !Double.isNaN(this.getShape());
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        EquationSolverBiSearch solverShapeL = new EquationSolverBiSearch(){

            @Override
            public double f(double x) {
                if (x == 0.0) {
                    return 1.0;
                }
                double logTerm = 1.0 + Math.log(x);
                return (1.0 - Math.pow(3.0, logTerm)) / (1.0 - Math.pow(2.0, logTerm));
            }
        };
        double xTerm = solverShapeL.biSearch(0.5 * (3.0 + lm.getT3()), 0.0, 1.0, 1.0E-8);
        this.setShape(-(1.0 + Math.log(xTerm)));
        if (this.getShape() == 0.0) {
            this.setScale(lm.getL2() / Math.log(2.0));
            this.setLoctn(lm.getL1() - this.getScale() * 0.5772156649015329);
        } else {
            double gamShapePlusOne = SpecialFunctions.gamma(1.0 + this.getShape());
            this.setScale(lm.getL2() * this.getShape() / ((1.0 - Math.pow(2.0, -this.getShape())) * gamShapePlusOne));
            this.setLoctn(lm.getL1() - this.getScale() * (1.0 - gamShapePlusOne) / this.getShape());
        }
        return !Double.isNaN(this.getShape());
    }

    public void setLoctn(double loctn) {
        this._loctn = loctn;
    }

    public double getLoctn() {
        return this._loctn;
    }

    public void setScale(double scale) {
        if (scale <= 1.0E-5) {
            scale = 1.0E-5;
        }
        this._scale = scale;
    }

    public double getScale() {
        return this._scale;
    }

    public void setShape(double shape) {
        this._shape = shape;
    }

    public double getShape() {
        return this._shape;
    }

    @Override
    public String getType() {
        return "GEV";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Loctn", "Scale", "Shape"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getLoctn(), this.getScale(), this.getShape()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setLoctn(vals[0]);
        this.setScale(vals[1]);
        this.setShape(vals[2]);
    }

    @Override
    public Object clone() {
        GevDist clonedDist = (GevDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("GEVDistEnd")) {
                    return;
                }
                if (type.equals("Loctn")) {
                    this.setLoctn(Double.parseDouble(param));
                } else if (type.equals("Scale")) {
                    this.setScale(Double.parseDouble(param));
                } else if (type.equals("Shape")) {
                    this.setShape(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read GEVDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "GEVDistBegin");
        TextFile.writeLine(writer, "Locatn:" + this.getLoctn());
        TextFile.writeLine(writer, "Scale:" + this.getScale());
        TextFile.writeLine(writer, "Shape:" + this.getShape());
        TextFile.writeLine(writer, "GEVDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (this._shape < 0.0 && value <= this._loctn + this._scale / this._shape) {
            return 0.0;
        }
        if (this._shape > 0.0 && value >= this._loctn + this._scale / this._shape) {
            return 0.0;
        }
        double tx = SpecialFunctions.t(this._loctn, this._scale, this._shape, value);
        return Math.pow(tx, 1.0 - this._shape) * Math.exp(-tx) / this._scale;
    }

    @Override
    public double getCDF(double value) {
        if (this._shape < 0.0 && value <= this._loctn + this._scale / this._shape) {
            return 0.0;
        }
        if (this._shape > 0.0 && value >= this._loctn + this._scale / this._shape) {
            return 1.0;
        }
        return Math.exp(-SpecialFunctions.t(this._loctn, this._scale, this._shape, value));
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return this._shape < 0.0 ? this._loctn + this._scale / this._shape : Double.NEGATIVE_INFINITY;
        }
        if (p >= 1.0) {
            return this._shape > 0.0 ? this._loctn + this._scale / this._shape : Double.POSITIVE_INFINITY;
        }
        return SpecialFunctions.tInv(this._loctn, this._scale, this._shape, -Math.log(p));
    }

    public static void main(String[] args) {
        double[] data = new double[]{24200.0, 59700.0, 156000.0, 10300.0, 119000.0, 81300.0, 94950.0, 5814.0, 10771.0, 74100.0, 39900.0, 40700.0, 42300.0, 14928.0, 67500.0, 15100.0, 39200.0, 31600.0, 39000.0, 14000.0, 99500.0, 27400.0, 67700.0, 163000.0, 19667.0, 24400.0, 9900.0, 21100.0, 6437.0, 22600.0, 52900.0, 58300.0, 33000.0, 114000.0, 10900.0, 89200.0, 38800.0, 83200.0, 152000.0, 20100.0, 94400.0, 42200.0, 27900.0, 21000.0, 37500.0, 34400.0, 180000.0, 37200.0, 48400.0, 42600.0, 10800.0, 219000.0, 42000.0, 54000.0, 20000.0, 75000.0, 8000.0, 40000.0, 240000.0, 24000.0, 260000.0, 6500.0, 46000.0, 30000.0, 120000.0, 122000.0, 48000.0, 12000.0, 69000.0, 55000.0, 46000.0, 15000.0, 2500.0, 40000.0, 33000.0, 175000.0, 20000.0, 152000.0, 93000.0, 88000.0, 17000.0, 255000.0, 15455.0, 7083.0, 45935.0, 8497.0, 36849.0, 17587.0, 46342.0, 6226.0, 93771.0, 73960.0, 300000.0, 56016.0, 69852.0, 67061.0, 6244.0, 21015.0, 21282.0, 20972.0, 50226.0, 190111.0, 33522.0, 10710.0, 40419.0, 12502.0, 62669.0};
        ProductMoments pm = new ProductMoments(data);
        System.out.println("Mean=" + pm.getMean() + " Stdv=" + pm.getStDv() + " Skew=" + pm.getSkew());
        GevDist gev = new GevDist(data);
        System.out.println("Loc=" + gev.getLoctn() + " Scl=" + gev.getScale() + " Shp=" + gev.getShape());
        gev.fitSampleData(pm);
        System.out.println("Loc=" + gev.getLoctn() + " Scl=" + gev.getScale() + " Shp=" + gev.getShape());
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        if (this.getShape() == 0.0) {
            this._encapsulatedDist.setLoctn(this.getLoctn());
            this._encapsulatedDist.setScale(this.getScale());
            return this._encapsulatedDist.getLogLikelihood(sample);
        }
        int n = sample.length;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double y = 1.0 - this.getShape() / this.getScale() * (sample[i] - this.getLoctn());
            sum += (1.0 / this.getShape() - 1.0) * Math.log(y) - Math.pow(y, 1.0 / this.getShape());
        }
        return (double)(-n) * Math.log(this.getScale()) + sum;
    }

    @Override
    public double[] getLogLikelihoodJacobian(double[] sample) {
        double[] retval = new double[3];
        int n = sample.length;
        double sum1 = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double z = (sample[i] - this.getLoctn()) / this.getScale();
            double y = 1.0 - this.getShape() * z;
            double ypow = Math.pow(y, 1.0 / this.getShape());
            double numerator = 1.0 - this.getShape() - ypow;
            double frac = numerator / y;
            double logy = Math.log(y);
            sum1 += frac;
            sum2 += frac * z;
            sum3 += -ypow * (logy + this.getShape() * z / y) + logy + this.getShape() * (sample[i] - this.getLoctn()) * (1.0 - this.getShape()) / (this.getScale() * y);
        }
        retval[0] = 1.0 / this.getScale() * sum1;
        retval[1] = (double)(-n) / this.getScale() + 1.0 / this.getScale() * sum2;
        retval[2] = -(1.0 / (this.getShape() * this.getShape())) * sum3;
        return retval;
    }

    @Override
    public double[] getLogLikelihoodHessian(double[] sample) {
        int n = sample.length;
        double m = this.getLoctn();
        double s = this.getScale();
        double k = this.getShape();
        double s2 = s * s;
        double k2 = k * k;
        double dldl = 0.0;
        double dlds = 0.0;
        double dldk = 0.0;
        double dsdl = 0.0;
        double dsds = 0.0;
        double dsdk = 0.0;
        double dkdl = 0.0;
        double dkds = 0.0;
        double dkdk = 0.0;
        for (int i = 0; i < n; ++i) {
            double j = sample[i];
            double diff = m - j;
            double rootDenom = k * diff + s;
            double y = rootDenom / s;
            double ypow = Math.pow(y, 1.0 / k);
            double logy = Math.log(y);
            double denom = rootDenom * rootDenom;
            double other = s + diff;
            dldl += (ypow + k) / denom;
            dlds += (other * ypow + (k - 1.0) * this.getScale()) / denom;
            dldk += (rootDenom * ypow * logy + (this.getLoctn() - sample[i]) * (k - 1.0) * k * ypow - k2 * other) / denom;
            dsdl += (other * ypow + (k - 1.0) * s) / denom;
            dsds += diff * ((2.0 * ypow + 2.0 * k - 2.0) * s + ((k + 1.0) * m - j * k - j) * ypow + (k2 - k) * m - j * k2 + j * k) / denom;
            dsdk += diff * (ypow * rootDenom * logy + diff * (k - 1.0) * k * ypow - other * k2) / denom;
            dkdl += -(logy + k) * ypow / rootDenom + k * ypow * other / denom + k / rootDenom + (k - 1.0) * k * s / denom;
            dkds += diff * ((logy + k) * ypow / (s * rootDenom) - k * ypow * other / (s * denom) - k / (s * rootDenom) - (k - 1.0) * k / denom);
            dkdk += ypow * (rootDenom * logy * logy + (2.0 * diff * k2 + (2.0 * s - m + j) * k) * logy - diff * k2) / (k2 * rootDenom) - diff * ypow * (rootDenom * logy + 2.0 * diff * k2 + (s - m + j) * k) / (k * denom) - 2.0 * logy / k + diff / (s * y) - diff * (diff * k2 - 2.0 * diff * k - s) / denom;
        }
        dsdl = dlds *= -1.0 / s;
        dsds *= 1.0 / s2;
        dkdl = dldk *= -1.0 / (k * k);
        dkds = dsdk *= 1.0 / (s * k2);
        return new double[]{dldl *= -(k - 1.0), dlds, dldk, dsdl, dsds += (double)(-n) / s2, dsdk, dkdl, dkds, dkdk *= 1.0 / k2};
    }

    @Override
    public boolean fitSampleData(MaximumLikelihood ml) {
        int iter;
        final double[] sample = ml.getSample();
        this.fitSampleData(new LinearMoments(sample));
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < sample.length; ++i) {
            if (sample[i] < min) {
                min = sample[i];
            }
            if (!(sample[i] > max)) continue;
            max = sample[i];
        }
        double[] gumbelSample = Arrays.copyOf(sample, sample.length);
        GumbelDist gumbel = new GumbelDist();
        int maxIter = 100;
        EquationSolverBiSearch bisearch = new EquationSolverBiSearch(){

            @Override
            public double f(double x) {
                GevDist.this.setShape(x);
                return GevDist.this.getLogLikelihoodJacobian(sample)[2];
            }
        };
        Double likelihood = null;
        for (iter = 0; iter < maxIter; ++iter) {
            double minShape;
            double maxShape;
            this.translateToGumbel(gumbelSample);
            gumbel.fitSampleData(new MaximumLikelihood(gumbelSample, MaximumLikelihood.MinimizationMethod.NEWTON));
            this.setLoctn(gumbel.getLoctn());
            this.setScale(gumbel.getScale());
            boolean shouldBisect = true;
            if (this.getShape() > 0.0) {
                maxShape = this.getScale() / (max - this.getLoctn());
                maxShape = this.adjustBound(maxShape, false, sample);
                minShape = this.getScale() / (min - this.getLoctn());
                if ((minShape = this.adjustBound(minShape, true, sample)) > maxShape) {
                    this.setShape(maxShape);
                    shouldBisect = false;
                }
            } else {
                minShape = this.getScale() / (min - this.getLoctn());
                minShape = this.adjustBound(minShape, true, sample);
                maxShape = this.getScale() / (max - this.getLoctn());
                if (minShape > (maxShape = this.adjustBound(maxShape, false, sample))) {
                    maxShape = minShape;
                    shouldBisect = false;
                }
            }
            if (shouldBisect && minShape < maxShape) {
                this.setShape(minShape);
                double dfds1 = this.getLogLikelihoodJacobian(sample)[2];
                this.setShape(maxShape);
                double dfds2 = this.getLogLikelihoodJacobian(sample)[2];
                if (Math.signum(dfds1) == Math.signum(dfds2)) {
                    if (Math.signum(dfds1) > 0.0) {
                        this.setShape(maxShape);
                    } else {
                        this.setShape(minShape);
                    }
                } else {
                    double shape = bisearch.biSearch(0.0, minShape, maxShape, 1.0E-8);
                    if (Double.isNaN(shape)) {
                        if (this.getLogLikelihoodJacobian(sample)[2] > 0.0) {
                            this.setShape(maxShape);
                        } else {
                            this.setShape(minShape);
                        }
                    } else {
                        this.setShape(shape);
                    }
                }
            }
            for (int i = 0; i < sample.length; ++i) {
                gumbelSample[i] = sample[i];
            }
            double newL = this.getLogLikelihood(sample);
            if (!NumericalConstants.isValidValue((double)newL)) {
                return false;
            }
            if (likelihood != null && Math.abs(likelihood - newL) < 1.0E-8) break;
            likelihood = newL;
        }
        return iter != maxIter;
    }

    public double adjustBound(double bound, boolean increase, double[] sample) {
        double adjBound = bound;
        int i = 16;
        boolean isValid = false;
        while (!isValid && NumericalConstants.isValidValue((double)adjBound)) {
            adjBound = increase ? bound + Math.abs(bound) * Math.pow(10.0, -i) : bound - Math.abs(bound) * Math.pow(10.0, -i);
            --i;
            this.setShape(adjBound);
            isValid = NumericalConstants.isValidValue((double)this.getLogLikelihood(sample)) && NumericalConstants.isValidValue((double)this.getLogLikelihoodJacobian(sample)[2]);
        }
        return adjBound;
    }

    public void translateToGumbel(double[] sample) {
        for (int i = 0; i < sample.length; ++i) {
            double logArg = 1.0 - this.getShape() / this.getScale() * (sample[i] - this.getLoctn());
            if (logArg <= 0.0) {
                logArg = 1.0E-8;
            }
            sample[i] = this.getLoctn() - this.getScale() / this.getShape() * Math.log(logArg);
        }
    }
}

