/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.ContDist;
import hec.statistics.NormalDist;
import java.util.Arrays;
import java.util.Random;

public class GoodnessOfFit {
    public static double KolmogorovSmirnov(double[] data, ContDist dist) {
        int size;
        int n = size = data == null ? 0 : data.length;
        if (dist == null || size < 1) {
            return Double.NaN;
        }
        double fit = 0.0;
        int i = 0;
        for (double value : data) {
            double diff1 = (double)i / (double)size - dist.getCDF(value);
            double diff2 = ((double)i + 1.0) / (double)size - dist.getCDF(value);
            fit = Math.max(fit, Math.max(Math.abs(diff1), Math.abs(diff2)));
            ++i;
        }
        return fit;
    }

    public static double ChiSquared(double[] data, ContDist dist) {
        int numParams;
        if (dist == null || dist.getParamNames() == null || GoodnessOfFit.paramsInvalid(dist)) {
            return Double.NaN;
        }
        int size = data == null ? 0 : data.length;
        int numBins = size / 5;
        int dof = numBins - ((numParams = dist.getParamNames().length) + 1);
        if (dof < 1) {
            return Double.NaN;
        }
        double binProb = 1.0 / (double)numBins;
        double[] binEdges = new double[numBins + 1];
        binEdges[0] = Double.NEGATIVE_INFINITY;
        for (int i = 1; i < numBins; ++i) {
            binEdges[i] = dist.invCDF((double)i * binProb);
        }
        binEdges[numBins] = Double.POSITIVE_INFINITY;
        return GoodnessOfFit.ChiSquared(data, binEdges, dist);
    }

    private static boolean paramsInvalid(ContDist dist) {
        for (double par : dist.getParamVals()) {
            if (!Double.isNaN(par)) continue;
            return true;
        }
        return false;
    }

    public static double ChiSquared(double[] data, double[] binEdges, ContDist dist) {
        int size;
        if (dist == null || dist.getParamNames() == null || binEdges == null) {
            return Double.NaN;
        }
        int numBins = binEdges.length - 1;
        int numParams = dist.getParamNames().length;
        int dof = numBins - (numParams + 1);
        int n = size = data == null ? 0 : data.length;
        if (dof < 1 || size < 1) {
            return Double.NaN;
        }
        double numExp = (double)size / (double)numBins;
        double fit = 0.0;
        int i = 0;
        for (int j = 0; j < numBins; ++j) {
            int numObs = 0;
            double binRightEdge = binEdges[j + 1];
            while (i < size && data[i] < binRightEdge) {
                ++i;
                ++numObs;
            }
            double diff = (double)numObs - numExp;
            fit += diff * diff / numExp;
        }
        return fit;
    }

    public static double AndersonDarling(double[] data, ContDist dist) {
        int size;
        int n = size = data == null ? 0 : data.length;
        if (dist == null || size < 1) {
            return Double.NaN;
        }
        double sum = 0.0;
        int i = 0;
        for (double value : data) {
            double qtile = dist.getCDF(value);
            if (!(qtile <= 0.0) && !(qtile >= 1.0)) {
                sum += ((double)(2 * i) + 1.0) * Math.log(qtile) + ((double)(2 * (size - i)) - 1.0) * Math.log(1.0 - qtile);
            }
            ++i;
        }
        return (double)(-size) - sum / (double)size;
    }

    public static double AndersonDarlingRightTailWeighted(double[] data, ContDist dist) {
        if (data == null) {
            return Double.NaN;
        }
        int size = data.length;
        if (size <= 1) {
            return Double.NaN;
        }
        if (dist.getType().equals("Triangular") || dist.getType().equals("Beta4Param") || dist.getType().equals("Uniform")) {
            throw new IllegalArgumentException("Cannot compute a meaningful right tail weighted Anderson Darling test statistic for a bounded distribution");
        }
        double sum = 0.0;
        for (int i = 1; i <= data.length; ++i) {
            double z = dist.getCDF(data[i - 1]);
            sum += (2.0 - (2.0 * (double)i - 1.0) / (double)data.length) * Math.log(1.0 - z) + 2.0 * z;
        }
        return (double)data.length / 2.0 - sum;
    }

    public static double BayesianIC(double[] data, ContDist dist) {
        int size;
        int n = size = data == null ? 0 : data.length;
        if (dist == null || size < 2) {
            return Double.NaN;
        }
        String[] params = dist.getParamNames();
        int sizeP = params == null ? 0 : params.length;
        double logL = 0.0;
        for (double value : data) {
            double pdf = dist.getPDF(value);
            if (pdf <= 0.0 || pdf >= Double.POSITIVE_INFINITY) continue;
            logL += Math.log(pdf);
        }
        return (double)sizeP * Math.log(size) - 2.0 * logL;
    }

    public static double AkaikeIC(double[] data, ContDist dist) {
        int sizeP;
        int size = data == null ? 0 : data.length;
        String[] params = dist == null ? null : dist.getParamNames();
        int n = sizeP = params == null ? 0 : params.length;
        if (dist == null || size - sizeP - 1 <= 0) {
            return Double.NaN;
        }
        double logL = 0.0;
        for (double value : data) {
            double pdf = dist.getPDF(value);
            if (pdf <= 0.0) continue;
            logL += Math.log(pdf);
        }
        return 2.0 * (double)size * (double)sizeP / (double)(size - sizeP - 1) - 2.0 * logL;
    }

    public static void main(String[] args) {
        long seed = 12345L;
        Random rdm = new Random(seed);
        NormalDist n = new NormalDist(300.0, 50.0);
        double[] data = new double[46];
        for (int i = 0; i < 46; ++i) {
            data[i] = n.invCDF(rdm.nextDouble());
        }
        Arrays.sort(data);
        double x2 = GoodnessOfFit.ChiSquared(data, n);
        System.out.println("X2 = " + x2);
    }
}

