/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.ContDist;
import hec.statistics.GoodnessOfFit;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum GoodnessOfFittingTests {
    KOLMOGOROVSMIRNOV,
    CHISQUARED,
    ANDERSONDARLING,
    BAYESIANIC,
    AKAIKEIC;

    private double _test;
    private double[] _sortedData;

    public String toString() {
        String name = "";
        switch (this.ordinal()) {
            case 0: {
                name = "Kolmogorov-Smirnov";
                break;
            }
            case 1: {
                name = "Chi-Square";
                break;
            }
            case 2: {
                name = "Anderson-Darling";
                break;
            }
            case 3: {
                name = "Bayesian Information Criterion";
                break;
            }
            case 4: {
                name = "Akaike Information Criterion";
                break;
            }
            default: {
                name = "";
            }
        }
        return name;
    }

    public double calculateGoodnessOfFittingTest(double[] data, ContDist dist) {
        this._sortedData = (double[])data.clone();
        Arrays.sort(this._sortedData);
        switch (this.ordinal()) {
            case 0: {
                this._test = GoodnessOfFit.KolmogorovSmirnov(this._sortedData, dist);
                break;
            }
            case 1: {
                this._test = GoodnessOfFit.ChiSquared(this._sortedData, dist);
                break;
            }
            case 2: {
                this._test = GoodnessOfFit.AndersonDarling(this._sortedData, dist);
                break;
            }
            case 3: {
                this._test = GoodnessOfFit.BayesianIC(this._sortedData, dist);
                break;
            }
            case 4: {
                this._test = GoodnessOfFit.AkaikeIC(this._sortedData, dist);
                break;
            }
            default: {
                this._test = Double.NaN;
            }
        }
        return this._test;
    }

    public static GoodnessOfFittingTests[] getNonBlackListedValues() {
        String blackListedTestsStr = System.getProperty("GoodnessOfFittingTest.Blacklist");
        if (blackListedTestsStr == null) {
            blackListedTestsStr = "";
        }
        List blackListedTests = Arrays.asList(blackListedTestsStr.split(",")).stream().map(test -> test.trim().toLowerCase()).collect(Collectors.toList());
        GoodnessOfFittingTests[] tests = (GoodnessOfFittingTests[])Arrays.stream(GoodnessOfFittingTests.values()).filter(test -> !blackListedTests.contains(test.name().toLowerCase())).toArray(GoodnessOfFittingTests[]::new);
        return tests;
    }
}

