/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.EquationSolverNewton;
import hec.statistics.LinearMoments;
import hec.statistics.MaximumLikelihood;
import hec.statistics.ProductMoments;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class GumbelDist
extends AbstractContDist {
    private static final double MIN_SCALE = 1.0E-5;
    private double _loctn;
    private double _scale;

    public GumbelDist() {
        this(0.0, 1.0);
    }

    public GumbelDist(double loctn, double scale) {
        this.setLoctn(loctn);
        this.setScale(scale);
    }

    public GumbelDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public GumbelDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        this.setScale(Math.sqrt(6.0) * pm.getStDv() / Math.PI);
        this.setLoctn(pm.getMean() - this.getScale() * 0.5772156649015329);
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        this.setScale(lm.getL2() / Math.log(2.0));
        this.setLoctn(lm.getL1() - this.getScale() * 0.5772156649015329);
        return true;
    }

    public void setLoctn(double loctn) {
        this._loctn = loctn;
    }

    public double getLoctn() {
        return this._loctn;
    }

    public void setScale(double scale) {
        if (scale <= 1.0E-5) {
            scale = 1.0E-5;
        }
        this._scale = scale;
    }

    public double getScale() {
        return this._scale;
    }

    @Override
    public String getType() {
        return "Gumbel";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Loctn", "Scale"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getLoctn(), this.getScale()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setLoctn(vals[0]);
        this.setScale(vals[1]);
    }

    @Override
    public Object clone() {
        GumbelDist clonedDist = (GumbelDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("GumbelDistEnd")) {
                    return;
                }
                if (type.equals("Loctn")) {
                    this.setLoctn(Double.parseDouble(param));
                } else if (type.equals("Scale")) {
                    this.setScale(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read GumbelDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "GumbelDistBegin");
        TextFile.writeLine(writer, "Locatn:" + this.getLoctn());
        TextFile.writeLine(writer, "Scale:" + this.getScale());
        TextFile.writeLine(writer, "GumbelDistEnd");
    }

    @Override
    public double getPDF(double value) {
        double z = (value - this._loctn) / this._scale;
        return Math.exp(-z - Math.exp(-z)) / this._scale;
    }

    @Override
    public double getCDF(double value) {
        return Math.exp(-Math.exp(-(value - this._loctn) / this._scale));
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this._loctn - this._scale * Math.log(-Math.log(p));
    }

    @Override
    public boolean fitSampleData(final MaximumLikelihood ml) {
        final double[] mean = new double[]{0.0};
        final int n = ml.getSample().length;
        for (int i = 0; i < n; ++i) {
            mean[0] = mean[0] + ml.getSample()[i] / (double)n;
        }
        this.fitSampleData(new LinearMoments(ml.getSample()));
        final double[] denominator = new double[1];
        EquationSolverNewton newton = new EquationSolverNewton(){

            @Override
            public double f(double x) {
                double numerator = 0.0;
                denominator[0] = 0.0;
                for (int i = 0; i < n; ++i) {
                    double exp = Math.exp(-ml.getSample()[i] / x);
                    numerator += ml.getSample()[i] * exp;
                    denominator[0] = denominator[0] + exp;
                }
                return mean[0] - (x + numerator / denominator[0]);
            }
        };
        double val = newton.newton(0.0, this.getScale(), 1.0E-7, 25, 1.0E-10);
        if (Double.isNaN(val) || Double.compare(0.0, val) == 0) {
            this.setLoctn(Double.NaN);
            this.setScale(Double.NaN);
            return false;
        }
        this.setScale(val);
        this.setLoctn(val * Math.log((double)n / denominator[0]));
        return true;
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        double retval = 0.0;
        for (int i = 0; i < sample.length; ++i) {
            retval += -(sample[i] - this.getLoctn()) / this.getScale() - Math.exp(-(sample[i] - this.getLoctn()) / this.getScale());
        }
        return retval - (double)sample.length * Math.log(this.getScale());
    }
}

