/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.NormalDist;
import hec.statistics.ProductMoments;
import java.io.BufferedReader;
import java.io.BufferedWriter;

public class HalfNormalDist
extends AbstractContDist {
    private NormalDist _normalDist = new NormalDist();
    private boolean _isUpperHalf = true;

    public HalfNormalDist(boolean isUpperHalf) {
        this._isUpperHalf = isUpperHalf;
    }

    private double adjustProb(double p) {
        p = 0.5 * p;
        if (this._isUpperHalf) {
            p += 0.5;
        }
        return p;
    }

    @Override
    public double getPDF(double value) {
        if (this._isUpperHalf && value < 0.0) {
            return 0.0;
        }
        if (!this._isUpperHalf && value > 0.0) {
            return 0.0;
        }
        return this._normalDist.getPDF(value) * 2.0;
    }

    @Override
    public double getCDF(double value) {
        if (this._isUpperHalf && value < 0.0) {
            return 0.0;
        }
        if (!this._isUpperHalf && value > 0.0) {
            return 1.0;
        }
        double retval = this._normalDist.getCDF(value) * 2.0;
        if (this._isUpperHalf) {
            retval -= 1.0;
        }
        return retval;
    }

    @Override
    public double invCDF(double p) {
        return this._normalDist.invCDF(this.adjustProb(p));
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        return false;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        return false;
    }

    @Override
    public void read(BufferedReader reader) {
    }

    @Override
    public void write(BufferedWriter writer) {
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String[] getParamNames() {
        return new String[0];
    }

    @Override
    public double[] getParamVals() {
        return new double[0];
    }

    @Override
    public void setParamVals(double[] vals) {
    }
}

