/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.EquationSolverBiSearch;
import hec.statistics.EquationSolverNewton;
import hec.statistics.GevDist;
import hec.statistics.LinearMoments;
import hec.statistics.ProductMoments;
import hec.statistics.SpecialFunctions;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class KappaDist
extends AbstractContDist {
    private static final double MIN_SCALE = 1.0E-5;
    private double _loctn;
    private double _scale;
    private double _shape1;
    private double _shape2;

    public KappaDist() {
        this(0.0, 1.0, 0.0, 0.0);
    }

    public KappaDist(double loctn, double scale, double shape1, double shape2) {
        this.setLoctn(loctn);
        this.setScale(scale);
        this.setShape1(shape1);
        this.setShape2(shape2);
    }

    public KappaDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public KappaDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    public boolean fitSampleDataGivenShape2(double[] sample, AbstractContDist.FittingMethod method, double shp2) {
        switch (method) {
            default: {
                ProductMoments pm = new ProductMoments(sample);
                return this.fitSampleDataGivenShape2(pm, shp2);
            }
            case LinearMoments: 
        }
        LinearMoments lm = new LinearMoments(sample);
        return this.fitSampleDataGivenShape2(lm, shp2);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        this.setShape1(Double.NaN);
        this.setShape2(Double.NaN);
        return this.fitScaleLoctnAfterShapes(pm) && !Double.isNaN(this.getShape2()) && !Double.isNaN(this.getShape1());
    }

    public boolean fitSampleDataGivenShape2(ProductMoments pm, final double shp2) {
        this.setShape2(shp2);
        if (!(Math.abs(shp2) < 1.0E-8)) {
            if (shp2 < 0.0) {
                EquationSolverBiSearch solverShapePN = new EquationSolverBiSearch(){

                    @Override
                    public double f(double x) {
                        double termB1 = Math.pow(-shp2, -(1.0 + x)) * SpecialFunctions.beta(1.0 + x, -x - 1.0 / shp2);
                        double termB2 = Math.pow(-shp2, -(1.0 + 2.0 * x)) * SpecialFunctions.beta(1.0 + 2.0 * x, -2.0 * x - 1.0 / shp2);
                        double termB3 = Math.pow(-shp2, -(1.0 + 3.0 * x)) * SpecialFunctions.beta(1.0 + 3.0 * x, -3.0 * x - 1.0 / shp2);
                        return -Math.signum(x) * (termB3 - 3.0 * termB2 * termB1 + 2.0 * termB1 * termB1 * termB1) / Math.pow(termB2 - termB1 * termB1, 1.5);
                    }
                };
                this.setShape1(solverShapePN.biSearch(pm.getSkew(), -0.33333333, -0.33333333 / shp2, 1.0E-8));
            } else if (pm.getSkew() < -2.0 * (1.0 - shp2) * Math.sqrt(1.0 + 2.0 * shp2) / (1.0 + 3.0 * shp2)) {
                EquationSolverNewton solverShapeP1 = new EquationSolverNewton(){

                    @Override
                    public double f(double x) {
                        double termB1 = Math.pow(shp2, -(1.0 + x)) * SpecialFunctions.beta(1.0 + x, 1.0 / shp2);
                        double termB2 = Math.pow(shp2, -(1.0 + 2.0 * x)) * SpecialFunctions.beta(1.0 + 2.0 * x, 1.0 / shp2);
                        double termB3 = Math.pow(shp2, -(1.0 + 3.0 * x)) * SpecialFunctions.beta(1.0 + 3.0 * x, 1.0 / shp2);
                        return Math.log(Math.signum(x) * (termB3 - 3.0 * termB2 * termB1 + 2.0 * termB1 * termB1 * termB1) / Math.pow(termB2 - termB1 * termB1, 1.5));
                    }
                };
                this.setShape1(solverShapeP1.newton(Math.log(-pm.getSkew()), 1.0, 1.0E-8, 100, 1.0E-10));
            } else {
                EquationSolverBiSearch solverShapeP2 = new EquationSolverBiSearch(){

                    @Override
                    public double f(double x) {
                        double termB1 = Math.pow(shp2, -(1.0 + x)) * SpecialFunctions.beta(1.0 + x, 1.0 / shp2);
                        double termB2 = Math.pow(shp2, -(1.0 + 2.0 * x)) * SpecialFunctions.beta(1.0 + 2.0 * x, 1.0 / shp2);
                        double termB3 = Math.pow(shp2, -(1.0 + 3.0 * x)) * SpecialFunctions.beta(1.0 + 3.0 * x, 1.0 / shp2);
                        return -Math.signum(x) * (termB3 - 3.0 * termB2 * termB1 + 2.0 * termB1 * termB1 * termB1) / Math.pow(termB2 - termB1 * termB1, 1.5);
                    }
                };
                this.setShape1(solverShapeP2.biSearch(pm.getSkew(), -0.33333333, 1.0, 1.0E-8));
            }
        }
        return this.fitScaleLoctnAfterShapes(pm) && !Double.isNaN(this.getShape1());
    }

    public boolean fitSampleDataGivenShape1(ProductMoments pm, double shp1) {
        this.setShape1(shp1);
        this.setShape2(Double.NaN);
        return this.fitScaleLoctnAfterShapes(pm) && !Double.isNaN(this.getShape2());
    }

    private boolean fitScaleLoctnAfterShapes(ProductMoments pm) {
        double shp1 = this.getShape1();
        double shp2 = this.getShape2();
        if (Math.abs(shp2) < 1.0E-8) {
            GevDist gev = new GevDist();
            gev.fitSampleData(pm);
            this.setShape1(gev.getShape());
            this.setScale(gev.getScale());
            this.setLoctn(gev.getLoctn());
        } else if (Math.abs(shp1) < 1.0E-8) {
            double b1P;
            double b1;
            double b1M;
            double eps = 1.0E-8;
            double shp1M = shp1 - eps;
            double shp1P = shp1 + eps;
            if (shp2 < 0.0) {
                b1M = Math.pow(-shp2, -(1.0 + shp1M)) * SpecialFunctions.beta(1.0 + shp1M, -shp1M - 1.0 / shp2);
                b1 = Math.pow(-shp2, -(1.0 + shp1)) * SpecialFunctions.beta(1.0 + shp1, -shp1 - 1.0 / shp2);
                b1P = Math.pow(-shp2, -(1.0 + shp1P)) * SpecialFunctions.beta(1.0 + shp1P, -shp1P - 1.0 / shp2);
            } else {
                b1M = Math.pow(shp2, -(1.0 + shp1M)) * SpecialFunctions.beta(1.0 + shp1M, 1.0 / shp2);
                b1 = Math.pow(shp2, -(1.0 + shp1)) * SpecialFunctions.beta(1.0 + shp1, 1.0 / shp2);
                b1P = Math.pow(shp2, -(1.0 + shp1P)) * SpecialFunctions.beta(1.0 + shp1P, 1.0 / shp2);
            }
            double termD1B1 = (b1P - b1M) / (2.0 * eps);
            double termD2B1 = (b1P - 2.0 * b1 + b1M) / (eps * eps);
            this.setScale(pm.getStDv() / Math.sqrt(termD2B1 - termD1B1 * termD1B1));
            this.setLoctn(pm.getMean() + this.getScale() * termD1B1);
        } else {
            double termB2;
            double termB1;
            if (shp2 < 0.0) {
                termB1 = Math.pow(-shp2, -(1.0 + shp1)) * SpecialFunctions.beta(1.0 + shp1, -shp1 - 1.0 / shp2);
                termB2 = Math.pow(-shp2, -(1.0 + 2.0 * shp1)) * SpecialFunctions.beta(1.0 + 2.0 * shp1, -2.0 * shp1 - 1.0 / shp2);
            } else {
                termB1 = Math.pow(shp2, -(1.0 + shp1)) * SpecialFunctions.beta(1.0 + shp1, 1.0 / shp2);
                termB2 = Math.pow(shp2, -(1.0 + 2.0 * shp1)) * SpecialFunctions.beta(1.0 + 2.0 * shp1, 1.0 / shp2);
            }
            this.setScale(pm.getStDv() * Math.abs(this.getShape1()) / Math.sqrt(termB2 - termB1 * termB1));
            this.setLoctn(pm.getMean() - this.getScale() * (1.0 - termB1) / this.getShape1());
        }
        return !Double.isNaN(this.getScale());
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        this.setShape1(Double.NaN);
        this.setShape2(Double.NaN);
        return this.fitScaleLoctnAfterShapes(lm) && !Double.isNaN(this.getShape2()) && !Double.isNaN(this.getShape1());
    }

    public boolean fitSampleDataGivenShape2(LinearMoments lm, final double shp2) {
        this.setShape2(shp2);
        if (!(Math.abs(shp2) < 1.0E-8)) {
            if (shp2 < 0.0) {
                final double endTerm = Math.exp(-(1.0 - 1.0 / shp2));
                EquationSolverBiSearch solverShapeLN = new EquationSolverBiSearch(){

                    @Override
                    public double f(double x) {
                        if (x == endTerm) {
                            return 1.0;
                        }
                        if (x == 1.0) {
                            return 2.0;
                        }
                        double logTerm1 = -Math.log(x);
                        double logTerm2 = 1.0 - logTerm1;
                        double termC1 = 1.0 * Math.pow(-shp2, -logTerm1) * SpecialFunctions.beta(logTerm1, logTerm2 - 1.0 / shp2);
                        double termC2 = 2.0 * Math.pow(-shp2, -logTerm1) * SpecialFunctions.beta(logTerm1, logTerm2 - 2.0 / shp2);
                        double termC3 = 3.0 * Math.pow(-shp2, -logTerm1) * SpecialFunctions.beta(logTerm1, logTerm2 - 3.0 / shp2);
                        return (termC3 - termC1) / (termC2 - termC1);
                    }
                };
                double xTerm = solverShapeLN.biSearch(0.5 * (3.0 + lm.getT3()), endTerm, 1.0, 1.0E-8);
                this.setShape1(-(1.0 + Math.log(xTerm)));
            } else {
                EquationSolverBiSearch solverShapeLP = new EquationSolverBiSearch(){

                    @Override
                    public double f(double x) {
                        if (x == 0.0) {
                            return 1.0;
                        }
                        if (x == 1.0) {
                            return 2.0;
                        }
                        double logTerm1 = -Math.log(x);
                        double termC1 = 1.0 * Math.pow(shp2, -logTerm1) * SpecialFunctions.beta(logTerm1, 1.0 / shp2);
                        double termC2 = 2.0 * Math.pow(shp2, -logTerm1) * SpecialFunctions.beta(logTerm1, 2.0 / shp2);
                        double termC3 = 3.0 * Math.pow(shp2, -logTerm1) * SpecialFunctions.beta(logTerm1, 3.0 / shp2);
                        return (termC3 - termC1) / (termC2 - termC1);
                    }
                };
                double xTerm = solverShapeLP.biSearch(0.5 * (3.0 + lm.getT3()), 0.0, 1.0, 1.0E-8);
                this.setShape1(-(1.0 + Math.log(xTerm)));
            }
        }
        return this.fitScaleLoctnAfterShapes(lm) && !Double.isNaN(this.getShape1());
    }

    public boolean fitSampleDataGivenShape1(LinearMoments lm, double shp1) {
        this.setShape1(shp1);
        this.setShape2(Double.NaN);
        return this.fitScaleLoctnAfterShapes(lm) && !Double.isNaN(this.getShape2());
    }

    private boolean fitScaleLoctnAfterShapes(LinearMoments lm) {
        double shp1 = this.getShape1();
        double shp2 = this.getShape2();
        if (Math.abs(shp2) < 1.0E-8) {
            GevDist gev = new GevDist();
            gev.fitSampleData(lm);
            this.setShape1(gev.getShape());
            this.setScale(gev.getScale());
            this.setLoctn(gev.getLoctn());
        } else if (Math.abs(shp1) < 1.0E-8) {
            double log;
            double diGamma2;
            double diGamma1;
            if (shp2 < 0.0) {
                diGamma1 = SpecialFunctions.digamma(-1.0 / shp2);
                diGamma2 = SpecialFunctions.digamma(-2.0 / shp2);
                log = Math.log(-shp2);
            } else {
                diGamma1 = SpecialFunctions.digamma(1.0 + 1.0 / shp2);
                diGamma2 = SpecialFunctions.digamma(1.0 + 2.0 / shp2);
                log = Math.log(shp2);
            }
            double cp1 = -0.5772156649015329 - log - diGamma1;
            double cp1MinusCp2 = diGamma2 - diGamma1;
            this.setScale(lm.getL2() / cp1MinusCp2);
            this.setLoctn(lm.getL1() + this.getScale() * cp1);
        } else {
            double termC2;
            double termC1;
            if (shp2 < 0.0) {
                termC1 = Math.pow(-shp2, -(1.0 + shp1)) * SpecialFunctions.beta(1.0 + shp1, -shp1 - 1.0 / shp2);
                termC2 = 2.0 * Math.pow(-shp2, -(1.0 + shp1)) * SpecialFunctions.beta(1.0 + shp1, -shp1 - 2.0 / shp2);
            } else {
                termC1 = Math.pow(shp2, -(1.0 + shp1)) * SpecialFunctions.beta(1.0 + shp1, 1.0 / shp2);
                termC2 = 2.0 * Math.pow(shp2, -(1.0 + shp1)) * SpecialFunctions.beta(1.0 + shp1, 2.0 / shp2);
            }
            this.setScale(lm.getL2() * this.getShape1() / (termC1 - termC2));
            this.setLoctn(lm.getL1() - this.getScale() * (1.0 - termC1) / this.getShape1());
        }
        return !Double.isNaN(this.getScale());
    }

    public void setLoctn(double loctn) {
        this._loctn = loctn;
    }

    public double getLoctn() {
        return this._loctn;
    }

    public void setScale(double scale) {
        if (scale <= 1.0E-5) {
            scale = 1.0E-5;
        }
        this._scale = scale;
    }

    public double getScale() {
        return this._scale;
    }

    public void setShape1(double shape1) {
        this._shape1 = shape1;
    }

    public double getShape1() {
        return this._shape1;
    }

    public void setShape2(double shape2) {
        this._shape2 = shape2;
    }

    public double getShape2() {
        return this._shape2;
    }

    @Override
    public String getType() {
        return "Kappa";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Loctn", "Scale", "Shape1", "Shape2"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getLoctn(), this.getScale(), this.getShape1(), this.getShape2()};
    }

    @Override
    public Object clone() {
        KappaDist clonedDist = (KappaDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("KappaDistEnd")) {
                    return;
                }
                if (type.equals("Loctn")) {
                    this.setLoctn(Double.parseDouble(param));
                } else if (type.equals("Scale")) {
                    this.setScale(Double.parseDouble(param));
                } else if (type.equals("Shape1")) {
                    this.setShape1(Double.parseDouble(param));
                } else if (type.equals("Shape2")) {
                    this.setShape2(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read KAPPADist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "KappaDistBegin");
        TextFile.writeLine(writer, "Locatn:" + this.getLoctn());
        TextFile.writeLine(writer, "Scale:" + this.getScale());
        TextFile.writeLine(writer, "Shape1:" + this.getShape1());
        TextFile.writeLine(writer, "Shape2:" + this.getShape2());
        TextFile.writeLine(writer, "KappaDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (this._shape1 < 0.0 && this._shape2 <= 0.0 && value <= this._loctn + this._scale / this._shape1) {
            return 0.0;
        }
        if (this._shape1 > 0.0 && value >= this._loctn + this._scale / this._shape1) {
            return 0.0;
        }
        if (this._shape2 > 0.0 && value <= SpecialFunctions.tInv(this._loctn, this._scale, this._shape1, 1.0 / this._shape2)) {
            return 0.0;
        }
        double tx = SpecialFunctions.t(this._loctn, this._scale, this._shape1, value);
        return Math.pow(tx, 1.0 - this._shape1) * Math.pow(SpecialFunctions.t(0.0, 1.0, this._shape2, tx), 1.0 - this._shape2) / this._scale;
    }

    @Override
    public double getCDF(double value) {
        if (this._shape1 < 0.0 && this._shape2 <= 0.0 && value <= this._loctn + this._scale / this._shape1) {
            return 0.0;
        }
        if (this._shape1 > 0.0 && value >= this._loctn + this._scale / this._shape1) {
            return 1.0;
        }
        if (this._shape2 > 0.0 && value <= SpecialFunctions.tInv(this._loctn, this._scale, this._shape1, 1.0 / this._shape2)) {
            return 0.0;
        }
        return SpecialFunctions.t(0.0, 1.0, this._shape2, SpecialFunctions.t(this._loctn, this._scale, this._shape1, value));
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            if (this._shape2 > 0.0) {
                return SpecialFunctions.tInv(this._loctn, this._scale, this._shape1, 1.0 / this._shape2);
            }
            return this._shape1 < 0.0 ? this._loctn + this._scale / this._shape1 : Double.NEGATIVE_INFINITY;
        }
        if (p >= 1.0) {
            return this._shape1 > 0.0 ? this._loctn + this._scale / this._shape1 : Double.POSITIVE_INFINITY;
        }
        return SpecialFunctions.tInv(this._loctn, this._scale, this._shape1, SpecialFunctions.tInv(0.0, 1.0, this._shape2, p));
    }

    public static void main(String[] args) {
        double[] data = new double[]{24200.0, 59700.0, 156000.0, 10300.0, 119000.0, 81300.0, 94950.0, 5814.0, 10771.0, 74100.0, 39900.0, 40700.0, 42300.0, 14928.0, 67500.0, 15100.0, 39200.0, 31600.0, 39000.0, 14000.0, 99500.0, 27400.0, 67700.0, 163000.0, 19667.0, 24400.0, 9900.0, 21100.0, 6437.0, 22600.0, 52900.0, 58300.0, 33000.0, 114000.0, 10900.0, 89200.0, 38800.0, 83200.0, 152000.0, 20100.0, 94400.0, 42200.0, 27900.0, 21000.0, 37500.0, 34400.0, 180000.0, 37200.0, 48400.0, 42600.0, 10800.0, 219000.0, 42000.0, 54000.0, 20000.0, 75000.0, 8000.0, 40000.0, 240000.0, 24000.0, 260000.0, 6500.0, 46000.0, 30000.0, 120000.0, 122000.0, 48000.0, 12000.0, 69000.0, 55000.0, 46000.0, 15000.0, 2500.0, 40000.0, 33000.0, 175000.0, 20000.0, 152000.0, 93000.0, 88000.0, 17000.0, 255000.0, 15455.0, 7083.0, 45935.0, 8497.0, 36849.0, 17587.0, 46342.0, 6226.0, 93771.0, 73960.0, 300000.0, 56016.0, 69852.0, 67061.0, 6244.0, 21015.0, 21282.0, 20972.0, 50226.0, 190111.0, 33522.0, 10710.0, 40419.0, 12502.0, 62669.0};
        LinearMoments lm = new LinearMoments(data);
        System.out.println("L1=" + lm.getL1() + " L2=" + lm.getL2() + " T3=" + lm.getT3());
        KappaDist kap = new KappaDist(data);
        System.out.println("Loc=" + kap.getLoctn() + " Scl=" + kap.getScale() + " Shp1=" + kap.getShape1() + " Shp2=" + kap.getShape2());
        kap.fitSampleData(lm);
        System.out.println("Loc=" + kap.getLoctn() + " Scl=" + kap.getScale() + " Shp1=" + kap.getShape1() + " Shp2=" + kap.getShape2());
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setLoctn(vals[0]);
        this.setScale(vals[1]);
        this.setShape1(vals[2]);
        this.setShape2(vals[3]);
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        int n = sample.length;
        double e = this.getLoctn();
        double a = this.getScale();
        double k = this.getShape1();
        double h = this.getShape2();
        double term1 = (double)(-n) * Math.log(this.getScale());
        double term2 = 0.0;
        double term3 = 0.0;
        for (int i = 0; i < sample.length; ++i) {
            term2 += Math.log(1.0 - k * (sample[i] - e) / a);
            term3 += Math.log(1.0 - h * Math.pow(1.0 - k * (sample[i] - e) / a, 1.0 / k));
        }
        return term1 + (term2 *= 1.0 / k - 1.0) + (term3 *= 1.0 / h - 1.0);
    }
}

