/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import java.util.logging.Level;
import java.util.logging.Logger;

public class LinearAlgebra {
    private static final Logger LOGGER = Logger.getLogger(LinearAlgebra.class.getName());

    private LinearAlgebra() {
        throw new IllegalStateException("LinearAlgebra class contains only static methods");
    }

    static void matMultAB(double[] A, double[] B, double[] C, int nra, int nca, int ncb) {
        if (A == null || B == null || C == null) {
            return;
        }
        if (A.length != nra * nca) {
            return;
        }
        if (B.length != nca * ncb) {
            return;
        }
        if (C.length != nra * ncb) {
            return;
        }
        for (int i = 0; i < nra; ++i) {
            for (int j = 0; j < ncb; ++j) {
                C[i * ncb + j] = 0.0;
                for (int k = 0; k < nca; ++k) {
                    int n = i * ncb + j;
                    C[n] = C[n] + A[i * nca + k] * B[k * ncb + j];
                }
            }
        }
    }

    private static boolean luDComp(double[] a, int n, int[] indx, int[] d) {
        int j;
        double big;
        int i;
        int imax = 0;
        double[] vv = new double[n];
        d[0] = 1;
        for (i = 0; i < n; ++i) {
            big = 0.0;
            for (j = 0; j < n; ++j) {
                double temp = Math.abs(a[i * n + j]);
                if (!(temp > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "ludcomp: Error-singular matrix");
                }
                return false;
            }
            vv[i] = 1.0 / big;
        }
        for (j = 0; j < n; ++j) {
            double dum;
            int k;
            double sum;
            for (i = 0; i < j; ++i) {
                sum = a[i * n + j];
                for (k = 0; k < i; ++k) {
                    sum -= a[i * n + k] * a[k * n + j];
                }
                a[i * n + j] = sum;
            }
            big = 0.0;
            for (i = j; i < n; ++i) {
                sum = a[i * n + j];
                for (k = 0; k < j; ++k) {
                    sum -= a[i * n + k] * a[k * n + j];
                }
                a[i * n + j] = sum;
                dum = vv[i] * Math.abs(sum);
                if (!(dum >= big)) continue;
                big = dum;
                imax = i;
            }
            if (j != imax) {
                for (k = 0; k < n; ++k) {
                    dum = a[imax * n + k];
                    a[imax * n + k] = a[j * n + k];
                    a[j * n + k] = dum;
                }
                d[0] = d[0] * -1;
                vv[imax] = vv[j];
            }
            indx[j] = imax;
            if (a[j * n + j] == 0.0) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "ludcomp: Error-singular matrix");
                }
                return false;
            }
            if (j == n - 1) continue;
            dum = 1.0 / a[j * n + j];
            for (i = j + 1; i < n; ++i) {
                int n2 = i * n + j;
                a[n2] = a[n2] * dum;
            }
        }
        return true;
    }

    private static void luBackSub(double[] a, int n, int[] indx, double[] b) {
        int j;
        double sum;
        int i;
        int ii = -1;
        for (i = 0; i < n; ++i) {
            int ip = indx[i];
            sum = b[ip];
            b[ip] = b[i];
            if (ii >= 0) {
                for (j = ii; j <= i - 1; ++j) {
                    sum -= a[i * n + j] * b[j];
                }
            } else if (sum != 0.0) {
                ii = i;
            }
            b[i] = sum;
        }
        for (i = n - 1; i >= 0; --i) {
            sum = b[i];
            for (j = i + 1; j < n; ++j) {
                sum -= a[i * n + j] * b[j];
            }
            b[i] = sum / a[i * n + i];
        }
    }

    static boolean invertMatrix(double[] a) {
        int i;
        if (a == null) {
            return false;
        }
        int n = (int)Math.sqrt(a.length);
        if (n * n != a.length) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "invertMatrix: Error - input matrix is not square");
            }
            return false;
        }
        int[] indx = new int[n];
        int[] d = new int[1];
        double[] col = new double[n];
        double[] y = new double[n * n];
        if (!LinearAlgebra.luDComp(a, n, indx, d)) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "invertMatrix: Error - luDComp failed");
            }
            return false;
        }
        for (int j = 0; j < n; ++j) {
            for (i = 0; i < n; ++i) {
                col[i] = 0.0;
            }
            col[j] = 1.0;
            LinearAlgebra.luBackSub(a, n, indx, col);
            for (i = 0; i < n; ++i) {
                y[i * n + j] = col[i];
            }
        }
        for (i = 0; i < n * n; ++i) {
            a[i] = y[i];
        }
        return true;
    }
}

