/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import java.util.ArrayList;
import java.util.Arrays;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class LinearMoments {
    private final double l1;
    private final double l2;
    private final double t3;
    private final double t4;

    public LinearMoments(double[] data) {
        double cl3;
        double cl2;
        if (data == null) {
            this.l1 = 0.0;
            this.l2 = 0.0;
            this.t3 = 0.0;
            this.t4 = 0.0;
            return;
        }
        ArrayList<Double> validValues = new ArrayList<Double>();
        for (double value : data) {
            if (!NumericalConstants.isValidValue((double)value)) continue;
            validValues.add(value);
        }
        double[] arrayCopy = validValues.stream().mapToDouble(Double::doubleValue).toArray();
        Arrays.sort(arrayCopy);
        int size = arrayCopy.length;
        double sl1 = 0.0;
        double sl2 = 0.0;
        double sl3 = 0.0;
        double sl4 = 0.0;
        for (int i = 0; i < size; ++i) {
            double cl1 = i;
            cl2 = cl1 * (double)(i - 1) / 2.0;
            cl3 = cl2 * (double)(i - 2) / 3.0;
            double cr1 = size - (i + 1);
            double cr2 = cr1 * (double)(size - (i + 2)) / 2.0;
            double cr3 = cr2 * (double)(size - (i + 3)) / 3.0;
            sl1 += arrayCopy[i];
            sl2 += arrayCopy[i] * (cl1 - cr1);
            sl3 += arrayCopy[i] * (cl2 - 2.0 * cl1 * cr1 + cr2);
            sl4 += arrayCopy[i] * (cl3 - 3.0 * cl2 * cr1 + 3.0 * cl1 * cr2 - cr3);
        }
        double cl1 = size;
        cl2 = cl1 * (double)(size - 1);
        cl3 = cl2 * (double)(size - 2) / 2.0;
        double cl4 = cl3 * (double)(size - 3) / 3.0;
        this.l1 = size < 1 ? 0.0 : sl1 / cl1;
        this.l2 = size < 2 ? 0.0 : sl2 / cl2;
        this.t3 = size < 3 || this.l2 == 0.0 ? 0.0 : sl3 / cl3 / this.l2;
        this.t4 = size < 4 || this.l2 == 0.0 ? 0.0 : sl4 / cl4 / this.l2;
    }

    public double getL1() {
        return this.l1;
    }

    public double getL2() {
        return this.l2;
    }

    public double getT3() {
        return this.t3;
    }

    public double getT4() {
        return this.t4;
    }
}

