/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.ClipData;
import hec.statistics.ClipDist;
import hec.statistics.Log10NormalB17BDist;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class Log10NormalB17BClipDist
extends Log10NormalB17BDist
implements ClipDist {
    private ClipData _clip = new ClipData(){

        @Override
        public void setMinVal(double minVal) {
            super.setMinVal(minVal);
            super.setMinProb(Log10NormalB17BClipDist.super.getCDF(minVal));
        }

        @Override
        public void setMinProb(double minProb) {
            super.setMinProb(minProb);
            Log10NormalB17BDist lnd = new Log10NormalB17BDist(Log10NormalB17BClipDist.this.getMeanOfLog(), Log10NormalB17BClipDist.this.getStdvOfLog());
            super.setMinVal(lnd.invCDF(minProb));
        }

        @Override
        public void setMaxVal(double maxVal) {
            super.setMaxVal(maxVal);
            super.setMaxProb(Log10NormalB17BClipDist.super.getCDF(maxVal));
        }

        @Override
        public void setMaxProb(double maxProb) {
            super.setMaxProb(maxProb);
            Log10NormalB17BDist lnd = new Log10NormalB17BDist(Log10NormalB17BClipDist.this.getMeanOfLog(), Log10NormalB17BClipDist.this.getStdvOfLog());
            super.setMaxVal(lnd.invCDF(maxProb));
        }
    };
    static final int COMPUTE_FLAG = 0;

    public Log10NormalB17BClipDist() {
    }

    public Log10NormalB17BClipDist(double meanOfLog, double stdvOfLog) {
        super(meanOfLog, stdvOfLog);
    }

    @Override
    public ClipData getClipData() {
        return this._clip;
    }

    @Override
    public String[] getClipParamNames() {
        if (this.getClipData() == null) {
            return new String[0];
        }
        return this.getClipData().getClipParamNames();
    }

    @Override
    public double[] getClipParamVals() {
        if (this.getClipData() == null) {
            return new double[0];
        }
        return this.getClipData().getClipParamVals();
    }

    @Override
    public String getSummaryClip(String format) {
        if (this.getClipData() == null) {
            return "";
        }
        return this.getClipData().getSummary(format);
    }

    @Override
    public Object clone() {
        Log10NormalB17BClipDist clonedDist = (Log10NormalB17BClipDist)super.clone();
        clonedDist._clip = (ClipData)this._clip.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("Log10NormalClipDistEnd")) {
                    return;
                }
                if (type.equals("MeanOfLog")) {
                    this.setMeanOfLog(Double.parseDouble(param));
                } else if (type.equals("StdvOfLog")) {
                    this.setStdvOfLog(Double.parseDouble(param));
                } else if (type.equals("Parametrization")) {
                    this.setParametrizationName(param);
                } else if (type.equals("ClipDataBegin")) {
                    this._clip.read(reader);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read Log10NormalClipDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "Log10NormalClipDistBegin");
        TextFile.writeLine(writer, "MeanOfLog:" + this.getMeanOfLog());
        TextFile.writeLine(writer, "StdvOfLog:" + this.getStdvOfLog());
        TextFile.writeLine(writer, "Parametrization:" + this.getParametrizationName());
        this._clip.write(writer);
        TextFile.writeLine(writer, "Log10NormalClipDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal() || this.getClipData().hasMaxClip() && value > this.getClipData().getMaxVal()) {
            return 0.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return super.getPDF(value) / rescale;
    }

    @Override
    public double getCDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal()) {
            return 0.0;
        }
        if (this.getClipData().hasMaxClip() && value >= this.getClipData().getMaxVal()) {
            return 1.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return (super.getCDF(value) - minProb) / rescale;
    }

    @Override
    public double invCDF(double p) {
        Log10NormalB17BDist lnd = new Log10NormalB17BDist(this.getMeanOfLog(), this.getStdvOfLog());
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return lnd.invCDF(minProb + p * rescale);
    }
}

