/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.MultiParametrizadDist;
import hec.statistics.NormalDist;
import hec.statistics.ProductMoments;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class Log10NormalDist
extends AbstractContDist
implements MultiParametrizadDist {
    private double _meanOfLog;
    private double _stdvOfLog;
    private String _paramType;

    public Log10NormalDist() {
        this(0.0, 1.0);
    }

    public Log10NormalDist(double meanOfLog, double stdvOfLog) {
        this.setParametrizationName("Logarithmic");
        this.setMeanOfLog(meanOfLog);
        this.setStdvOfLog(stdvOfLog);
    }

    public Log10NormalDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public Log10NormalDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public void setParametrizationName(String p) {
        if ("Logarithmic".equals(p) || "Linear".equals(p)) {
            this._paramType = p;
        }
    }

    @Override
    public String getParametrizationName() {
        return this._paramType;
    }

    @Override
    public void setParametrizationNumber(int num) {
        if (num == 1) {
            this._paramType = "Logarithmic";
        } else if (num == 2) {
            this._paramType = "Linear";
        }
    }

    @Override
    public int getParametrizationNumber() {
        if ("Logarithmic".equals(this.getParametrizationName())) {
            return 1;
        }
        if ("Linear".equals(this.getParametrizationName())) {
            return 2;
        }
        return 0;
    }

    @Override
    public double[] getActiveParams() {
        if ("Logarithmic".equals(this.getParametrizationName())) {
            return this.getParams1();
        }
        if ("Linear".equals(this.getParametrizationName())) {
            return this.getParams2();
        }
        return null;
    }

    @Override
    public String[] getActiveParamNames() {
        if ("Logarithmic".equals(this.getParametrizationName())) {
            return this.getParamNames1();
        }
        if ("Linear".equals(this.getParametrizationName())) {
            return this.getParamNames2();
        }
        return null;
    }

    @Override
    public void setParams1(double[] logParams) {
        if (logParams == null || logParams.length < 2) {
            return;
        }
        double meanOfLog = logParams[0];
        double stdvOfLog = logParams[1];
        this.setMeanOfLog(meanOfLog);
        this.setStdvOfLog(stdvOfLog);
    }

    @Override
    public double[] getParams1() {
        return new double[]{this.getMeanOfLog(), this.getStdvOfLog()};
    }

    @Override
    public String[] getParamNames1() {
        return new String[]{"MeanLog", "StDvLog"};
    }

    @Override
    public void setParams2(double[] linParams) {
        if (linParams == null || linParams.length < 2) {
            return;
        }
        double mean = linParams[0];
        double stdv = linParams[1];
        double ln10 = Math.log(10.0);
        double meanOfLog = (2.0 * Math.log(mean) - 0.5 * Math.log(mean * mean + stdv * stdv)) / ln10;
        double stdvOfLog = Math.sqrt(Math.log(mean * mean + stdv * stdv) - 2.0 * Math.log(mean)) / ln10;
        this.setMeanOfLog(meanOfLog);
        this.setStdvOfLog(stdvOfLog);
    }

    @Override
    public double[] getParams2() {
        double meanOfLog = this.getMeanOfLog();
        double stdvOfLog = this.getStdvOfLog();
        double ln10 = Math.log(10.0);
        double mean = Math.pow(10.0, meanOfLog + ln10 * stdvOfLog * stdvOfLog * 0.5);
        double stdv = mean * Math.sqrt(Math.pow(10.0, stdvOfLog * stdvOfLog * ln10) - 1.0);
        return new double[]{mean, stdv};
    }

    @Override
    public String[] getParamNames2() {
        return new String[]{"Mean", "StDv"};
    }

    @Override
    public boolean fitSampleData(double[] sample, AbstractContDist.FittingMethod method) {
        this.setParametrizationName("Logarithmic");
        int size = sample == null ? 0 : sample.length;
        double[] logSample = new double[size];
        for (int i = 0; i < size; ++i) {
            logSample[i] = Math.log10(sample[i]);
        }
        NormalDist d = new NormalDist();
        boolean fitOK = d.fitSampleData(logSample, method);
        this.setMeanOfLog(d.getMean());
        this.setStdvOfLog(d.getStdv());
        return fitOK;
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        this.setParametrizationName("Logarithmic");
        this.setMeanOfLog(Double.NaN);
        this.setStdvOfLog(Double.NaN);
        return false;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        this.setParametrizationName("Logarithmic");
        this.setMeanOfLog(Double.NaN);
        this.setStdvOfLog(Double.NaN);
        return false;
    }

    public void setMeanOfLog(double meanOfLog) {
        this._meanOfLog = meanOfLog;
    }

    public double getMeanOfLog() {
        return this._meanOfLog;
    }

    public void setStdvOfLog(double stdvOfLog) {
        if (stdvOfLog <= 0.0) {
            stdvOfLog = 0.0;
        }
        this._stdvOfLog = stdvOfLog;
    }

    public double getStdvOfLog() {
        return this._stdvOfLog;
    }

    @Override
    public String getType() {
        return "Log10Normal";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"MeanLog", "StDvLog"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getMeanOfLog(), this.getStdvOfLog()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setMeanOfLog(vals[0]);
        this.setStdvOfLog(vals[1]);
    }

    @Override
    public Object clone() {
        Log10NormalDist clonedDist = (Log10NormalDist)super.clone();
        clonedDist.setParametrizationName(this.getParametrizationName());
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("Log10NormalDistEnd")) {
                    return;
                }
                if (type.equals("MeanOfLog")) {
                    this.setMeanOfLog(Double.parseDouble(param));
                } else if (type.equals("StdvOfLog")) {
                    this.setStdvOfLog(Double.parseDouble(param));
                } else if (type.equals("Parametrization")) {
                    this.setParametrizationName(param);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read Log10NormalDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "Log10NormalDistBegin");
        TextFile.writeLine(writer, "MeanOfLog:" + this.getMeanOfLog());
        TextFile.writeLine(writer, "StdvOfLog:" + this.getStdvOfLog());
        TextFile.writeLine(writer, "Parametrization:" + this.getParametrizationName());
        TextFile.writeLine(writer, "Log10NormalDistEnd");
    }

    @Override
    public double getPDF(double value) {
        NormalDist n = new NormalDist(this._meanOfLog, this._stdvOfLog);
        return n.getPDF(Math.log10(value)) / value / Math.log(10.0);
    }

    @Override
    public double getCDF(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        NormalDist n = new NormalDist(this._meanOfLog, this._stdvOfLog);
        return n.getCDF(Math.log10(value));
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        NormalDist n = new NormalDist(this._meanOfLog, this._stdvOfLog);
        return Math.pow(10.0, n.invCDF(p));
    }
}

