/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.LogisticDist;
import hec.statistics.ProductMoments;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class LogLogisticDist
extends AbstractContDist {
    private static final double MIN_SCALE = 1.0E-5;
    private static final double MIN_SHAPE = 1.0E-5;
    private double _scale;
    private double _shape;

    public LogLogisticDist() {
        this(0.0, 1.0);
    }

    public LogLogisticDist(double scale, double shape) {
        this.setScale(scale);
        this.setShape(shape);
    }

    public LogLogisticDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public LogLogisticDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(double[] sample, AbstractContDist.FittingMethod method) {
        int size = sample == null ? 0 : sample.length;
        double[] logSample = new double[size];
        for (int i = 0; i < size; ++i) {
            logSample[i] = Math.log(sample[i]);
        }
        LogisticDist d = new LogisticDist();
        boolean fitOK = d.fitSampleData(logSample, method);
        this.setScale(Math.exp(d.getLoctn()));
        this.setShape(1.0 / d.getScale());
        return fitOK;
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        this.setScale(Double.NaN);
        this.setShape(Double.NaN);
        return false;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        this.setScale(Double.NaN);
        this.setShape(Double.NaN);
        return false;
    }

    public void setScale(double scale) {
        if (scale <= 1.0E-5) {
            scale = 1.0E-5;
        }
        this._scale = scale;
    }

    public double getScale() {
        return this._scale;
    }

    public void setShape(double shape) {
        if (shape <= 1.0E-5) {
            shape = 1.0E-5;
        }
        this._shape = shape;
    }

    public double getShape() {
        return this._shape;
    }

    @Override
    public String getType() {
        return "LogLogistic";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Scale", "Shape"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getScale(), this.getShape()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setScale(vals[0]);
        this.setShape(vals[1]);
    }

    @Override
    public Object clone() {
        LogLogisticDist clonedDist = (LogLogisticDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("LogLogisticDistEnd")) {
                    return;
                }
                if (type.equals("Scale")) {
                    this.setScale(Double.parseDouble(param));
                } else if (type.equals("Shape")) {
                    this.setShape(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read LogLogisticDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "LogLogisticDistBegin");
        TextFile.writeLine(writer, "Scale:" + this.getScale());
        TextFile.writeLine(writer, "Shape:" + this.getShape());
        TextFile.writeLine(writer, "LogLogisticDistEnd");
    }

    @Override
    public double getPDF(double value) {
        LogisticDist lg = new LogisticDist(Math.log(this.getScale()), 1.0 / this.getShape());
        return lg.getPDF(Math.log(value)) / value;
    }

    @Override
    public double getCDF(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        LogisticDist lg = new LogisticDist(Math.log(this.getScale()), 1.0 / this.getShape());
        return lg.getCDF(Math.log(value));
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        LogisticDist l = new LogisticDist(Math.log(this.getScale()), 1.0 / this.getShape());
        return Math.exp(l.invCDF(p));
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        double firstSum = 0.0;
        double secondSum = 0.0;
        int n = sample.length;
        for (int i = 0; i < n; ++i) {
            firstSum += Math.log(sample[i]);
            secondSum += Math.log(1.0 + Math.pow(sample[i] / this.getScale(), this.getShape()));
        }
        return (double)n * Math.log(this.getShape()) - (double)n * this.getShape() * Math.log(this.getScale()) + (this.getShape() - 1.0) * firstSum - 2.0 * secondSum;
    }

    @Override
    public double[] getLogLikelihoodJacobian(double[] sample) {
        int n = sample.length;
        double[] retval = new double[2];
        double firstSum = 0.0;
        double secondSum = 0.0;
        double sumLogx = 0.0;
        for (int i = 0; i < sample.length; ++i) {
            double a = sample[i] / this.getScale();
            double b = Math.pow(a, this.getShape());
            b /= 1.0 + b;
            firstSum += b;
            sumLogx += Math.log(sample[i]);
            secondSum += b * Math.log(a);
        }
        retval[0] = (double)(-n) * this.getShape() / this.getScale() + 2.0 * (this.getShape() / this.getScale()) * firstSum;
        retval[1] = (double)n / this.getShape() - (double)n * Math.log(this.getScale()) + sumLogx - 2.0 * secondSum;
        return retval;
    }

    @Override
    public double[] getLogLikelihoodHessian(double[] sample) {
        int n = sample.length;
        double dsds = 0.0;
        double dsdk = 0.0;
        double dkdk = 0.0;
        for (int i = 0; i < sample.length; ++i) {
            double a = sample[i] / this.getScale();
            double loga = Math.log(a);
            double b = Math.pow(a, this.getShape());
            double denom = (b + 1.0) * (b + 1.0);
            dsds += (b + this.getShape() + 1.0) * b / denom;
            dsdk += b * (loga * this.getShape() + b + 1.0) / denom;
            dkdk += loga * loga * b / denom;
        }
        dsds *= 2.0 * this.getShape() / (this.getScale() * this.getScale());
        dsdk *= -2.0 / this.getScale();
        dkdk *= 2.0;
        return new double[]{dsds += (double)(-n) * this.getShape() / (this.getScale() * this.getScale()), dsdk += (double)n / this.getScale(), dsdk, dkdk += (double)n / (this.getShape() * this.getShape())};
    }
}

