/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.ClipData;
import hec.statistics.ClipDist;
import hec.statistics.LogNormalDist;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class LogNormalClipDist
extends LogNormalDist
implements ClipDist {
    private ClipData _clip = new ClipData(){

        @Override
        public void setMinVal(double minVal) {
            super.setMinVal(minVal);
            super.setMinProb(LogNormalClipDist.super.getCDF(minVal));
        }

        @Override
        public void setMinProb(double minProb) {
            super.setMinProb(minProb);
            LogNormalDist lnd = new LogNormalDist(LogNormalClipDist.this.getMeanOfLn(), LogNormalClipDist.this.getStdvOfLn());
            super.setMinVal(lnd.invCDF(minProb));
        }

        @Override
        public void setMaxVal(double maxVal) {
            super.setMaxVal(maxVal);
            super.setMaxProb(LogNormalClipDist.super.getCDF(maxVal));
        }

        @Override
        public void setMaxProb(double maxProb) {
            super.setMaxProb(maxProb);
            LogNormalDist lnd = new LogNormalDist(LogNormalClipDist.this.getMeanOfLn(), LogNormalClipDist.this.getStdvOfLn());
            super.setMaxVal(lnd.invCDF(maxProb));
        }
    };
    static final int COMPUTE_FLAG = 0;

    public LogNormalClipDist() {
    }

    public LogNormalClipDist(double meanOfLn, double stdvOfLn) {
        super(meanOfLn, stdvOfLn);
    }

    @Override
    public ClipData getClipData() {
        return this._clip;
    }

    @Override
    public String[] getClipParamNames() {
        if (this.getClipData() == null) {
            return new String[0];
        }
        return this.getClipData().getClipParamNames();
    }

    @Override
    public double[] getClipParamVals() {
        if (this.getClipData() == null) {
            return new double[0];
        }
        return this.getClipData().getClipParamVals();
    }

    @Override
    public String getSummaryClip(String format) {
        if (this.getClipData() == null) {
            return "";
        }
        return this.getClipData().getSummary(format);
    }

    @Override
    public Object clone() {
        LogNormalClipDist clonedDist = (LogNormalClipDist)super.clone();
        clonedDist._clip = (ClipData)this._clip.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("LogNormalClipDistEnd")) {
                    return;
                }
                if (type.equals("MeanOfLn")) {
                    this.setMeanOfLn(Double.parseDouble(param));
                } else if (type.equals("StdvOfLn")) {
                    this.setStdvOfLn(Double.parseDouble(param));
                } else if (type.equals("Parametrization")) {
                    this.setParametrizationName(param);
                } else if (type.equals("ClipDataBegin")) {
                    this._clip.read(reader);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read LogNormalClipDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "LogNormalClipDistBegin");
        TextFile.writeLine(writer, "MeanOfLn:" + this.getMeanOfLn());
        TextFile.writeLine(writer, "StdvOfLn:" + this.getStdvOfLn());
        TextFile.writeLine(writer, "Parametrization:" + this.getParametrizationName());
        this._clip.write(writer);
        TextFile.writeLine(writer, "LogNormalClipDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal() || this.getClipData().hasMaxClip() && value > this.getClipData().getMaxVal()) {
            return 0.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return super.getPDF(value) / rescale;
    }

    @Override
    public double getCDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal()) {
            return 0.0;
        }
        if (this.getClipData().hasMaxClip() && value >= this.getClipData().getMaxVal()) {
            return 1.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return (super.getCDF(value) - minProb) / rescale;
    }

    @Override
    public double invCDF(double p) {
        LogNormalDist lnd = new LogNormalDist(this.getMeanOfLn(), this.getStdvOfLn());
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return lnd.invCDF(minProb + p * rescale);
    }
}

