/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.MaximumLikelihood;
import hec.statistics.MultiParametrizadDist;
import hec.statistics.NormalDist;
import hec.statistics.ProductMoments;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class LogNormalDist
extends AbstractContDist
implements MultiParametrizadDist {
    private double _meanOfLn;
    private double _stdvOfLn;
    private String _paramType;

    public LogNormalDist() {
        this(0.0, 1.0);
    }

    public LogNormalDist(double meanOfLn, double stdvOfLn) {
        this.setParametrizationName("Logarithmic");
        this.setMeanOfLn(meanOfLn);
        this.setStdvOfLn(stdvOfLn);
    }

    public LogNormalDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public LogNormalDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public void setParametrizationName(String p) {
        if ("Logarithmic".equals(p) || "Linear".equals(p)) {
            this._paramType = p;
        }
    }

    @Override
    public String getParametrizationName() {
        return this._paramType;
    }

    @Override
    public void setParametrizationNumber(int num) {
        if (num == 1) {
            this._paramType = "Logarithmic";
        } else if (num == 2) {
            this._paramType = "Linear";
        }
    }

    @Override
    public int getParametrizationNumber() {
        if ("Logarithmic".equals(this.getParametrizationName())) {
            return 1;
        }
        if ("Linear".equals(this.getParametrizationName())) {
            return 2;
        }
        return 0;
    }

    @Override
    public double[] getActiveParams() {
        if ("Logarithmic".equals(this.getParametrizationName())) {
            return this.getParams1();
        }
        if ("Linear".equals(this.getParametrizationName())) {
            return this.getParams2();
        }
        return null;
    }

    @Override
    public String[] getActiveParamNames() {
        if ("Logarithmic".equals(this.getParametrizationName())) {
            return this.getParamNames1();
        }
        if ("Linear".equals(this.getParametrizationName())) {
            return this.getParamNames2();
        }
        return null;
    }

    @Override
    public void setParams1(double[] logParams) {
        if (logParams == null || logParams.length < 2) {
            return;
        }
        double meanOfLn = logParams[0];
        double stdvOfLn = logParams[1];
        this.setMeanOfLn(meanOfLn);
        this.setStdvOfLn(stdvOfLn);
    }

    @Override
    public double[] getParams1() {
        return new double[]{this.getMeanOfLn(), this.getStdvOfLn()};
    }

    @Override
    public String[] getParamNames1() {
        return new String[]{"MeanLn", "StDvLn"};
    }

    @Override
    public void setParams2(double[] linParams) {
        if (linParams == null || linParams.length < 2) {
            return;
        }
        double mean = linParams[0];
        double stdv = linParams[1];
        double meanOfLn = 2.0 * Math.log(mean) - 0.5 * Math.log(mean * mean + stdv * stdv);
        double stdvOfLn = Math.sqrt(Math.log(mean * mean + stdv * stdv) - 2.0 * Math.log(mean));
        this.setMeanOfLn(meanOfLn);
        this.setStdvOfLn(stdvOfLn);
    }

    @Override
    public double[] getParams2() {
        double meanOfLn = this.getMeanOfLn();
        double stdvOfLn = this.getStdvOfLn();
        double mean = Math.exp(meanOfLn + stdvOfLn * stdvOfLn * 0.5);
        double stdv = mean * Math.sqrt(Math.exp(stdvOfLn * stdvOfLn) - 1.0);
        return new double[]{mean, stdv};
    }

    @Override
    public String[] getParamNames2() {
        return new String[]{"Mean", "StDv"};
    }

    @Override
    public boolean fitSampleData(double[] sample, AbstractContDist.FittingMethod method) {
        this.setParametrizationName("Logarithmic");
        int size = sample == null ? 0 : sample.length;
        double[] logSample = new double[size];
        for (int i = 0; i < size; ++i) {
            logSample[i] = Math.log(sample[i]);
        }
        NormalDist d = new NormalDist();
        boolean fitOK = d.fitSampleData(logSample, method);
        this.setMeanOfLn(d.getMean());
        this.setStdvOfLn(d.getStdv());
        return fitOK;
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        this.setParametrizationName("Logarithmic");
        this.setMeanOfLn(Double.NaN);
        this.setStdvOfLn(Double.NaN);
        return false;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        this.setParametrizationName("Logarithmic");
        this.setMeanOfLn(Double.NaN);
        this.setStdvOfLn(Double.NaN);
        return false;
    }

    public void setMeanOfLn(double meanOfLn) {
        this._meanOfLn = meanOfLn;
    }

    public double getMeanOfLn() {
        return this._meanOfLn;
    }

    public void setStdvOfLn(double stdvOfLn) {
        if (stdvOfLn <= 0.0) {
            stdvOfLn = 0.0;
        }
        this._stdvOfLn = stdvOfLn;
    }

    public double getStdvOfLn() {
        return this._stdvOfLn;
    }

    @Override
    public String getType() {
        return "LogNormal";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"MeanLn", "StDvLn"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getMeanOfLn(), this.getStdvOfLn()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setMeanOfLn(vals[0]);
        this.setStdvOfLn(vals[1]);
    }

    @Override
    public Object clone() {
        LogNormalDist clonedDist = (LogNormalDist)super.clone();
        clonedDist.setParametrizationName(this.getParametrizationName());
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("LogNormalDistEnd")) {
                    return;
                }
                if (type.equals("MeanOfLn")) {
                    this.setMeanOfLn(Double.parseDouble(param));
                } else if (type.equals("StdvOfLn")) {
                    this.setStdvOfLn(Double.parseDouble(param));
                } else if (type.equals("Parametrization")) {
                    this.setParametrizationName(param);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read LogNormalDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "LogNormalDistBegin");
        TextFile.writeLine(writer, "MeanOfLn:" + this.getMeanOfLn());
        TextFile.writeLine(writer, "StdvOfLn:" + this.getStdvOfLn());
        TextFile.writeLine(writer, "Parametrization:" + this.getParametrizationName());
        TextFile.writeLine(writer, "LogNormalDistEnd");
    }

    @Override
    public double getPDF(double value) {
        NormalDist n = new NormalDist(this._meanOfLn, this._stdvOfLn);
        return n.getPDF(Math.log(value)) / value;
    }

    @Override
    public double getCDF(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        NormalDist n = new NormalDist(this._meanOfLn, this._stdvOfLn);
        return n.getCDF(Math.log(value));
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        NormalDist n = new NormalDist(this._meanOfLn, this._stdvOfLn);
        return Math.exp(n.invCDF(p));
    }

    @Override
    public double getExpectedValue() {
        return this._meanOfLn;
    }

    @Override
    public boolean fitSampleData(MaximumLikelihood ml) {
        return this.fitSampleData(ml.getSample(), AbstractContDist.FittingMethod.ProductMoments);
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        NormalDist n = new NormalDist(this._meanOfLn, this._stdvOfLn);
        double[] logSample = new double[sample.length];
        double sumL = 0.0;
        for (int i = 0; i < sample.length; ++i) {
            logSample[i] = Math.log(sample[i]);
            sumL += logSample[i];
        }
        return n.getLogLikelihood(logSample) - sumL;
    }
}

