/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.MaximumLikelihood;
import hec.statistics.Pearson3Dist;
import hec.statistics.ProductMoments;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class LogPearson3Dist
extends AbstractContDist {
    private double _meanOfLog;
    private double _stdvOfLog;
    private double _skew;

    public LogPearson3Dist() {
        this(0.0, 1.0, 0.0);
    }

    public LogPearson3Dist(double meanOfLog, double stdvOfLog, double skew) {
        this.setMeanOfLog(meanOfLog);
        this.setStdvOfLog(stdvOfLog);
        this.setSkew(skew);
    }

    public LogPearson3Dist(double[] sample) {
        this.fitSampleData(sample);
    }

    public LogPearson3Dist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(double[] sample, AbstractContDist.FittingMethod method) {
        int size = sample == null ? 0 : sample.length;
        double[] logSample = new double[size];
        for (int i = 0; i < size; ++i) {
            logSample[i] = Math.log10(sample[i]);
            if (NumericalConstants.isValidValue((double)logSample[i])) continue;
            this.setMeanOfLog(Double.NaN);
            this.setStdvOfLog(Double.NaN);
            this.setSkew(Double.NaN);
            return false;
        }
        Pearson3Dist d = new Pearson3Dist();
        boolean fitOK = d.fitSampleData(logSample, method);
        this.setMeanOfLog(d.getMean());
        this.setStdvOfLog(d.getStdv());
        this.setSkew(d.getSkew());
        return fitOK;
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        this.setMeanOfLog(Double.NaN);
        this.setStdvOfLog(Double.NaN);
        return false;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        this.setMeanOfLog(Double.NaN);
        this.setStdvOfLog(Double.NaN);
        return false;
    }

    @Override
    public boolean fitSampleData(MaximumLikelihood ml) {
        int size = ml.getSample() == null ? 0 : ml.getSample().length;
        double[] logSample = new double[size];
        for (int i = 0; i < size; ++i) {
            logSample[i] = Math.log10(ml.getSample()[i]);
            if (NumericalConstants.isValidValue((double)logSample[i])) continue;
            return false;
        }
        Pearson3Dist d = new Pearson3Dist();
        MaximumLikelihood logMl = new MaximumLikelihood(logSample, MaximumLikelihood.MinimizationMethod.NEWTON);
        boolean fitOK = d.fitSampleData(logMl);
        this.setMeanOfLog(d.getMean());
        this.setStdvOfLog(d.getStdv());
        this.setSkew(d.getSkew());
        return fitOK;
    }

    public void setMeanOfLog(double meanOfLog) {
        this._meanOfLog = meanOfLog;
    }

    public double getMeanOfLog() {
        return this._meanOfLog;
    }

    public void setStdvOfLog(double stdvOfLog) {
        if (stdvOfLog <= 0.0) {
            stdvOfLog = 0.0;
        }
        this._stdvOfLog = stdvOfLog;
    }

    public double getStdvOfLog() {
        return this._stdvOfLog;
    }

    public void setSkew(double skew) {
        this._skew = skew;
    }

    public double getSkew() {
        return this._skew;
    }

    @Override
    public String getType() {
        return "LogPearson3";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"MeanLog", "StDvLog", "Skew"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getMeanOfLog(), this.getStdvOfLog(), this.getSkew()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setMeanOfLog(vals[0]);
        this.setStdvOfLog(vals[1]);
        this.setSkew(vals[2]);
    }

    @Override
    public Object clone() {
        LogPearson3Dist clonedDist = (LogPearson3Dist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("LogPearson3DistEnd")) {
                    return;
                }
                if (type.equals("MeanOfLog") || type.equals("MeanOfLn")) {
                    this.setMeanOfLog(Double.parseDouble(param));
                } else if (type.equals("StdvOfLog") || type.equals("StdvOfLn")) {
                    this.setStdvOfLog(Double.parseDouble(param));
                } else if (type.equals("Skew")) {
                    this.setSkew(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read LogPearson3Dist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "LogPearson3DistBegin");
        TextFile.writeLine(writer, "MeanOfLog:" + this.getMeanOfLog());
        TextFile.writeLine(writer, "StdvOfLog:" + this.getStdvOfLog());
        TextFile.writeLine(writer, "Skew:" + this.getSkew());
        TextFile.writeLine(writer, "LogPearson3DistEnd");
    }

    @Override
    public double getPDF(double value) {
        Pearson3Dist d = new Pearson3Dist(this._meanOfLog, this._stdvOfLog, this._skew);
        return d.getPDF(Math.log10(value)) / value / Math.log(10.0);
    }

    @Override
    public double getCDF(double value) {
        if (value <= 0.0) {
            return 0.0;
        }
        Pearson3Dist d = new Pearson3Dist(this._meanOfLog, this._stdvOfLog, this._skew);
        return d.getCDF(Math.log10(value));
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        Pearson3Dist d = new Pearson3Dist(this._meanOfLog, this._stdvOfLog, this._skew);
        return Math.pow(10.0, d.invCDF(p));
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        Pearson3Dist d = new Pearson3Dist(this._meanOfLog, this._stdvOfLog, this._skew);
        double sumX = 0.0;
        double[] logSample = new double[sample.length];
        for (int i = 0; i < sample.length; ++i) {
            logSample[i] = Math.log10(sample[i]);
            sumX += Math.log(sample[i]);
        }
        return d.getLogLikelihood(logSample) - sumX - (double)sample.length * Math.log(Math.log(10.0));
    }
}

