/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.ProductMoments;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class LogisticDist
extends AbstractContDist {
    private static final double MIN_SCALE = 1.0E-5;
    private double _loctn;
    private double _scale;

    public LogisticDist() {
        this(0.0, 1.0);
    }

    public LogisticDist(double loc, double scale) {
        this.setLoctn(loc);
        this.setScale(scale);
    }

    public LogisticDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public LogisticDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        double scale = Math.sqrt(3.0) * pm.getStDv() / Math.PI;
        if (scale < 1.0E-5) {
            this.setLoctn(Double.NaN);
            this.setScale(Double.NaN);
            return false;
        }
        this.setLoctn(pm.getMean());
        this.setScale(scale);
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        if (lm.getL2() < 1.0E-5) {
            this.setLoctn(Double.NaN);
            this.setScale(Double.NaN);
            return true;
        }
        this.setLoctn(lm.getL1());
        this.setScale(lm.getL2());
        return true;
    }

    public void setLoctn(double loc) {
        this._loctn = loc;
    }

    public double getLoctn() {
        return this._loctn;
    }

    public void setScale(double scale) {
        if (scale <= 1.0E-5) {
            scale = 1.0E-5;
        }
        this._scale = scale;
    }

    public double getScale() {
        return this._scale;
    }

    @Override
    public String getType() {
        return "Logistic";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Loctn", "Scale"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getLoctn(), this.getScale()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setLoctn(vals[0]);
        this.setScale(vals[1]);
    }

    @Override
    public Object clone() {
        LogisticDist clonedDist = (LogisticDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("LogisticDistEnd")) {
                    return;
                }
                if (type.equals("Loctn")) {
                    this.setLoctn(Double.parseDouble(param));
                } else if (type.equals("Scale")) {
                    this.setScale(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read LogisticDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "LogisticDistBegin");
        TextFile.writeLine(writer, "Loctn:" + this.getLoctn());
        TextFile.writeLine(writer, "Scale:" + this.getScale());
        TextFile.writeLine(writer, "LogisticDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (this.getScale() <= 0.0) {
            if (value == this.getLoctn()) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        double x = Math.exp(-(value - this.getLoctn()) / this.getScale());
        return x / (this.getScale() * (1.0 + x) * (1.0 + x));
    }

    @Override
    public double getCDF(double value) {
        if (this.getScale() <= 0.0) {
            if (value < this.getLoctn()) {
                return 0.0;
            }
            if (value == this.getLoctn()) {
                return 0.5;
            }
            return 1.0;
        }
        return 1.0 / (1.0 + Math.exp(-(value - this.getLoctn()) / this.getScale()));
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.getLoctn() - this.getScale() * Math.log(1.0 / p - 1.0);
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        return LogisticDist.getLogisticDistributionLikelihood(sample, this.getLoctn(), this.getScale());
    }

    public static double getLogisticDistributionLikelihood(double[] sample, double loctn, double scale) {
        int n = sample.length;
        double sum = 0.0;
        double exp2 = 2.0 * scale;
        for (int i = 0; i < sample.length; ++i) {
            double exp = Math.exp(-(sample[i] - loctn) / exp2);
            sum += Math.log(exp + 1.0 / exp);
        }
        return (double)n * (-Math.log(4.0 * scale) + 2.0 * Math.log(2.0)) - 2.0 * sum;
    }

    @Override
    public double[] getLogLikelihoodJacobian(double[] sample) {
        double[] retval = new double[2];
        double sum1 = 0.0;
        double sum2 = 0.0;
        double ems = Math.exp(this.getLoctn() / this.getScale());
        for (int i = 0; i < sample.length; ++i) {
            double exs = Math.exp(sample[i] / this.getScale());
            double exp = (ems - exs) / (ems + exs);
            sum1 += exp;
            sum2 += (this.getLoctn() - sample[i]) * exp;
        }
        retval[0] = -1.0 / this.getScale() * sum1;
        retval[1] = (double)(-sample.length) / this.getScale() + 1.0 / (this.getScale() * this.getScale()) * sum2;
        return retval;
    }

    @Override
    public double[] getLogLikelihoodHessian(double[] sample) {
        double dmdm = 0.0;
        double dmds = 0.0;
        double dsds = 0.0;
        double ems = Math.exp(this.getLoctn() / this.getScale());
        int n = sample.length;
        for (int i = 0; i < n; ++i) {
            double exs = Math.exp(sample[i] / this.getScale());
            double sum = ems + exs;
            double sum2 = sum * sum;
            double exp1 = Math.exp((sample[i] + this.getLoctn()) / this.getScale());
            dmdm += exp1 / sum2;
            dmds += (-2.0 * (this.getLoctn() - sample[i]) * exp1 - this.getScale() * (ems * ems - exs * exs)) / sum2;
            dsds += (this.getLoctn() - sample[i]) * (-(this.getLoctn() - sample[i]) * exp1 - this.getScale() * (ems * ems - exs * exs)) / sum2;
        }
        dsds *= -2.0 / (this.getScale() * this.getScale() * this.getScale() * this.getScale());
        return new double[]{dmdm *= 2.0 / (this.getScale() * this.getScale()), dmds *= 1.0 / (this.getScale() * this.getScale() * this.getScale()), dmds, dsds += (double)(-n) / (this.getScale() * this.getScale())};
    }
}

