/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.ProductMoments;
import hec.statistics.StandardNormalDistribution;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class NormalB17BDist
extends AbstractContDist {
    private static final double MIN_STDV = 1.0E-5;
    public static final String NAME = "Normal";
    private double _mean;
    private double _stdv;

    public NormalB17BDist() {
        this(0.0, 1.0);
    }

    public NormalB17BDist(double mean, double stdv) {
        this.setMean(mean);
        this.setStdv(stdv);
    }

    public NormalB17BDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public NormalB17BDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        if (pm.getStDv() < 1.0E-5) {
            this.setMean(Double.NaN);
            this.setStdv(Double.NaN);
            return false;
        }
        this.setMean(pm.getMean());
        this.setStdv(pm.getStDv());
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        double sqrtPi = 1.772453850905516;
        double stdv = lm.getL2() * 1.772453850905516;
        if (stdv < 1.0E-5) {
            this.setMean(Double.NaN);
            this.setStdv(Double.NaN);
            return false;
        }
        this.setMean(lm.getL1());
        this.setStdv(stdv);
        return true;
    }

    public void setMean(double mean) {
        this._mean = mean;
    }

    public double getMean() {
        return this._mean;
    }

    public void setStdv(double stdv) {
        if (stdv <= 1.0E-5) {
            stdv = 1.0E-5;
        }
        this._stdv = stdv;
    }

    public double getStdv() {
        return this._stdv;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Mean", "StDv"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getMean(), this.getStdv()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setMean(vals[0]);
        this.setStdv(vals[1]);
    }

    @Override
    public Object clone() {
        NormalB17BDist clonedDist = (NormalB17BDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("NormalDistEnd")) {
                    return;
                }
                if (type.equals("Mean")) {
                    this.setMean(Double.parseDouble(param));
                } else if (type.equals("Stdv")) {
                    this.setStdv(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read NormalDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "NormalDistBegin");
        TextFile.writeLine(writer, "Mean:" + this.getMean());
        TextFile.writeLine(writer, "Stdv:" + this.getStdv());
        TextFile.writeLine(writer, "NormalDistEnd");
    }

    @Override
    public double getPDF(double value) {
        double DX = 1.0E-5;
        double valueL = value - this.getStdv() * 0.5 * 1.0E-5;
        double valueR = value + this.getStdv() * 0.5 * 1.0E-5;
        return (this.getCDF(valueR) - this.getCDF(valueL)) / (this.getStdv() * 1.0E-5);
    }

    @Override
    public double getCDF(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double normalDeviate = (value - this.getMean()) / this.getStdv();
        return 1.0 - StandardNormalDistribution.getDistribution(normalDeviate);
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double normalDeviate = StandardNormalDistribution.getDeviate(1.0 - p);
        return this.getMean() + this.getStdv() * normalDeviate;
    }

    public double getConfidenceLimitInvCDF(double p, double confidenceLevel, int sampleSize) {
        double normalDeviate = StandardNormalDistribution.getDeviate(1.0 - p);
        double confDeviate = StandardNormalDistribution.getDeviate(1.0 - confidenceLevel);
        double a = 1.0 - confDeviate * confDeviate / (2.0 * (double)sampleSize - 2.0);
        double b = normalDeviate * normalDeviate - confDeviate * confDeviate / (double)sampleSize;
        double k = Math.sqrt(normalDeviate * normalDeviate - a * b);
        double confCoeff = (normalDeviate + Math.signum(confDeviate) * k) / a;
        return this.getMean() + this.getStdv() * confCoeff;
    }

    public double getConfidenceLimitCDF(double value, double confidenceLevel, int sampleSize) {
        double confCoeff = (value - this.getMean()) / this.getStdv();
        double confDeviate = StandardNormalDistribution.getDeviate(1.0 - confidenceLevel);
        double a = 1.0 - confDeviate * confDeviate / (2.0 * (double)sampleSize - 2.0);
        double normalDeviate = confCoeff - Math.signum(confDeviate) * Math.sqrt((1.0 - a) * (confCoeff * confCoeff) + confDeviate * confDeviate / (double)sampleSize);
        return 1.0 - StandardNormalDistribution.getDistribution(normalDeviate);
    }
}

