/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.LogNormalDist;
import hec.statistics.MaximumLikelihood;
import hec.statistics.ProductMoments;
import hec.statistics.SpecialFunctions;
import hec.statistics.TriangDist;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Random;

public class NormalDist
extends AbstractContDist {
    private static final double MIN_STDV = 1.0E-5;
    public static final String NAME = "Normal";
    private double _mean;
    private double _stdv;

    public NormalDist() {
        this(0.0, 1.0);
    }

    public NormalDist(double mean, double stdv) {
        this.setMean(mean);
        this.setStdv(stdv);
    }

    public NormalDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public NormalDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        if (pm.getStDv() < 1.0E-5) {
            this.setMean(Double.NaN);
            this.setStdv(Double.NaN);
            return false;
        }
        this.setMean(pm.getMean());
        this.setStdv(pm.getStDv());
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        double sqrtPi = 1.772453850905516;
        double stdv = lm.getL2() * 1.772453850905516;
        if (stdv < 1.0E-5) {
            this.setMean(Double.NaN);
            this.setStdv(Double.NaN);
            return false;
        }
        this.setMean(lm.getL1());
        this.setStdv(stdv);
        return true;
    }

    public void setMean(double mean) {
        this._mean = mean;
    }

    public double getMean() {
        return this._mean;
    }

    public void setStdv(double stdv) {
        if (stdv <= 1.0E-5) {
            stdv = 1.0E-5;
        }
        this._stdv = stdv;
    }

    public double getStdv() {
        return this._stdv;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Mean", "StDv"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getMean(), this.getStdv()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setMean(vals[0]);
        this.setStdv(vals[1]);
    }

    @Override
    public Object clone() {
        NormalDist clonedDist = (NormalDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("NormalDistEnd")) {
                    return;
                }
                if (type.equals("Mean")) {
                    this.setMean(Double.parseDouble(param));
                } else if (type.equals("Stdv")) {
                    this.setStdv(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read NormalDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "NormalDistBegin");
        TextFile.writeLine(writer, "Mean:" + this.getMean());
        TextFile.writeLine(writer, "Stdv:" + this.getStdv());
        TextFile.writeLine(writer, "NormalDistEnd");
    }

    @Override
    public double getPDF(double value) {
        double sqrt2pi = 2.5066282746310007;
        return Math.exp(-(value - this._mean) * (value - this._mean) / (2.0 * this._stdv * this._stdv)) / (2.5066282746310007 * this._stdv);
    }

    @Override
    public double getCDF(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (value >= this._mean) {
            return 0.5 * (1.0 + SpecialFunctions.regIncompleteGamma(0.5, (value - this._mean) * (value - this._mean) / (2.0 * this._stdv * this._stdv)));
        }
        return 0.5 * (1.0 - SpecialFunctions.regIncompleteGamma(0.5, (value - this._mean) * (value - this._mean) / (2.0 * this._stdv * this._stdv)));
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.invCDFNewton(p, this.getMean(), 1.0E-10, 100);
    }

    public static void main(String[] args) {
        try {
            long seed = 12345L;
            Random rdm = new Random(seed);
            NormalDist n = new NormalDist(300.0, 50.0);
            TriangDist t = new TriangDist(100.0, 300.0, 400.0);
            LogNormalDist l = new LogNormalDist(6.0, 2.0);
            PrintWriter writer = new PrintWriter("BenData2014.txt", "UTF-8");
            for (int i = 0; i < 1000; ++i) {
                double p = rdm.nextDouble();
                writer.println(p + " " + n.invCDF(p) + " " + t.invCDF(p) + " " + l.invCDF(p));
            }
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean fitSampleData(MaximumLikelihood ml) {
        return this.fitSampleData(new ProductMoments(ml.getSample()));
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        int n = sample.length;
        double var = this.getStdv() * this.getStdv();
        double summation = 0.0;
        for (int i = 0; i < n; ++i) {
            double diff = sample[i] - this.getMean();
            summation += 1.0 / (2.0 * var) * diff * diff;
        }
        double retval = (double)(-n) / 2.0 * Math.log(Math.PI * 2) - (double)n / 2.0 * Math.log(var) - summation;
        return retval;
    }
}

