/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.EquationSolverNewton;
import hec.statistics.LinearMoments;
import hec.statistics.PearsonType3Distribution;
import hec.statistics.ProductMoments;
import hec.statistics.SpecialFunctions;
import hec.statistics.StandardNormalDistribution;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class Pearson3B17BDist
extends AbstractContDist {
    protected static final double MIN_STDV = 1.0E-5;
    protected static final double BND_SKEW = 1.0E-5;
    protected double _mean;
    protected double _stdv;
    protected double _skew;

    public Pearson3B17BDist() {
        this(0.0, 1.0, 0.0);
    }

    public Pearson3B17BDist(double mean, double stdv, double skew) {
        this.setMean(mean);
        this.setStdv(stdv);
        this.setSkew(skew);
    }

    public Pearson3B17BDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public Pearson3B17BDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        if (pm.getStDv() <= 1.0E-5) {
            this.setMean(Double.NaN);
            this.setStdv(Double.NaN);
            this.setSkew(Double.NaN);
            return false;
        }
        this.setMean(pm.getMean());
        this.setStdv(pm.getStDv());
        this.setSkew(pm.getSkew());
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        double sqrtPi = 1.772453850905516;
        double stdv = 1.772453850905516 * lm.getL2();
        if (stdv <= 1.0E-5) {
            this.setMean(Double.NaN);
            this.setStdv(Double.NaN);
            this.setSkew(Double.NaN);
            return false;
        }
        if (Math.abs(lm.getT3()) <= 1.0E-5) {
            this.setMean(lm.getL1());
            this.setStdv(stdv);
            this.setSkew(0.0);
            return true;
        }
        EquationSolverNewton solverk = new EquationSolverNewton(){

            @Override
            public double f(double x) {
                if (x == 0.0) {
                    return 1.0;
                }
                return 6.0 * SpecialFunctions.regIncompleteBeta(x, 2.0 * x, 0.3333333333333333) - 3.0;
            }
        };
        double kGuess = Math.exp(Math.log(1.0 / Math.abs(lm.getT3()) - 1.0) / 0.6 + Math.log(0.4));
        double dx = Math.max(1.0E-10, Math.min(100.0, Math.pow(10.0, -11.0 + Math.log10(kGuess) * 2.71)));
        double k = solverk.newton(Math.abs(lm.getT3()), kGuess, 1.0E-10, 100, dx);
        double skewSquared = 4.0 / k;
        this.setMean(lm.getL1());
        this.setStdv(lm.getL2() * 1.772453850905516 * Math.sqrt(k) * Math.exp(SpecialFunctions.logGamma(k) - SpecialFunctions.logGamma(k + 0.5)));
        this.setSkew(Math.signum(lm.getT3()) * 2.0 / Math.sqrt(k));
        return !Double.isNaN(skewSquared);
    }

    public void setMean(double mean) {
        this._mean = mean;
    }

    public double getMean() {
        return this._mean;
    }

    public void setStdv(double stdv) {
        if (stdv <= 1.0E-5) {
            stdv = 1.0E-5;
        }
        this._stdv = stdv;
    }

    public double getStdv() {
        return this._stdv;
    }

    public void setSkew(double skew) {
        this._skew = skew;
    }

    public double getSkew() {
        return this._skew;
    }

    @Override
    public String getType() {
        return "Pearson3";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Mean", "StDv", "Skew"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getMean(), this.getStdv(), this.getSkew()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setMean(vals[0]);
        this.setStdv(vals[1]);
        this.setSkew(vals[2]);
    }

    @Override
    public Object clone() {
        Pearson3B17BDist clonedDist = (Pearson3B17BDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("Pearson3DistEnd")) {
                    return;
                }
                if (type.equals("Mean")) {
                    this.setMean(Double.parseDouble(param));
                } else if (type.equals("Stdv")) {
                    this.setStdv(Double.parseDouble(param));
                } else if (type.equals("Skew")) {
                    this.setStdv(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read NormalDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "Pearson3DistBegin");
        TextFile.writeLine(writer, "Mean:" + this.getMean());
        TextFile.writeLine(writer, "Stdv:" + this.getStdv());
        TextFile.writeLine(writer, "Skew:" + this.getSkew());
        TextFile.writeLine(writer, "Pearson3DistEnd");
    }

    @Override
    public double getPDF(double value) {
        double DX = 1.0E-5;
        double valueL = value - this.getStdv() * 0.5 * 1.0E-5;
        double valueR = value + this.getStdv() * 0.5 * 1.0E-5;
        return (this.getCDF(valueR) - this.getCDF(valueL)) / (this.getStdv() * 1.0E-5);
    }

    @Override
    public double getCDF(double value) {
        double normalDeviate = PearsonType3Distribution.getNormalDeviate((value - this.getMean()) / this.getStdv(), this.getSkew());
        return 1.0 - StandardNormalDistribution.getDistribution(normalDeviate);
    }

    @Override
    public double invCDF(double p) {
        double normalDeviate = StandardNormalDistribution.getDeviate(1.0 - p);
        return this.getMean() + this.getStdv() * PearsonType3Distribution.getDeviate(normalDeviate, this.getSkew());
    }

    public double getConfidenceLimitInvCDF(double p, double confidenceLevel, int sampleSize) {
        double normalDeviate = StandardNormalDistribution.getDeviate(1.0 - p);
        double p3Deviate = PearsonType3Distribution.getDeviate(normalDeviate, this.getSkew());
        double confDeviate = StandardNormalDistribution.getDeviate(1.0 - confidenceLevel);
        double a = 1.0 - confDeviate * confDeviate / (2.0 * (double)sampleSize - 2.0);
        double b = p3Deviate * p3Deviate - confDeviate * confDeviate / (double)sampleSize;
        double k = Math.sqrt(p3Deviate * p3Deviate - a * b);
        double confCoeff = (p3Deviate + Math.signum(confDeviate) * k) / a;
        return this.getMean() + this.getStdv() * confCoeff;
    }

    public double getConfidenceLimitCDF(double value, double confidenceLevel, int sampleSize) {
        double confCoeff = (value - this.getMean()) / this.getStdv();
        double confDeviate = StandardNormalDistribution.getDeviate(1.0 - confidenceLevel);
        double a = 1.0 - confDeviate * confDeviate / (2.0 * (double)sampleSize - 2.0);
        double p3Deviate = confCoeff - Math.signum(confDeviate) * Math.sqrt((1.0 - a) * (confCoeff * confCoeff) + confDeviate * confDeviate / (double)sampleSize);
        double normalDeviate = PearsonType3Distribution.getNormalDeviate(p3Deviate, this.getSkew());
        return 1.0 - StandardNormalDistribution.getDistribution(normalDeviate);
    }
}

