/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.Pearson3Dist;
import java.util.ArrayList;
import java.util.List;

public class Pearson3B17CDist
extends Pearson3Dist {
    protected static final double BND_SKEW = 1.0E-4;

    public Pearson3B17CDist() {
    }

    public Pearson3B17CDist(double mean, double stdv, double skew) {
        super(mean, stdv, skew);
    }

    public double getVariance() {
        return this._stdv * this._stdv;
    }

    public List<Double> getExpectedMomentList() {
        ArrayList<Double> list = new ArrayList<Double>();
        list.add(this._mean);
        list.add(this._stdv * this._stdv);
        list.add(this._stdv);
        return list;
    }

    public double[] getCentralMoment() {
        double[] cm = new double[]{this._mean, this._stdv, this._skew};
        return cm;
    }

    public double[] getExpectedMoment() {
        double[] cm = new double[]{this._mean, this._stdv * this._stdv, this._skew};
        return cm;
    }

    public double getAlpha() {
        return 4.0 / (this._skew * this._skew);
    }

    public double getBeta() {
        double variance = this._stdv * this._stdv;
        return Math.signum(this._skew) * Math.sqrt(variance / this.getAlpha());
    }

    public double getTau() {
        return this._mean - this.getAlpha() * this.getBeta();
    }

    public double[] getP3() {
        double[] p3 = new double[]{this.getAlpha(), this.getBeta(), this.getTau()};
        return p3;
    }

    public void setParameter(double alpha, double beta, double tau) {
        try {
            double sign = Math.signum(this._skew);
            this._skew = sign * Math.sqrt(4.0 / alpha);
            this._stdv = Math.sqrt(beta * beta * alpha);
            this._mean = tau + alpha * beta;
        }
        catch (ArithmeticException e) {
            System.out.println("An Arithmetic Exception has occured");
            return;
        }
    }

    public void setCentralMoment(double mean, double stdv, double skew) {
        this.setMean(mean);
        this.setStdv(stdv);
        this.setSkew(skew);
    }

    public List<Double> convertCentralMomentToNonCentralList() {
        ArrayList<Double> list = new ArrayList<Double>();
        double mu1 = this._mean;
        list.add(mu1);
        double mu2 = Math.pow(this._stdv, 2.0) + Math.pow(this._mean, 2.0);
        list.add(mu2);
        double mu3 = Math.pow(this._stdv, 3.0) * this._skew + 3.0 * mu2 * this._mean - 2.0 * Math.pow(this._mean, 3.0);
        list.add(mu3);
        return list;
    }

    public static double[] convertCentralMomentToNonCentral(double mean, double stdv, double skew) {
        double mu3;
        double mu1 = mean;
        double mu2 = Math.pow(stdv, 2.0) + Math.pow(mean, 2.0);
        double[] list = new double[]{mu1, mu2, mu3 = Math.pow(stdv, 3.0) * skew + 3.0 * Math.pow(stdv, 2.0) * mean - 2.0 * Math.pow(mean, 3.0)};
        return list;
    }

    public double[] convertCentralMomentToNonCentral() {
        List<Double> list = this.convertCentralMomentToNonCentralList();
        double[] dlist = new double[]{list.get(0), list.get(1), list.get(2)};
        return dlist;
    }

    public void convertNonCentralMomentToCentral(double mu1, double mu2, double mu3) {
        this._mean = mu1;
        this._stdv = Math.sqrt(mu2 - Math.pow(this._mean, 2.0));
        this._skew = (mu3 - 3.0 * mu2 * mu1 + 2.0 * Math.pow(mu1, 3.0)) / Math.pow(this._stdv, 3.0);
    }

    @Override
    public double getMinimumSkew() {
        return 1.0E-4;
    }

    @Override
    public double invCDF(double p) {
        double retval = super.invCDF(p);
        if (Double.isNaN(retval)) {
            retval = this.getZeroEquivalentDist().invCDF(p);
        }
        return retval;
    }
}

