/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.ClipData;
import hec.statistics.ClipDist;
import hec.statistics.Pearson3Dist;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class Pearson3ClipDist
extends Pearson3Dist
implements ClipDist {
    private ClipData _clip = new ClipData(){

        @Override
        public void setMinVal(double minVal) {
            super.setMinVal(minVal);
            super.setMinProb(Pearson3ClipDist.super.getCDF(minVal));
        }

        @Override
        public void setMinProb(double minProb) {
            super.setMinProb(minProb);
            Pearson3Dist p3d = new Pearson3Dist(Pearson3ClipDist.this.getMean(), Pearson3ClipDist.this.getStdv(), Pearson3ClipDist.this.getSkew());
            super.setMinVal(p3d.invCDF(minProb));
        }

        @Override
        public void setMaxVal(double maxVal) {
            super.setMaxVal(maxVal);
            super.setMaxProb(Pearson3ClipDist.super.getCDF(maxVal));
        }

        @Override
        public void setMaxProb(double maxProb) {
            super.setMaxProb(maxProb);
            Pearson3Dist p3d = new Pearson3Dist(Pearson3ClipDist.this.getMean(), Pearson3ClipDist.this.getStdv(), Pearson3ClipDist.this.getSkew());
            super.setMaxVal(p3d.invCDF(maxProb));
        }
    };
    static final int COMPUTE_FLAG = 0;

    public Pearson3ClipDist() {
    }

    public Pearson3ClipDist(double mean, double stdv, double skew) {
        super(mean, stdv, skew);
    }

    @Override
    public ClipData getClipData() {
        return this._clip;
    }

    @Override
    public String[] getClipParamNames() {
        if (this.getClipData() == null) {
            return new String[0];
        }
        return this.getClipData().getClipParamNames();
    }

    @Override
    public double[] getClipParamVals() {
        if (this.getClipData() == null) {
            return new double[0];
        }
        return this.getClipData().getClipParamVals();
    }

    @Override
    public String getSummaryClip(String format) {
        if (this.getClipData() == null) {
            return "";
        }
        return this.getClipData().getSummary(format);
    }

    @Override
    public Object clone() {
        Pearson3ClipDist clonedDist = (Pearson3ClipDist)super.clone();
        clonedDist._clip = (ClipData)this._clip.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("Pearson3ClipDistEnd")) {
                    return;
                }
                if (type.equals("Mean")) {
                    this.setMean(Double.parseDouble(param));
                } else if (type.equals("Stdv")) {
                    this.setStdv(Double.parseDouble(param));
                } else if (type.equals("Skew")) {
                    this.setSkew(Double.parseDouble(param));
                } else if (type.equals("ClipDataBegin")) {
                    this._clip.read(reader);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read Pearson3ClipDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "Pearson3ClipDistBegin");
        TextFile.writeLine(writer, "Mean:" + this.getMean());
        TextFile.writeLine(writer, "Stdv:" + this.getStdv());
        TextFile.writeLine(writer, "Skew:" + this.getSkew());
        this._clip.write(writer);
        TextFile.writeLine(writer, "Pearson3ClipDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal() || this.getClipData().hasMaxClip() && value > this.getClipData().getMaxVal()) {
            return 0.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return super.getPDF(value) / rescale;
    }

    @Override
    public double getCDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal()) {
            return 0.0;
        }
        if (this.getClipData().hasMaxClip() && value >= this.getClipData().getMaxVal()) {
            return 1.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return (super.getCDF(value) - minProb) / rescale;
    }

    @Override
    public double invCDF(double p) {
        Pearson3Dist p3d = new Pearson3Dist(this.getMean(), this.getStdv(), this.getSkew());
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return p3d.invCDF(minProb + p * rescale);
    }
}

