/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.ContDist;
import hec.statistics.EquationSolverNewton;
import hec.statistics.LinearMoments;
import hec.statistics.MaximumLikelihood;
import hec.statistics.NormalDist;
import hec.statistics.ProductMoments;
import hec.statistics.ShiftedGammaDist;
import hec.statistics.SpecialFunctions;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class Pearson3Dist
extends AbstractContDist {
    protected static final double MIN_STDV = 1.0E-5;
    protected static final double BND_SKEW = 1.0E-5;
    protected double _mean;
    protected double _stdv;
    protected double _skew;
    ShiftedGammaDist _shiftedGammaDist = new ShiftedGammaDist();
    NormalDist _normalDist = new NormalDist();

    public Pearson3Dist() {
        this(0.0, 1.0, 0.0);
    }

    public Pearson3Dist(double mean, double stdv, double skew) {
        this.setMean(mean);
        this.setStdv(stdv);
        this.setSkew(skew);
    }

    public Pearson3Dist(double[] sample) {
        this.fitSampleData(sample);
    }

    public Pearson3Dist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        if (pm.getStDv() <= 1.0E-5) {
            this.setMean(Double.NaN);
            this.setStdv(Double.NaN);
            this.setSkew(Double.NaN);
            return false;
        }
        this.setMean(pm.getMean());
        this.setStdv(pm.getStDv());
        this.setSkew(pm.getSkew());
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        double sqrtPi = 1.772453850905516;
        double stdv = 1.772453850905516 * lm.getL2();
        if (stdv <= 1.0E-5 || Math.abs(lm.getT3()) >= 1.0) {
            this.setMean(Double.NaN);
            this.setStdv(Double.NaN);
            this.setSkew(Double.NaN);
            return false;
        }
        if (Math.abs(lm.getT3()) <= this.getMinimumSkew()) {
            this.setMean(lm.getL1());
            this.setStdv(stdv);
            this.setSkew(0.0);
            return true;
        }
        EquationSolverNewton solverk = new EquationSolverNewton(){

            @Override
            public double f(double x) {
                if (x == 0.0) {
                    return 1.0;
                }
                return 6.0 * SpecialFunctions.regIncompleteBeta(x, 2.0 * x, 0.3333333333333333) - 3.0;
            }
        };
        double kGuess = Math.exp(Math.log(1.0 / Math.abs(lm.getT3()) - 1.0) / 0.6 + Math.log(0.4));
        double dx = Math.max(1.0E-10, Math.min(100.0, Math.pow(10.0, -11.0 + Math.log10(kGuess) * 2.71)));
        double k = solverk.newton(Math.abs(lm.getT3()), kGuess, 1.0E-10, 100, dx);
        double skewSquared = 4.0 / k;
        this.setMean(lm.getL1());
        this.setStdv(lm.getL2() * 1.772453850905516 * Math.sqrt(k) * Math.exp(SpecialFunctions.logGamma(k) - SpecialFunctions.logGamma(k + 0.5)));
        this.setSkew(Math.signum(lm.getT3()) * 2.0 / Math.sqrt(k));
        return !Double.isNaN(skewSquared);
    }

    public void setMean(double mean) {
        this._mean = mean;
    }

    public double getMean() {
        return this._mean;
    }

    public void setStdv(double stdv) {
        if (stdv <= 1.0E-5) {
            stdv = 1.0E-5;
        }
        this._stdv = stdv;
    }

    public double getStdv() {
        return this._stdv;
    }

    public void setSkew(double skew) {
        this._skew = skew;
    }

    public double getSkew() {
        return this._skew;
    }

    @Override
    public String getType() {
        return "Pearson3";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Mean", "StDv", "Skew"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getMean(), this.getStdv(), this.getSkew()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setMean(vals[0]);
        this.setStdv(vals[1]);
        this.setSkew(vals[2]);
    }

    @Override
    public Object clone() {
        Pearson3Dist clonedDist = (Pearson3Dist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("Pearson3DistEnd")) {
                    return;
                }
                if (type.equals("Mean")) {
                    this.setMean(Double.parseDouble(param));
                } else if (type.equals("Stdv")) {
                    this.setStdv(Double.parseDouble(param));
                } else if (type.equals("Skew")) {
                    this.setStdv(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read NormalDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "Pearson3DistBegin");
        TextFile.writeLine(writer, "Mean:" + this.getMean());
        TextFile.writeLine(writer, "Stdv:" + this.getStdv());
        TextFile.writeLine(writer, "Skew:" + this.getSkew());
        TextFile.writeLine(writer, "Pearson3DistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (Math.abs(this._skew) < this.getMinimumSkew()) {
            return this.getZeroEquivalentDist().getPDF(value);
        }
        if (this._skew > 0.0) {
            return this.getPosEquivalentDist().getPDF(value);
        }
        return this.getNegEquivalentDist().getPDF(-value);
    }

    @Override
    public double getCDF(double value) {
        if (Math.abs(this._skew) < this.getMinimumSkew()) {
            return this.getZeroEquivalentDist().getCDF(value);
        }
        if (this._skew > 0.0) {
            return this.getPosEquivalentDist().getCDF(value);
        }
        return 1.0 - this.getNegEquivalentDist().getCDF(-value);
    }

    @Override
    public double invCDF(double p) {
        if (Math.abs(this._skew) < this.getMinimumSkew()) {
            return this.getZeroEquivalentDist().invCDF(p);
        }
        if (this._skew > 0.0) {
            return this.getPosEquivalentDist().invCDF(p);
        }
        return -this.getNegEquivalentDist().invCDF(1.0 - p);
    }

    protected ContDist getZeroEquivalentDist() {
        this._normalDist.setMean(this._mean);
        this._normalDist.setStdv(this._stdv);
        return this._normalDist;
    }

    protected ContDist getPosEquivalentDist() {
        this._shiftedGammaDist.setShape(4.0 / (this._skew * this._skew));
        this._shiftedGammaDist.setScale(0.5 * (this._stdv * this._skew));
        this._shiftedGammaDist.setShift(this._mean - 2.0 * this._stdv / this._skew);
        return this._shiftedGammaDist;
    }

    private ContDist getNegEquivalentDist() {
        this._shiftedGammaDist.setShape(4.0 / (this._skew * this._skew));
        this._shiftedGammaDist.setScale(-0.5 * (this._stdv * this._skew));
        this._shiftedGammaDist.setShift(-this._mean + 2.0 * this._stdv / this._skew);
        return this._shiftedGammaDist;
    }

    public double getMinimumSkew() {
        return 1.0E-5;
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        double retval;
        if (Math.abs(this._skew) < this.getMinimumSkew()) {
            retval = this.getZeroEquivalentDist().getLogLikelihood(sample);
        } else if (this._skew > 0.0) {
            retval = this.getPosEquivalentDist().getLogLikelihood(sample);
        } else {
            int i = 0;
            while (i < sample.length) {
                int n = i++;
                sample[n] = sample[n] * -1.0;
            }
            retval = this.getNegEquivalentDist().getLogLikelihood(sample);
            i = 0;
            while (i < sample.length) {
                int n = i++;
                sample[n] = sample[n] * -1.0;
            }
        }
        if (Double.isNaN(retval)) {
            retval = super.getLogLikelihood(sample);
        }
        return retval;
    }

    @Override
    public boolean fitSampleData(MaximumLikelihood ml) {
        ProductMoments pm = new ProductMoments(ml.getSample());
        if (Math.abs(pm.getSkew()) < this.getMinimumSkew()) {
            this.setMean(pm.getMean());
            this.setStdv(pm.getStDv());
            this.setSkew(pm.getSkew());
        } else if (pm.getSkew() > 0.0) {
            this._shiftedGammaDist.fitSampleData(ml);
            this.setSkew(Math.sqrt(4.0 / this._shiftedGammaDist.getShape()));
            this.setStdv(2.0 * this._shiftedGammaDist.getScale() / this.getSkew());
            this.setMean(this._shiftedGammaDist.getShift() + 2.0 * this.getStdv() / this.getSkew());
        } else {
            int i;
            double max = -1.7976931348623157E308;
            for (i = 0; i < ml.getSample().length; ++i) {
                double[] dArray = ml.getSample();
                int n = i;
                dArray[n] = dArray[n] * -1.0;
                if (!(ml.getSample()[i] > max)) continue;
                max = ml.getSample()[i];
            }
            i = 0;
            while (i < ml.getSample().length) {
                double[] dArray = ml.getSample();
                int n = i++;
                dArray[n] = dArray[n] + max;
            }
            this._shiftedGammaDist.fitSampleData(ml);
            i = 0;
            while (i < ml.getSample().length) {
                double[] dArray = ml.getSample();
                int n = i++;
                dArray[n] = dArray[n] - max;
            }
            i = 0;
            while (i < ml.getSample().length) {
                double[] dArray = ml.getSample();
                int n = i++;
                dArray[n] = dArray[n] * -1.0;
            }
            this.setSkew(-Math.sqrt(4.0 / this._shiftedGammaDist.getShape()));
            this.setStdv(-2.0 * this._shiftedGammaDist.getScale() / this.getSkew());
            this.setMean(-this._shiftedGammaDist.getShift() + 2.0 * this.getStdv() / this.getSkew() + max);
        }
        return true;
    }
}

