/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class PlottingPositions {
    private double _a;
    private double _b;
    StandardPlottingPosition _standardPlottingPosition = null;

    public PlottingPositions(double a, double b) {
        this._standardPlottingPosition = StandardPlottingPosition.OTHER;
        this._a = a;
        this._b = b;
    }

    public PlottingPositions(StandardPlottingPosition type) {
        this._standardPlottingPosition = type;
        this._a = type.getA();
        this._b = type.getB();
    }

    public PlottingPositions(PlottingPositions plottingPositions) {
        this._standardPlottingPosition = plottingPositions.getStandardPlottingPosition();
        this._a = plottingPositions.getA();
        this._b = plottingPositions.getB();
    }

    public void setStandardPlottingPosition(StandardPlottingPosition type) {
        this._standardPlottingPosition = type;
        this._a = type.getA();
        this._b = type.getB();
    }

    public double getA() {
        if (StandardPlottingPosition.OTHER.equals((Object)this._standardPlottingPosition)) {
            return this._a;
        }
        return this._standardPlottingPosition.getA();
    }

    public double getB() {
        if (StandardPlottingPosition.OTHER.equals((Object)this._standardPlottingPosition)) {
            return this._b;
        }
        return this._standardPlottingPosition.getB();
    }

    public double computePlottingPosition(int numberOfOutliers, double systematicWeight, int index, int n) {
        return PlottingPositions.computePlottingPosition(numberOfOutliers, systematicWeight, index, n, this.getA(), this.getB());
    }

    public double computePlottingPosition(int index, int n) {
        return this.computePlottingPosition(0, Double.NaN, index, n);
    }

    public double getDivisor(int n) {
        return PlottingPositions.getDivisor(n, this.getA(), this.getB());
    }

    public static double getDivisor(int n, double a, double b) {
        return (double)(n + 1) - a - b;
    }

    public static double computePlottingPosition(int index, int n, double a, double b) {
        return PlottingPositions.computePlottingPosition(0, Double.NaN, index, n, a, b);
    }

    public static double computePlottingPosition(int numberOfOutliers, double systematicWeight, int index, int n, double a, double b) {
        if (a >= 0.0 && a <= 1.0 && b >= 0.0 && b <= 1.0) {
            double divisor = PlottingPositions.getDivisor(n, a, b);
            if (divisor <= 0.0) {
                throw new IllegalArgumentException("(n + 1 - a - b) must be greater than zero.");
            }
            double rank = PlottingPositions.getRank(numberOfOutliers, systematicWeight, index);
            return (rank - a) / divisor;
        }
        throw new IllegalArgumentException("A and B values must be between zero and one.");
    }

    public static double computePlottingPosition(int index, int n, StandardPlottingPosition type) {
        return PlottingPositions.computePlottingPosition(index, n, type.getA(), type.getB());
    }

    private static double getRank(int numberOfOutliers, double systematicWeight, int index) {
        double rank = NumericalConstants.isValidValue((double)systematicWeight) && systematicWeight >= 0.0 && numberOfOutliers <= index - 1 ? systematicWeight * (double)index - (systematicWeight - 1.0) * ((double)numberOfOutliers + 0.5) : (double)index;
        return rank;
    }

    public StandardPlottingPosition getStandardPlottingPosition() {
        return this._standardPlottingPosition;
    }

    public void setA(double a) {
        this._a = a;
    }

    public void setB(double b) {
        this._b = b;
    }

    public static enum StandardPlottingPosition {
        WEIBULL(0.0, 0.0),
        MEDIAN(0.3, 0.3),
        HAZEN(0.5, 0.5),
        HIRSCHSTEDINGER(0.3, 0.3),
        OTHER(0.0, 0.0);

        private double _a;
        private double _b;

        private StandardPlottingPosition(double a, double b) {
            this._a = a;
            this._b = b;
        }

        public double getA() {
            return this._a;
        }

        public double getB() {
            return this._b;
        }
    }
}

