/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.DiscrDist;
import hec.statistics.LinearMoments;
import hec.statistics.ProductMoments;
import hec.statistics.SpecialFunctions;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class PoissonDist
implements DiscrDist {
    protected static final double MIN_LAM = 1.0E-5;
    private double _lam;

    public PoissonDist() {
        this(1.0);
    }

    public PoissonDist(double lam) {
        this.setLam(lam);
    }

    public PoissonDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public PoissonDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    public boolean fitSampleData(double[] sample) {
        return this.fitSampleData(sample, AbstractContDist.FittingMethod.ProductMoments);
    }

    public boolean fitSampleData(double[] sample, AbstractContDist.FittingMethod method) {
        switch (method) {
            default: {
                ProductMoments pm = new ProductMoments(sample);
                if (pm.getMean() <= 0.0) {
                    this.setLam(Double.NaN);
                    return false;
                }
                this.setLam(pm.getMean());
                return true;
            }
            case LinearMoments: 
        }
        LinearMoments lm = new LinearMoments(sample);
        if (lm.getL1() < 0.0) {
            this.setLam(Double.NaN);
            return false;
        }
        this.setLam(lm.getL1());
        return true;
    }

    public void setLam(double lam) {
        if (lam <= 1.0E-5) {
            lam = 1.0E-5;
        }
        this._lam = lam;
    }

    public double getLam() {
        return this._lam;
    }

    @Override
    public String getType() {
        return "Poisson";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Lambda"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getLam()};
    }

    @Override
    public String getSummaryDef(String format) {
        String[] pNames = this.getParamNames();
        double[] pVals = this.getParamVals();
        if (pNames == null) {
            return "";
        }
        Object summary = "";
        for (int i = 0; i < pNames.length; ++i) {
            summary = (String)summary + pNames[i] + "=" + String.format(format, pVals[i]) + (i < pNames.length - 1 ? "," : "");
        }
        return summary;
    }

    @Override
    public Object clone() {
        try {
            PoissonDist clonedDist = (PoissonDist)super.clone();
            return clonedDist;
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Error: Clone not supported");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("PoissonDistEnd")) {
                    return;
                }
                if (type.equals("Lam")) {
                    this.setLam(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read PoissonDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "PoissonDistBegin");
        TextFile.writeLine(writer, "Lam:" + this.getLam());
        TextFile.writeLine(writer, "PoissonDistEnd");
    }

    @Override
    public double getPDF(int value) {
        return Math.exp((double)value * Math.log(this._lam) - this._lam - SpecialFunctions.logFactorial(value));
    }

    @Override
    public double getCDF(int value) {
        return 1.0 - SpecialFunctions.regIncompleteGamma((double)value + 1.0, this._lam);
    }

    @Override
    public int invCDF(double p) {
        if (p < 0.0) {
            return 0;
        }
        if (p > 1.0) {
            return Integer.MAX_VALUE;
        }
        int xMin = (int)Math.max(0.0, this._lam - 8.0 * this._lam);
        int xMax = (int)(this.getLam() + 8.0 * this._lam);
        double accuPMin = this.getCDF(xMin);
        double accuPMax = 0.99999999;
        int accuX = 1;
        if (p < accuPMin) {
            return xMin;
        }
        if (p > accuPMax) {
            return xMax;
        }
        return this.invPoisson(p, accuX, xMin, xMax);
    }

    private final int invPoisson(double p, int delta, int lo, int hi) {
        int mid = (int)((double)(hi + lo) / 2.0);
        if (hi - lo <= delta) {
            return hi;
        }
        if (this.getCDF(mid) > p) {
            return this.invPoisson(p, delta, lo, mid);
        }
        return this.invPoisson(p, delta, mid, hi);
    }
}

