/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import java.util.ArrayList;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class ProductMoments {
    private final double mean;
    private final double stdDev;
    private final double skew;
    private final double kurtosis;

    public ProductMoments(double[] data) {
        if (data == null) {
            this.mean = 0.0;
            this.stdDev = 0.0;
            this.skew = 0.0;
            this.kurtosis = 0.0;
            return;
        }
        ArrayList<Double> validValues = new ArrayList<Double>();
        for (double value : data) {
            if (!NumericalConstants.isValidValue((double)value)) continue;
            validValues.add(value);
        }
        double[] arrayCopy = validValues.stream().mapToDouble(Double::doubleValue).toArray();
        int size = arrayCopy.length;
        double s1 = 0.0;
        for (double value : arrayCopy) {
            s1 += value / (double)size;
        }
        this.mean = size < 1 ? 0.0 : s1;
        double s2 = 0.0;
        double s3 = 0.0;
        double s4 = 0.0;
        for (double value : arrayCopy) {
            double xi1 = value - this.mean;
            double xi2 = xi1 * xi1;
            double xi3 = xi2 * xi1;
            double xi4 = xi3 * xi1;
            s2 += xi2;
            s3 += xi3;
            s4 += xi4;
        }
        this.stdDev = size < 2 ? 0.0 : Math.sqrt(s2 / (double)(size - 1));
        this.skew = size < 3 || this.stdDev == 0.0 ? 0.0 : (double)size * s3 / ((double)(size - 1) * (double)(size - 2) * this.stdDev * this.stdDev * this.stdDev);
        this.kurtosis = size < 4 || this.stdDev == 0.0 ? 0.0 : (double)size * (double)(size + 1) * s4 / ((double)(size - 1) * (double)(size - 2) * (double)(size - 3) * this.stdDev * this.stdDev * this.stdDev * this.stdDev) - 3.0 * (double)(size - 1) * (double)(size - 1) / (double)((size - 2) * (size - 3));
    }

    public double getMean() {
        return this.mean;
    }

    public double getStDv() {
        return this.stdDev;
    }

    public double getSkew() {
        return this.skew;
    }

    public double getKurt() {
        return this.kurtosis;
    }
}

