/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.ExponentialDist;
import hec.statistics.LinearMoments;
import hec.statistics.MaximumLikelihood;
import hec.statistics.ProductMoments;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class ShiftedExponentialDist
extends ExponentialDist {
    private double _shift;

    public ShiftedExponentialDist() {
        this(0.0);
    }

    public ShiftedExponentialDist(double shift) {
        this.setShift(shift);
    }

    public ShiftedExponentialDist(double scale, double shift) {
        super(scale);
        this.setShift(shift);
    }

    public ShiftedExponentialDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public ShiftedExponentialDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        if (pm.getStDv() < 1.0E-5) {
            this.setScale(Double.NaN);
            this.setShift(Double.NaN);
            return false;
        }
        this.setScale(pm.getStDv());
        this.setShift(pm.getMean() - pm.getStDv());
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        double scale = 2.0 * lm.getL2();
        if (scale < 1.0E-5) {
            this.setScale(Double.NaN);
            this.setShift(Double.NaN);
            return false;
        }
        this.setScale(scale);
        this.setShift(lm.getL1() - scale);
        return true;
    }

    @Override
    public boolean fitSampleData(MaximumLikelihood ml) {
        double shift = Double.POSITIVE_INFINITY;
        for (double cur : ml.getSample()) {
            shift = Math.min(shift, cur);
        }
        double scale = 0.0;
        for (int i = 0; i < ml.getSample().length; ++i) {
            scale += (ml.getSample()[i] - shift) / (double)ml.getSample().length;
        }
        this.setScale(scale);
        this.setShift(shift);
        return true;
    }

    public void setShift(double shift) {
        this._shift = shift;
    }

    public double getShift() {
        return this._shift;
    }

    @Override
    public String getType() {
        return "ShiftedExponential";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Scale", "Shift"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getScale(), this.getShift()};
    }

    @Override
    public Object clone() {
        ExponentialDist clonedDist = (ExponentialDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("ShiftedExponentialDistEnd")) {
                    return;
                }
                if (type.equals("Scale")) {
                    this.setScale(Double.parseDouble(param));
                } else if (type.equals("Shift")) {
                    this.setShift(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read ShiftedExponentialDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "ShiftedExponentialDistBegin");
        TextFile.writeLine(writer, "Scale:" + this.getScale());
        TextFile.writeLine(writer, "Shift:" + this.getShift());
        TextFile.writeLine(writer, "ShiftedExponentialDistEnd");
    }

    @Override
    public double getPDF(double value) {
        return super.getPDF(value - this._shift);
    }

    @Override
    public double getCDF(double value) {
        return super.getCDF(value - this._shift);
    }

    @Override
    public double invCDF(double p) {
        ExponentialDist ed = new ExponentialDist(this.getScale());
        return ed.invCDF(p) + this._shift;
    }
}

