/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.ClipData;
import hec.statistics.ClipDist;
import hec.statistics.ShiftedGammaDist;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class ShiftedGammaClipDist
extends ShiftedGammaDist
implements ClipDist {
    private ClipData _clip = new ClipData(){

        @Override
        public void setMinVal(double minVal) {
            super.setMinVal(minVal);
            super.setMinProb(ShiftedGammaClipDist.super.getCDF(minVal));
        }

        @Override
        public void setMinProb(double minProb) {
            super.setMinProb(minProb);
            ShiftedGammaDist sgd = new ShiftedGammaDist(ShiftedGammaClipDist.this.getShape(), ShiftedGammaClipDist.this.getScale(), ShiftedGammaClipDist.this.getShift());
            super.setMinVal(sgd.invCDF(minProb));
        }

        @Override
        public void setMaxVal(double maxVal) {
            super.setMaxVal(maxVal);
            super.setMaxProb(ShiftedGammaClipDist.super.getCDF(maxVal));
        }

        @Override
        public void setMaxProb(double maxProb) {
            super.setMaxProb(maxProb);
            ShiftedGammaDist sgd = new ShiftedGammaDist(ShiftedGammaClipDist.this.getShape(), ShiftedGammaClipDist.this.getScale(), ShiftedGammaClipDist.this.getShift());
            super.setMaxVal(sgd.invCDF(maxProb));
        }
    };
    static final int COMPUTE_FLAG = 0;

    public ShiftedGammaClipDist() {
    }

    public ShiftedGammaClipDist(double shape, double scale, double shift) {
        super(shape, scale, shift);
    }

    @Override
    public ClipData getClipData() {
        return this._clip;
    }

    @Override
    public String[] getClipParamNames() {
        if (this.getClipData() == null) {
            return new String[0];
        }
        return this.getClipData().getClipParamNames();
    }

    @Override
    public double[] getClipParamVals() {
        if (this.getClipData() == null) {
            return new double[0];
        }
        return this.getClipData().getClipParamVals();
    }

    @Override
    public String getSummaryClip(String format) {
        if (this.getClipData() == null) {
            return "";
        }
        return this.getClipData().getSummary(format);
    }

    @Override
    public Object clone() {
        ShiftedGammaClipDist clonedDist = (ShiftedGammaClipDist)super.clone();
        clonedDist._clip = (ClipData)this._clip.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("ShiftedGammaClipDistEnd")) {
                    return;
                }
                if (type.equals("Shape")) {
                    this.setShape(Double.parseDouble(param));
                } else if (type.equals("Scale")) {
                    this.setScale(Double.parseDouble(param));
                } else if (type.equals("Shift")) {
                    this.setShift(Double.parseDouble(param));
                } else if (type.equals("ClipDataBegin")) {
                    this._clip.read(reader);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read ShiftedGammaClipDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "ShiftedGammaClipDistBegin");
        TextFile.writeLine(writer, "Shape:" + this.getShape());
        TextFile.writeLine(writer, "Scale:" + this.getScale());
        TextFile.writeLine(writer, "Shift:" + this.getShift());
        this._clip.write(writer);
        TextFile.writeLine(writer, "ShiftedGammaClipDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal() || this.getClipData().hasMaxClip() && value > this.getClipData().getMaxVal()) {
            return 0.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return super.getPDF(value) / rescale;
    }

    @Override
    public double getCDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal()) {
            return 0.0;
        }
        if (this.getClipData().hasMaxClip() && value >= this.getClipData().getMaxVal()) {
            return 1.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return (super.getCDF(value) - minProb) / rescale;
    }

    @Override
    public double invCDF(double p) {
        ShiftedGammaDist sgd = new ShiftedGammaDist(this.getShape(), this.getScale(), this.getShift());
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return sgd.invCDF(minProb + p * rescale);
    }
}

