/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.EquationSolverNewton;
import hec.statistics.GammaDist;
import hec.statistics.LinearMoments;
import hec.statistics.MaximumLikelihood;
import hec.statistics.ProductMoments;
import hec.statistics.SpecialFunctions;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class ShiftedGammaDist
extends GammaDist {
    private double _shift;
    private GammaDist _encapsulatedDist = new GammaDist();

    public ShiftedGammaDist() {
        this(0.0);
    }

    public ShiftedGammaDist(double shift) {
        this.setShift(shift);
    }

    public ShiftedGammaDist(double shape, double scale, double shift) {
        super(shape, scale);
        this.setShift(shift);
    }

    public ShiftedGammaDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public ShiftedGammaDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        double shape = 4.0 / (pm.getSkew() * pm.getSkew());
        double scale = 0.5 * pm.getStDv() * pm.getSkew();
        if (shape < 1.0E-5 || scale < 1.0E-5) {
            this.setShape(Double.NaN);
            this.setScale(Double.NaN);
            this.setShift(Double.NaN);
            return false;
        }
        this.setShape(shape);
        this.setScale(scale);
        this.setShift(pm.getMean() - 2.0 * pm.getStDv() / pm.getSkew());
        return !Double.isNaN(shape);
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        double sqrtPi = 1.772453850905516;
        if (lm.getL2() <= 1.0E-5 || lm.getT3() <= 1.0E-4) {
            this.setShape(Double.NaN);
            this.setScale(Double.NaN);
            this.setShift(Double.NaN);
            return false;
        }
        EquationSolverNewton solverShapeL = new EquationSolverNewton(){

            @Override
            public double f(double x) {
                if (x == 0.0) {
                    return 1.0;
                }
                return 6.0 * SpecialFunctions.regIncompleteBeta(x, 2.0 * x, 0.3333333333333333) - 3.0;
            }
        };
        double shapeGuess = Math.exp(Math.log(1.0 / lm.getT3() - 1.0) / 0.6 + Math.log(0.4));
        double dx = Math.max(1.0E-10, Math.min(100.0, Math.pow(10.0, -11.0 + Math.log10(shapeGuess) * 2.71)));
        this.setShape(solverShapeL.newton(lm.getT3(), shapeGuess, 1.0E-10, 100, dx));
        this.setScale(lm.getL2() * 1.772453850905516 * Math.exp(SpecialFunctions.logGamma(this.getShape()) - SpecialFunctions.logGamma(this.getShape() + 0.5)));
        this.setShift(lm.getL1() - this.getShape() * this.getScale());
        return !Double.isNaN(this.getShape());
    }

    public void setShift(double shift) {
        this._shift = shift;
    }

    public double getShift() {
        return this._shift;
    }

    @Override
    public String getType() {
        return "ShiftedGamma";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Shape", "Scale", "Shift"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getShape(), this.getScale(), this.getShift()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setShape(vals[0]);
        this.setScale(vals[1]);
        this.setShift(vals[2]);
    }

    @Override
    public Object clone() {
        GammaDist clonedDist = (GammaDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("ShiftedGammaDistEnd")) {
                    return;
                }
                if (type.equals("Shape")) {
                    this.setShape(Double.parseDouble(param));
                } else if (type.equals("Scale")) {
                    this.setScale(Double.parseDouble(param));
                } else if (type.equals("Shift")) {
                    this.setShift(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read ShiftedGammaDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "ShiftedGammaDistBegin");
        TextFile.writeLine(writer, "Shape:" + this.getShape());
        TextFile.writeLine(writer, "Scale:" + this.getScale());
        TextFile.writeLine(writer, "Shift:" + this.getShift());
        TextFile.writeLine(writer, "ShiftedGammaDistEnd");
    }

    @Override
    public double getPDF(double value) {
        return super.getPDF(value - this._shift);
    }

    @Override
    public double getCDF(double value) {
        return super.getCDF(value - this._shift);
    }

    @Override
    public double invCDF(double p) {
        this._encapsulatedDist.setShape(this.getShape());
        this._encapsulatedDist.setScale(this.getScale());
        return this._encapsulatedDist.invCDF(p) + this._shift;
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        double sumLog = 0.0;
        double sumX = 0.0;
        int n = sample.length;
        for (int i = 0; i < n; ++i) {
            sumLog += Math.log(sample[i] - this.getShift());
            sumX += sample[i] - this.getShift();
        }
        double retval = (this.getShape() - 1.0) * sumLog - (double)n * SpecialFunctions.logGamma(this.getShape()) - (double)n * this.getShape() * Math.log(this.getScale()) - 1.0 / this.getScale() * sumX;
        return retval;
    }

    @Override
    public double[] getLogLikelihoodJacobian(double[] sample) {
        double sumLog = 0.0;
        double sumX = 0.0;
        double sumInvX = 0.0;
        int n = sample.length;
        for (int i = 0; i < n; ++i) {
            sumLog += Math.log(sample[i] - this.getShift());
            sumX += sample[i] - this.getShift();
            sumInvX += 1.0 / (sample[i] - this.getShift());
        }
        return new double[]{sumLog - (double)n * SpecialFunctions.digamma(this.getShape()) - (double)n * Math.log(this.getScale()), (double)(-n) * this.getShape() / this.getScale() + sumX / (this.getScale() * this.getScale()), -(this.getShape() - 1.0) * sumInvX + (double)n / this.getScale()};
    }

    @Override
    public double[] getLogLikelihoodHessian(double[] sample) {
        double sumX = 0.0;
        double sumInvX = 0.0;
        double sumInvX2 = 0.0;
        int n = sample.length;
        for (int i = 0; i < n; ++i) {
            sumX += sample[i] - this.getShift();
            sumInvX += 1.0 / (sample[i] - this.getShift());
            sumInvX2 += 1.0 / ((sample[i] - this.getShift()) * (sample[i] - this.getShift()));
        }
        double dada = (double)n * SpecialFunctions.trigamma(this.getShape());
        double dadb = (double)n / this.getScale();
        double dads = sumInvX;
        double dbdb = (double)(-n) * this.getShape() / (this.getScale() * this.getScale()) + 2.0 / (this.getScale() * this.getScale() * this.getScale()) * sumX;
        double dbds = (double)n / (this.getScale() * this.getScale());
        double dsds = (this.getShape() - 1.0) * sumInvX2;
        return new double[]{dada, dadb, dads, dadb, dbdb, dbds, dads, dbds, dsds};
    }

    @Override
    public boolean fitSampleData(MaximumLikelihood ml) {
        double[] gammaSample = Arrays.copyOf(ml.getSample(), ml.getSample().length);
        double shift = gammaSample[0];
        for (int i = 1; i < gammaSample.length; ++i) {
            if (!(gammaSample[i] < shift)) continue;
            shift = gammaSample[i];
        }
        if (!NumericalConstants.isValidValue((double)shift)) {
            return false;
        }
        if (shift == 0.0) {
            shift = 1.0E-16;
        }
        double shiftMax = shift - Math.abs(shift) * 1.0E-16;
        int i = 16;
        while (Math.abs(shift - shiftMax) == 0.0 || !this.fitWithShift(gammaSample, shiftMax)) {
            shiftMax = shift - Math.abs(shift) * Math.pow(10.0, -i);
            --i;
        }
        double[] shiftMaxPars = this.getParamVals();
        double shiftMaxLikelihood = this.getLogLikelihood(ml.getSample());
        double dfdsShiftMax = this.dfds(shiftMax, gammaSample);
        ProductMoments pm = new ProductMoments(gammaSample);
        double shiftMin = pm.getMean() - 3.0 * pm.getStDv() / pm.getSkew();
        if (shiftMin >= shiftMax) {
            shiftMin = shiftMax - 2.0 * pm.getStDv() / pm.getSkew();
        }
        this.fitWithShift(gammaSample, shiftMin);
        double dfdsShiftMin = this.dfds(shiftMin, gammaSample);
        while (dfdsShiftMin < 0.0) {
            this.fitWithShift(gammaSample, shiftMin -= pm.getStDv() / pm.getSkew());
            dfdsShiftMin = this.dfds(shiftMin, gammaSample);
        }
        shift = this.biSearch(gammaSample, shiftMin, dfdsShiftMin, shiftMax, dfdsShiftMax, 1.0E-10);
        this.fitWithShift(gammaSample, shift);
        if (this.getLogLikelihood(ml.getSample()) < shiftMaxLikelihood) {
            this.setParamVals(shiftMaxPars);
        }
        return true;
    }

    private double dfds(double xOld, double[] gammaSample) {
        double sumInv = 0.0;
        for (int i = 0; i < gammaSample.length; ++i) {
            sumInv += 1.0 / (gammaSample[i] - xOld);
        }
        return (double)gammaSample.length / this.getScale() - (this.getShape() - 1.0) * sumInv;
    }

    private double biSearch(double[] gammaSample, double xMin, double fMin, double xMax, double fMax, double tolX) {
        while (true) {
            double xAvg = 0.5 * (xMin + xMax);
            this.fitWithShift(gammaSample, xAvg);
            double fAvg = this.dfds(xAvg, gammaSample);
            if (xMax - xMin < tolX || xMax - xAvg < tolX || xAvg - xMin < tolX || !NumericalConstants.isValidValue((double)fAvg)) {
                if (NumericalConstants.isValidValue((double)fAvg) && Math.abs(fAvg) < fMin && Math.abs(fAvg) < fMax) {
                    return xAvg;
                }
                if (Math.abs(fMax) < fMin) {
                    return xMax;
                }
                return xMin;
            }
            if (fAvg > 0.0) {
                xMin = xAvg;
                fMin = fAvg;
                continue;
            }
            xMax = xAvg;
            fMax = fAvg;
        }
    }

    private boolean fitWithShift(double[] gammaSample, double shift) {
        int i = 0;
        while (i < gammaSample.length) {
            int n = i++;
            gammaSample[n] = gammaSample[n] - shift;
        }
        GammaDist dist = new GammaDist();
        boolean retval = dist.fitSampleData(new MaximumLikelihood(gammaSample, MaximumLikelihood.MinimizationMethod.NEWTON));
        this.setScale(dist.getScale());
        this.setShape(dist.getShape());
        this.setShift(shift);
        int i2 = 0;
        while (i2 < gammaSample.length) {
            int n = i2++;
            gammaSample[n] = gammaSample[n] + shift;
        }
        return retval;
    }
}

