/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.EquationSolverBiSearch;
import hec.statistics.LinearMoments;
import hec.statistics.LogNormalDist;
import hec.statistics.MaximumLikelihood;
import hec.statistics.ProductMoments;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class ShiftedLogNormalDist
extends LogNormalDist {
    private double _shift;

    public ShiftedLogNormalDist() {
        this(0.0);
    }

    public ShiftedLogNormalDist(double shift) {
        this.setShift(shift);
    }

    public ShiftedLogNormalDist(double meanOfLn, double stdvOfLn, double shift) {
        super(meanOfLn, stdvOfLn);
        this.setShift(shift);
    }

    public ShiftedLogNormalDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public ShiftedLogNormalDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public void setParams1(double[] logParams) {
        if (logParams == null || logParams.length < 3) {
            return;
        }
        double meanOfLn = logParams[0];
        double stdvOfLn = logParams[1];
        double shift = logParams[2];
        this.setMeanOfLn(meanOfLn);
        this.setStdvOfLn(stdvOfLn);
        this.setShift(shift);
    }

    @Override
    public double[] getParams1() {
        return new double[]{this.getMeanOfLn(), this.getStdvOfLn(), this.getShift()};
    }

    @Override
    public String[] getParamNames1() {
        return new String[]{"MeanLn", "StDvLn", "Shift"};
    }

    @Override
    public void setParams2(double[] linParams) {
        if (linParams == null || linParams.length < 3) {
            return;
        }
        double mean = linParams[0];
        double stdv = linParams[1];
        double shift = linParams[2];
        double meanOfLn = 2.0 * Math.log(mean) - 0.5 * Math.log(mean * mean + stdv * stdv);
        double stdvOfLn = Math.sqrt(Math.log(mean * mean + stdv * stdv) - 2.0 * Math.log(mean));
        this.setMeanOfLn(meanOfLn);
        this.setStdvOfLn(stdvOfLn);
        this.setShift(shift);
    }

    @Override
    public double[] getParams2() {
        double meanOfLn = this.getMeanOfLn();
        double stdvOfLn = this.getStdvOfLn();
        double shift = this.getShift();
        double mean = Math.exp(meanOfLn + stdvOfLn * stdvOfLn * 0.5);
        double stdv = mean * Math.sqrt(Math.exp(stdvOfLn * stdvOfLn) - 1.0);
        return new double[]{mean, stdv, shift};
    }

    @Override
    public String[] getParamNames2() {
        return new String[]{"Mean", "StDv", "Shift"};
    }

    @Override
    public boolean fitSampleData(double[] sample, AbstractContDist.FittingMethod method) {
        switch (method) {
            default: {
                ProductMoments pm = new ProductMoments(sample);
                return this.fitSampleData(pm);
            }
            case LinearMoments: {
                LinearMoments lm = new LinearMoments(sample);
                return this.fitSampleData(lm);
            }
            case MaximumLikelihood: 
        }
        MaximumLikelihood ml = new MaximumLikelihood(sample, MaximumLikelihood.MinimizationMethod.NEWTON);
        return this.fitSampleData(ml);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        this.setParametrizationName("Logarithmic");
        if (pm.getSkew() < 1.0E-5 || pm.getStDv() < 1.0E-5) {
            this.setShift(Double.NaN);
            this.setMeanOfLn(Double.NaN);
            this.setStdvOfLn(Double.NaN);
            return false;
        }
        double skew2 = pm.getSkew() * pm.getSkew();
        double cTerm = Math.cbrt(0.5 * (-(2.0 + skew2) + Math.sqrt(skew2 * (4.0 + skew2))));
        double xTerm = -(1.0 + cTerm + 1.0 / cTerm);
        double yTerm = pm.getStDv() / Math.sqrt(xTerm * (xTerm - 1.0));
        this.setMeanOfLn(Math.log(yTerm));
        this.setStdvOfLn(Math.sqrt(Math.log(xTerm)));
        this.setShift(pm.getMean() - yTerm * Math.sqrt(xTerm));
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        this.setParametrizationName("Logarithmic");
        this.setMeanOfLn(Double.NaN);
        this.setStdvOfLn(Double.NaN);
        this.setShift(Double.NaN);
        return false;
    }

    public void setShift(double shift) {
        this._shift = shift;
    }

    public double getShift() {
        return this._shift;
    }

    @Override
    public String getType() {
        return "ShiftedLogNormal";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"MeanLn", "StDvLn", "Shift"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getMeanOfLn(), this.getStdvOfLn(), this.getShift()};
    }

    @Override
    public void setParamVals(double[] vals) {
        this.setMeanOfLn(vals[0]);
        this.setStdvOfLn(vals[1]);
        this.setShift(vals[2]);
    }

    @Override
    public Object clone() {
        ShiftedLogNormalDist clonedDist = (ShiftedLogNormalDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("ShiftedLogNormalDistEnd")) {
                    return;
                }
                if (type.equals("MeanOfLn")) {
                    this.setMeanOfLn(Double.parseDouble(param));
                } else if (type.equals("StdvOfLn")) {
                    this.setStdvOfLn(Double.parseDouble(param));
                } else if (type.equals("Shift")) {
                    this.setShift(Double.parseDouble(param));
                } else if (type.equals("Parametrization")) {
                    this.setParametrizationName(param);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read ShiftedLogNormalDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "ShiftedLogNormalDistBegin");
        TextFile.writeLine(writer, "MeanOfLn:" + this.getMeanOfLn());
        TextFile.writeLine(writer, "StdvOfLn:" + this.getStdvOfLn());
        TextFile.writeLine(writer, "Shifted:" + this.getShift());
        TextFile.writeLine(writer, "Parametrization:" + this.getParametrizationName());
        TextFile.writeLine(writer, "ShiftedLogNormalDistEnd");
    }

    @Override
    public double getPDF(double value) {
        return super.getPDF(value - this._shift);
    }

    @Override
    public double getCDF(double value) {
        return super.getCDF(value - this._shift);
    }

    @Override
    public double invCDF(double p) {
        LogNormalDist lnd = new LogNormalDist(this.getMeanOfLn(), this.getStdvOfLn());
        return lnd.invCDF(p) + this._shift;
    }

    @Override
    public boolean fitSampleData(final MaximumLikelihood ml) {
        double minVal = Double.MAX_VALUE;
        for (int i = 0; i < ml.getSample().length; ++i) {
            if (!(ml.getSample()[i] < minVal)) continue;
            minVal = ml.getSample()[i];
        }
        double shiftMax = minVal - Math.abs(minVal) * 1.0E-16;
        int i = 16;
        while (Math.abs(minVal - shiftMax) == 0.0) {
            shiftMax = minVal - Math.abs(minVal) * Math.pow(10.0, -i);
            --i;
        }
        this.fitWithShift(shiftMax, ml);
        double ds = this.getLogLikelihoodJacobian(ml.getSample())[2];
        if (ds >= 0.0) {
            return true;
        }
        double shiftMin = 0.0;
        double multiplier = Math.abs(this.getMeanOfLn() / this.getStdvOfLn());
        while (ds < 0.0) {
            shiftMin = shiftMax - Math.abs(shiftMax) * multiplier;
            this.fitWithShift(shiftMin, ml);
            ds = this.getLogLikelihoodJacobian(ml.getSample())[2];
            multiplier *= 10.0;
        }
        EquationSolverBiSearch biSearch = new EquationSolverBiSearch(){

            @Override
            public double f(double x) {
                ShiftedLogNormalDist.this.fitWithShift(x, ml);
                return ShiftedLogNormalDist.this.getLogLikelihoodJacobian(ml.getSample())[2];
            }
        };
        biSearch.biSearch(0.0, shiftMin, shiftMax, 1.0E-10);
        return true;
    }

    private void fitWithShift(double shift, MaximumLikelihood ml) {
        int i = 0;
        while (i < ml.getSample().length) {
            double[] dArray = ml.getSample();
            int n = i++;
            dArray[n] = dArray[n] - shift;
        }
        super.fitSampleData(ml);
        this.setShift(shift);
        i = 0;
        while (i < ml.getSample().length) {
            double[] dArray = ml.getSample();
            int n = i++;
            dArray[n] = dArray[n] + shift;
        }
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        double[] shiftSample = new double[sample.length];
        for (int i = 0; i < sample.length; ++i) {
            shiftSample[i] = sample[i] - this.getShift();
        }
        double retval = super.getLogLikelihood(shiftSample);
        return retval;
    }

    @Override
    public double[] getLogLikelihoodJacobian(double[] sample) {
        double dm = 0.0;
        double dv = 0.0;
        double ds = 0.0;
        double v2 = this.getStdvOfLn() * this.getStdvOfLn();
        double v3 = this.getStdvOfLn() * this.getStdvOfLn() * this.getStdvOfLn();
        for (int i = 0; i < sample.length; ++i) {
            double diff = Math.log(sample[i] - this.getShift()) - this.getMeanOfLn();
            dm += diff / v2;
            dv += diff * diff / v3;
            ds -= (diff + v2) / (v2 * (this.getShift() - sample[i]));
        }
        return new double[]{dm, (double)(-sample.length) / this.getStdvOfLn() + dv, ds};
    }
}

