/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import java.util.logging.Level;
import java.util.logging.Logger;

public class SpecialFunctions {
    public static final double EulerConst = 0.5772156649015329;
    private static double GAMMA = 0.5772156649015329;
    private static double GAMMA_MINX = 1.0E-12;
    private static double DIGAMMA_MINNEGX = -1250.0;
    private static double C_LIMIT = 49.0;
    private static double S_LIMIT = 1.0E-5;
    private static final double B10 = 0.07575757575757576;
    private static final double B2 = 0.16666666666666666;
    private static final double B4 = -0.03333333333333333;
    private static final double B6 = 0.023809523809523808;
    private static final double B8 = -0.03333333333333333;
    private static final double c = Math.pow(Math.PI, 0.3333333333333333);
    private static final double c1 = -2.4041138063191885;
    private static final double SMALL_TRIGAMMA = 1.0E-4;
    private static final double LARGE_TRIGAMMA = 8.0;

    public static final double logGamma(double t) {
        if (Double.isNaN(t) || t <= 0.0) {
            return Double.NaN;
        }
        if (t < 0.5) {
            return Math.log(Math.PI) - Math.log(Math.sin(Math.PI * t)) - SpecialFunctions.logGamma(1.0 - t);
        }
        double sum = 0.9999999999998099 + 676.5203681218851 / t - 1259.1392167224028 / (t + 1.0) + 771.3234287776531 / (t + 2.0) - 176.6150291621406 / (t + 3.0) + 12.507343278686905 / (t + 4.0) - 0.13857109526572012 / (t + 5.0) + 9.984369578019572E-6 / (t + 6.0) + 1.5056327351493116E-7 / (t + 7.0);
        double base = t + 7.0 - 0.5;
        return 0.5 * Math.log(Math.PI * 2) + Math.log(sum) - base + (t - 0.5) * Math.log(base);
    }

    public static final double logFactorial(int n) {
        return SpecialFunctions.logGamma((double)n + 1.0);
    }

    public static final double gamma(double t) {
        return Math.exp(SpecialFunctions.logGamma(t));
    }

    public static final long factorial(int n) {
        return Math.round(SpecialFunctions.gamma((double)n + 1.0));
    }

    public static final double incompleteGamma(double t, double x) {
        return SpecialFunctions.gamma(t) * SpecialFunctions.regIncompleteGamma(t, x);
    }

    public static final double incompleteGamma(double t, double xl, double xu) {
        return SpecialFunctions.incompleteGamma(t, xu) - SpecialFunctions.incompleteGamma(t, xl);
    }

    public static final double regIncompleteGamma(double t, double x) {
        return SpecialFunctions.regularizedGammaP(t, x, 1.0E-14, Integer.MAX_VALUE);
    }

    public static final double logIncompleteGamma(double t, double x) {
        return SpecialFunctions.logGamma(t) + Math.log(SpecialFunctions.regIncompleteGamma(t, x));
    }

    public static double digamma(double x) {
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            return x;
        }
        if (Math.signum(x) == -1.0 && Math.ceil(x) == x || x == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double value = 0.0;
        while (true) {
            if (x >= 0.0 && x < GAMMA_MINX) {
                x = GAMMA_MINX;
            }
            if (x < DIGAMMA_MINNEGX) {
                x = DIGAMMA_MINNEGX + GAMMA_MINX;
                continue;
            }
            if (x > 0.0 && x <= S_LIMIT) {
                return value + -GAMMA - 1.0 / x;
            }
            if (x >= C_LIMIT) {
                double inv = 1.0 / (x * x);
                return value + Math.log(x) - 0.5 / x - inv * (0.08333333333333333 + inv * (0.008333333333333333 - inv / 252.0));
            }
            value -= 1.0 / x;
            x += 1.0;
        }
    }

    private static final double regularizedGammaP(double a, double x, double epsilon, int maxIterations) {
        double ret = 0.0;
        if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
            ret = Double.NaN;
        } else if (x == 0.0) {
            ret = 0.0;
        } else if (x >= a + 1.0) {
            ret = 1.0 - SpecialFunctions.regularizedGammaQ(a, x, epsilon, maxIterations);
        } else {
            double sum;
            double an;
            double n = 0.0;
            for (sum = an = 1.0 / a; Math.abs(an / sum) > epsilon && n < (double)maxIterations && sum < Double.POSITIVE_INFINITY; sum += (an *= x / (a + (n += 1.0)))) {
            }
            if (!(n >= (double)maxIterations)) {
                ret = Double.isInfinite(sum) ? 1.0 : Math.exp(-x + a * Math.log(x) - SpecialFunctions.logGamma(a)) * sum;
            }
        }
        return ret;
    }

    private static final double regularizedGammaQ(double a, double x, double epsilon, int maxIterations) {
        double ret;
        if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
            ret = Double.NaN;
        } else if (x == 0.0) {
            ret = 1.0;
        } else if (x < a + 1.0) {
            ret = 1.0 - SpecialFunctions.regularizedGammaP(a, x, epsilon, maxIterations);
        } else {
            ret = 1.0 / SpecialFunctions.evaluateCFGammaQ(a, x, epsilon, maxIterations);
            ret = Math.exp(-x + a * Math.log(x) - SpecialFunctions.logGamma(a)) * ret;
        }
        return ret;
    }

    private static final double evaluateCFGammaQ(double a, double x, double epsilon, int maxIterations) {
        int n;
        double small = 1.0E-50;
        double hPrev = 1.0 - a + x;
        if (Math.abs(hPrev - 0.0) < 1.0E-50) {
            hPrev = 1.0E-50;
        }
        double dPrev = 0.0;
        double cPrev = hPrev;
        double hN = hPrev;
        for (n = 1; n < maxIterations; ++n) {
            double deltaN;
            double cN;
            double aa = 2.0 * (double)n + 1.0 - a + x;
            double bb = (double)n * (a - (double)n);
            double dN = aa + bb * dPrev;
            if (Math.abs(dN - 0.0) < 1.0E-50) {
                dN = 1.0E-50;
            }
            if (Math.abs((cN = aa + bb / cPrev) - 0.0) < 1.0E-50) {
                cN = 1.0E-50;
            }
            if (Double.isInfinite(hN = hPrev * (deltaN = cN * (dN = 1.0 / dN)))) {
                // empty if block
            }
            if (Double.isNaN(hN)) {
                // empty if block
            }
            if (Math.abs(deltaN - 1.0) < epsilon) break;
            dPrev = dN;
            cPrev = cN;
            hPrev = hN;
        }
        if (n >= maxIterations) {
            // empty if block
        }
        return hN;
    }

    public static final double logBeta(double s, double t) {
        if (Double.isNaN(s) || Double.isNaN(t) || s <= 0.0 || t <= 0.0) {
            return Double.NaN;
        }
        return SpecialFunctions.logGamma(s) + (SpecialFunctions.logGamma(t) - SpecialFunctions.logGamma(s + t));
    }

    public static final double beta(double s, double t) {
        return Math.exp(SpecialFunctions.logBeta(s, t));
    }

    public static final double incompleteBeta(double s, double t, double x) {
        return SpecialFunctions.beta(s, t) * SpecialFunctions.regIncompleteBeta(s, t, x);
    }

    public static final double regIncompleteBeta(double s, double t, double x) {
        return SpecialFunctions.regularizedBeta(s, t, x, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double regularizedBeta(double a, double b, double x, double epsilon, int maxIterations) {
        double ret = Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b) || x < 0.0 || x > 1.0 || a <= 0.0 || b <= 0.0 ? Double.NaN : (x > (a + 1.0) / (2.0 + b + a) && 1.0 - x <= (b + 1.0) / (2.0 + b + a) ? 1.0 - SpecialFunctions.regularizedBeta(b, a, 1.0 - x, epsilon, maxIterations) : Math.exp(a * Math.log(x) + b * Math.log1p(-x) - Math.log(a) - SpecialFunctions.logBeta(a, b)) * 1.0 / SpecialFunctions.evaluateCFBeta(a, b, x, epsilon, maxIterations));
        return ret;
    }

    static double trigamma(double x) {
        if (Double.isNaN(x) || Double.isInfinite(x) || Double.compare(0.0, x) == 0 || x < 0.0 && Double.compare(Math.floor(x), x) == 0) {
            return Double.NaN;
        }
        double y = 0.0;
        if (x < 0.0) {
            double val = Math.PI * (1.0 / Math.sin(-Math.PI * x));
            y = -SpecialFunctions.trigamma(-x + 1.0) + val * val;
        }
        if (x > 0.0 && x <= 1.0E-4) {
            y = 1.0 / (x * x) + c + -2.4041138063191885 * x;
        }
        while (x > 1.0E-4 && x < 8.0) {
            y += 1.0 / (x * x);
            x += 1.0;
        }
        if (x >= 8.0) {
            double z = 1.0 / (x * x);
            y += 0.5 * z + (1.0 + z * (0.16666666666666666 + z * (-0.03333333333333333 + z * (0.023809523809523808 + z * (-0.03333333333333333 + z * 0.07575757575757576))))) / x;
        }
        return y;
    }

    private static final double evaluateCFBeta(double a, double b, double x, double epsilon, int maxIterations) {
        int n;
        double small = 1.0E-50;
        double hPrev = 1.0;
        if (Math.abs(hPrev - 0.0) < 1.0E-50) {
            hPrev = 1.0E-50;
        }
        double dPrev = 0.0;
        double cPrev = hPrev;
        double hN = hPrev;
        for (n = 1; n < maxIterations; ++n) {
            double deltaN;
            double cN;
            double bb;
            double m;
            double aa = 1.0;
            if (n % 2 == 0) {
                m = (double)n / 2.0;
                bb = m * (b - m) * x / ((a + 2.0 * m - 1.0) * (a + 2.0 * m));
            } else {
                m = ((double)n - 1.0) / 2.0;
                bb = -((a + m) * (a + b + m) * x) / ((a + 2.0 * m) * (a + 2.0 * m + 1.0));
            }
            double dN = 1.0 + bb * dPrev;
            if (Math.abs(dN - 0.0) < 1.0E-50) {
                dN = 1.0E-50;
            }
            if (Math.abs((cN = 1.0 + bb / cPrev) - 0.0) < 1.0E-50) {
                cN = 1.0E-50;
            }
            if (Double.isInfinite(hN = hPrev * (deltaN = cN * (dN = 1.0 / dN)))) {
                // empty if block
            }
            if (Double.isNaN(hN)) {
                // empty if block
            }
            if (Math.abs(deltaN - 1.0) < epsilon) break;
            dPrev = dN;
            cPrev = cN;
            hPrev = hN;
        }
        if (n >= maxIterations) {
            // empty if block
        }
        return hN;
    }

    public static final double t(double loctn, double scale, double shape, double x) {
        if (shape == 0.0) {
            return Math.exp(-(x - loctn) / scale);
        }
        return Math.pow(1.0 - shape * (x - loctn) / scale, 1.0 / shape);
    }

    public static final double tInv(double loctn, double scale, double shape, double y) {
        if (shape == 0.0) {
            return loctn - scale * Math.log(y);
        }
        return loctn - scale * (Math.pow(y, shape) - 1.0) / shape;
    }

    public static int binomialCoefficient(int n, int k) {
        if (n < k) {
            Logger.getLogger(SpecialFunctions.class.getName().toString()).log(Level.SEVERE, "N has to be greater than k");
        }
        return (int)SpecialFunctions.factorial(n) / ((int)SpecialFunctions.factorial(k) * (int)SpecialFunctions.factorial(n - k));
    }

    public static double singleParGammaPDF(double alpha, double x) {
        return Math.pow(x, alpha - 1.0) * Math.exp(-x) / SpecialFunctions.gamma(alpha);
    }

    public static double gammaDerivative(double alpha, double x) {
        if (alpha < 0.0 || x < 0.0 || Math.abs(x - alpha) / Math.sqrt(alpha + 1.0) > 7.0) {
            return 0.0;
        }
        double log_X = Math.log(x);
        double tol = 1.0E-11;
        if (x < 5.0) {
            double t = Math.pow(x, alpha);
            double r = (alpha * log_X - 1.0) / Math.pow(alpha, 2.0);
            double sum = t * r;
            for (int i = 1; i <= 1000; ++i) {
                double ai = alpha + (double)i;
                t = -t * x / (double)i;
                r = (ai * log_X - 1.0) / Math.pow(ai, 2.0);
                double del = r * t;
                sum += del;
                if (i <= 1 || !(Math.abs(del) < (1.0 + Math.abs(sum)) * tol)) continue;
                return sum / Math.exp(SpecialFunctions.logGamma(alpha)) - SpecialFunctions.digamma(alpha) * SpecialFunctions.regIncompleteGamma(alpha, x);
            }
            return 0.0;
        }
        if (x > alpha + 30.0) {
            double t = Math.exp(-x + (alpha - 1.0) * log_X - SpecialFunctions.logGamma(alpha));
            double r = log_X - SpecialFunctions.digamma(alpha);
            double sum = r * t;
            for (int i = 1; i < (int)(alpha - 1.0); ++i) {
                double ami = alpha - (double)i;
                t = t * ami / x;
                r = log_X - SpecialFunctions.digamma(ami);
                double del = r * t;
                sum += del;
                if (i <= 1 || !(Math.abs(del) < (1.0 + Math.abs(sum)) * tol)) continue;
                return -sum;
            }
            return 0.0;
        }
        double t = Math.exp(-x + alpha * log_X - SpecialFunctions.logGamma(alpha + 1.0));
        double r = log_X - SpecialFunctions.digamma(alpha + 1.0);
        double sum = r * t;
        for (int i = 1; i < 10000; ++i) {
            t = t * x / (alpha + (double)i);
            r = log_X - SpecialFunctions.digamma(alpha + (double)i + 1.0);
            double del = r * t;
            sum += del;
            if (i <= 1 || !(Math.abs(del) < (1.0 + Math.abs(sum)) * tol)) continue;
            return sum;
        }
        return 0.0;
    }

    public static void main(String[] args) {
        double s = 1.0E12;
        for (int i = 0; i <= 20; ++i) {
            double val = s + (double)(1000000 * i) / 20.0;
            System.out.println("rig(" + val + "): " + SpecialFunctions.regIncompleteGamma(s, val));
        }
    }
}

