/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

public class StandardNormalDistribution {
    private static final double[] c = new double[]{0.912158803417554, -0.016266281867664, 4.33556472949E-4, 2.14438570074E-4, 2.625751076E-6, -3.02109105E-6, -1.2406062E-8, 6.2406609E-8, -5.40125E-10, -1.423208E-9, 3.4384E-11, 3.3585E-11, -1.458E-12, -8.1E-13, 5.3E-14, 2.0E-14, -2.0E-15};
    private static final double[] d = new double[]{0.956679709020493, -0.023107004309065, -0.004374236097508, -5.76503422651E-4, -1.0961022307E-5, 2.5108547025E-5, 1.0562336068E-5, 2.75441233E-6, 4.32484498E-7, -2.0530337E-8, -4.3891537E-8, -1.768401E-8, -3.991289E-9, -1.86932E-10, 2.72923E-10, 1.32817E-10, 3.1834E-11, 1.67E-12, -2.036E-12, -9.65E-13, -2.2E-13, -1.0E-14, 1.3E-14, 6.0E-15, 1.0E-15};
    private static final double[] e = new double[]{0.99288537661894, 0.120467516143104, 0.0160781993421, 0.002686704437162, 4.99634730235E-4, 9.8898218599E-5, 2.0391812764E-5, 4.327271618E-6, 9.38081413E-7, 2.06734721E-7, 4.6159699E-8, 1.041668E-8, 2.371501E-9, 5.43928E-10, 1.25549E-10, 2.9138E-11, 6.795E-12, 1.591E-12, 3.74E-13, 8.8E-14, 2.1E-14, 5.0E-15, 1.0E-15};

    public static double getDistribution(double deviate) {
        double[] A = new double[]{0.3193815, -0.3565638, 1.781478, -1.821256, 1.330274};
        double XK = Math.abs(deviate);
        double C = 1.0 / (1.0 + 0.2316419 * XK);
        double D = 0.3989423 * Math.exp(-(Math.pow(deviate, 2.0) / 2.0));
        double P = 0.0;
        for (int i = 0; i < A.length; ++i) {
            P += A[i] * Math.pow(C, i + 1);
        }
        P = D * P;
        if (deviate < 0.0) {
            P = 1.0 - P;
        }
        return P;
    }

    public static void main(String[] args) {
        System.out.println("GetDistribution(2.326) = " + StandardNormalDistribution.getDistribution(2.326));
    }

    public static double getDeviate(double probability) {
        double[] a;
        double w;
        int flag;
        double h1 = -1.5488130423733;
        double h2 = 2.5654901231478;
        double h3 = -0.55945763132983;
        double h4 = 2.2879157162634;
        double r2 = -1.4142135623731;
        double b = 0.0;
        double x = probability * 2.0 - 1.0;
        if (!(x > -1.0) || !(x < 1.0)) {
            StandardNormalDistribution.probabilityErrorMessage();
        }
        double sigma = x < 0.0 ? -1 : 1;
        double z = Math.abs(x);
        if (z > 0.8) {
            b = Math.sqrt(-Math.log(1.0 - z * z));
            flag = 2;
            if (x > 0.9975) {
                w = h3 * b + h4;
                a = d;
            } else {
                w = h1 * b + h2;
                a = c;
            }
        } else {
            w = z * z / 0.32 - 1.0;
            a = e;
            flag = 1;
        }
        double x3 = 1.0;
        double x4 = w;
        double x6 = a[0];
        for (int lb2 = 1; lb2 < a.length; ++lb2) {
            x6 += a[lb2] * x4;
            double x5 = x4 * w * 2.0 - x3;
            x3 = x4;
            x4 = x5;
        }
        double y = flag == 1 ? z * x6 * sigma : b * x6 * sigma;
        y = r2 * y;
        return y;
    }

    protected static void probabilityErrorMessage() {
        throw new IllegalArgumentException("Probability is outside range (0,1)");
    }
}

