/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.StandardNormalDistribution;

public class Statlib {
    public ConfidenceLimit confidenceDeviates(int sampleSize, double pearsonT3Deviate, double confidenceLevel) throws IllegalArgumentException {
        if (confidenceLevel < 1.0E-5 || confidenceLevel > 0.99999) {
            this.errorConfidenceLevel();
        }
        double deviate = StandardNormalDistribution.getDeviate(confidenceLevel);
        double a = 1.0 - Math.pow(deviate, 2.0) / ((double)(2 * sampleSize) - 2.0);
        double b = Math.pow(pearsonT3Deviate, 2.0) - Math.pow(deviate, 2.0) / (double)sampleSize;
        double tmp = Math.sqrt(Math.pow(pearsonT3Deviate, 2.0) - a * b);
        ConfidenceLimit limits = new ConfidenceLimit();
        limits.upperLimit = (pearsonT3Deviate + tmp) / a;
        limits.lowerLimit = (pearsonT3Deviate - tmp) / a;
        return limits;
    }

    protected void errorConfidenceLevel() {
        throw new IllegalArgumentException("Confidence level is not in the range (0.00001, 0.99999)");
    }

    public class ConfidenceLimit {
        public double upperLimit;
        public double lowerLimit;
    }
}

