/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.StandardNormalDistribution;

public class StudentsTDistribution {
    public static double getTvalue(int degreesOfFreedom, double probability) throws IllegalArgumentException {
        double x;
        double hpi = 1.5707963267948966;
        double pt = probability;
        if (pt > 0.5) {
            pt = 1.0 - pt;
        }
        pt = 2.0 * pt;
        double tValue = 0.0;
        if (pt >= 1.0) {
            return tValue;
        }
        if (degreesOfFreedom < 1) {
            StudentsTDistribution.errorDegreesOfFreedom();
        }
        if (pt <= 0.0) {
            StudentsTDistribution.errorProbabilityOutsideOfRange();
        }
        if (degreesOfFreedom < 2) {
            x = 1.0 / Math.tan(pt * hpi);
        } else if (degreesOfFreedom == 2) {
            x = Math.sqrt(2.0 / (pt * (2.0 - pt)) - 2.0);
        } else {
            double df = degreesOfFreedom;
            double a = 1.0 / (df - 0.5);
            double b = 48.0 / (a * a);
            double c = ((20700.0 * a / b - 98.0) * a - 16.0) * a + 96.36;
            double d = ((94.5 / (b + c) - 3.0) / b + 1.0) * Math.sqrt(a * hpi) * df;
            double xx = d * pt;
            double y = Math.pow(xx, 2.0 / df);
            if (y > a + 0.05) {
                x = 0.5 * pt;
                xx = StandardNormalDistribution.getDeviate(x);
                y = xx * xx;
                if (df < 5.0) {
                    c += 0.3 * (df - 4.5) * (xx + 0.6);
                }
                c = (((0.05 * d * xx - 5.0) * xx - 7.0) * xx - 2.0) * xx + b + c;
                y = (((((0.4 * y + 6.3) * y + 36.0) * y + 94.5) / c - y - 3.0) / b + 1.0) * xx;
                d = y = a * y * y;
                if ((y = 0.05 * y * y + y) > 0.002) {
                    y = Math.exp(d) - 1.0;
                }
            } else {
                y = ((1.0 / (((df + 6.0) / (df * y) - 0.089 * d - 0.822) * (df + 2.0) * 3.0) + 0.5 / (df + 4.0)) * y - 1.0) * (df + 1.0) / (df + 2.0) + 1.0 / y;
            }
            x = Math.sqrt(df * y);
        }
        tValue = x;
        if (probability > 0.5) {
            tValue = -tValue;
        }
        return tValue;
    }

    protected static void errorDegreesOfFreedom() {
        throw new IllegalArgumentException("Degrees of Freedom < 1");
    }

    protected static void errorProbabilityOutsideOfRange() {
        throw new IllegalArgumentException("Probability is outside range (0,1)");
    }
}

