/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.ProductMoments;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class TableDist
extends AbstractContDist {
    private double[] _x;
    private double[] _cdf;

    public TableDist() {
        this._x = new double[0];
        this._cdf = new double[0];
    }

    public TableDist(double[] x, double[] cdf) {
        this._x = new double[0];
        this._cdf = new double[0];
        this.setTable(x, cdf);
    }

    public TableDist(double[] x) {
        this._x = new double[0];
        this._cdf = new double[0];
        this.fitSampleData(x);
    }

    public TableDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(double[] sample, AbstractContDist.FittingMethod method) {
        this.setTable(sample, TableDist.getSampleCDF(sample.length));
        return true;
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        this.setTable(new double[0], new double[0]);
        return false;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        this.setTable(new double[0], new double[0]);
        return false;
    }

    private static double[] getSampleCDF(int n) {
        double[] cdf = new double[n];
        for (int i = 0; i < n; ++i) {
            cdf[i] = ((double)i + 0.5) / (double)n;
        }
        return cdf;
    }

    public void setTable(double[] x, double[] cdf) {
        if (x == null || cdf == null || x.length != cdf.length) {
            return;
        }
        double[] xx = (double[])x.clone();
        double[] yy = (double[])cdf.clone();
        Arrays.sort(xx);
        Arrays.sort(yy);
        if (xx.length > 0 && (yy[0] < 0.0 || yy[xx.length - 1] > 1.0)) {
            return;
        }
        this._x = xx;
        this._cdf = yy;
    }

    public int size() {
        if (this._x == null) {
            return 0;
        }
        return this._x.length;
    }

    public double[] getXArray() {
        return this._x;
    }

    public double[] getCDFArray() {
        return this._cdf;
    }

    @Override
    public String getType() {
        return "Table";
    }

    @Override
    public String[] getParamNames() {
        return new String[0];
    }

    @Override
    public double[] getParamVals() {
        return new double[0];
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
    }

    @Override
    public String getSummaryDef(String format) {
        return "User-defined";
    }

    @Override
    public Object clone() {
        TableDist clonedDist = (TableDist)super.clone();
        clonedDist._x = (double[])this._x.clone();
        clonedDist._cdf = (double[])this._cdf.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            ArrayList<Double> xList = new ArrayList<Double>();
            ArrayList<Double> cdfList = new ArrayList<Double>();
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("TableDistEnd")) {
                    double[] x = new double[xList.size()];
                    double[] cdf = new double[xList.size()];
                    for (int i = 0; i < xList.size(); ++i) {
                        x[i] = (Double)xList.get(i);
                        cdf[i] = (Double)cdfList.get(i);
                    }
                    this.setTable(x, cdf);
                    return;
                }
                if (type.equals("Entry")) {
                    String param1 = StringUtil.getFirstToken(param, ",");
                    String param2 = StringUtil.getSecondToken(param, ",");
                    xList.add(Double.parseDouble(param1));
                    cdfList.add(Double.parseDouble(param2));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read TableDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "TableDistBegin");
        for (int i = 0; i < this._x.length; ++i) {
            TextFile.writeLine(writer, "Entry:" + this._x[i] + "," + this._cdf[i]);
        }
        TextFile.writeLine(writer, "TableDistEnd");
    }

    @Override
    public double getCDF(double value) {
        if (this._x.length == 0 || this._x.length == 1) {
            return Double.NaN;
        }
        int idx = Arrays.binarySearch(this._x, value);
        if (idx == -1) {
            return 0.0;
        }
        if (idx == -(this._x.length + 1)) {
            return 1.0;
        }
        if (idx >= 0) {
            return this._cdf[idx];
        }
        idx = -idx - 1;
        double cdfTmp = (this._cdf[idx] * (value - this._x[idx - 1]) - this._cdf[idx - 1] * (value - this._x[idx])) / (this._x[idx] - this._x[idx - 1]);
        return cdfTmp;
    }

    @Override
    public double getPDF(double value) {
        int right;
        int left;
        if (this._x.length == 0 || this._x.length == 1) {
            return 0.0;
        }
        int idx = Arrays.binarySearch(this._x, value);
        if (idx == -1) {
            return 0.0;
        }
        if (idx == -(this._x.length + 1)) {
            return 0.0;
        }
        if (idx >= 0) {
            left = Math.max(idx - 1, 0);
            right = Math.min(idx + 1, this._x.length - 1);
        } else {
            idx = -idx - 1;
            left = idx - 1;
            right = idx;
        }
        if (this._x[right] == this._x[left]) {
            return Double.NaN;
        }
        return (this._cdf[right] - this._cdf[left]) / (this._x[right] - this._x[left]);
    }

    @Override
    public double invCDF(double p) {
        if (this._cdf.length == 0 || this._cdf.length == 1) {
            return Double.NaN;
        }
        int idx = Arrays.binarySearch(this._cdf, p);
        if (idx == -1) {
            return this._x[0];
        }
        if (idx == -(this._cdf.length + 1)) {
            return this._x[this._cdf.length - 1];
        }
        if (idx >= 0) {
            return this._x[idx];
        }
        idx = -idx - 1;
        return (this._x[idx] + this._x[idx - 1]) * 0.5;
    }

    public double mean() {
        return TableDist.mean(this._x, this._cdf);
    }

    public double stdv() {
        return TableDist.stdv(this._x, this._cdf);
    }

    public static double mean(TableDist table) {
        return TableDist.mean(table._x, table._cdf);
    }

    public static double stdv(TableDist table) {
        return TableDist.stdv(table._x, table._cdf);
    }

    public static double mean(double[] x, double[] cdf) {
        double mean = 0.0;
        for (int i = 1; i < x.length; ++i) {
            mean += (x[i] + x[i - 1]) / 2.0 * (cdf[i] - cdf[i - 1]);
        }
        return mean /= cdf[x.length - 1] - cdf[0];
    }

    public static double stdv(double[] x, double[] cdf) {
        double mean = TableDist.mean(x, cdf);
        double variance = 0.0;
        for (int i = 1; i < x.length; ++i) {
            variance += ((x[i] + x[i - 1]) / 2.0 - mean) * ((x[i] + x[i - 1]) / 2.0 - mean) * (cdf[i] - cdf[i - 1]);
        }
        return Math.sqrt(variance /= cdf[x.length - 1] - cdf[0]);
    }

    public static double mean(double[] x) {
        return TableDist.mean(x, TableDist.getSampleCDF(x.length));
    }

    public static double stdv(double[] x) {
        return TableDist.stdv(x, TableDist.getSampleCDF(x.length));
    }
}

