/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.TableDist;
import java.util.Arrays;

public class TableDistAlgebra {
    private static void sumIntervalPlusInterval(TableDist cdf1, int int1, TableDist cdf2, int int2, TableDist cdf) {
        double length2;
        double[] xx1 = cdf1.getXArray();
        double[] yy1 = cdf1.getCDFArray();
        double[] xx2 = cdf2.getXArray();
        double[] yy2 = cdf2.getCDFArray();
        if (xx1.length == 0 || xx2.length == 0) {
            return;
        }
        double length1 = int1 == 0 || int1 == xx1.length ? 0.0 : xx1[int1] - xx1[int1 - 1];
        double d = length2 = int2 == 0 || int2 == xx2.length ? 0.0 : xx2[int2] - xx2[int2 - 1];
        if (length2 < length1) {
            TableDistAlgebra.sumIntervalPlusInterval(cdf2, int2, cdf1, int1, cdf);
            return;
        }
        if (length1 == 0.0) {
            TableDistAlgebra.sumJumpPlusInterval(cdf1, int1, cdf2, int2, cdf);
            return;
        }
        double slope1 = (yy1[int1] - yy1[int1 - 1]) / length1;
        double slope2 = (yy2[int2] - yy2[int2 - 1]) / length2;
        double c = slope1 * slope2;
        double ini1 = xx1[int1 - 1];
        double end1 = xx1[int1];
        double ini2 = xx2[int2 - 1];
        double end2 = xx2[int2];
        double x1 = ini1 + ini2;
        double x2 = end1 + ini2;
        double x3 = ini1 + end2;
        double x4 = end1 + end2;
        double[] xx = cdf.getXArray();
        double[] yy = cdf.getCDFArray();
        for (int i = 0; i < xx.length; ++i) {
            if (xx[i] >= x4) {
                int n = i;
                yy[n] = yy[n] + c * length1 * length2;
                continue;
            }
            if (xx[i] >= x3) {
                int n = i;
                yy[n] = yy[n] + c * (length1 * length2 - 0.5 * (x4 - xx[i]) * (x4 - xx[i]));
                continue;
            }
            if (xx[i] >= x2) {
                int n = i;
                yy[n] = yy[n] + c * 0.5 * length1 * (length2 + 2.0 * xx[i] - x2 - x3);
                continue;
            }
            if (!(xx[i] >= x1)) continue;
            int n = i;
            yy[n] = yy[n] + c * 0.5 * (xx[i] - x1) * (xx[i] - x1);
        }
    }

    private static void sumJumpPlusInterval(TableDist cdf1, int int1, TableDist cdf2, int int2, TableDist cdf) {
        double length2;
        double[] xx1 = cdf1.getXArray();
        double[] yy1 = cdf1.getCDFArray();
        double[] xx2 = cdf2.getXArray();
        double[] yy2 = cdf2.getCDFArray();
        if (xx1.length == 0 || xx2.length == 0) {
            return;
        }
        double d = length2 = int2 == 0 || int2 == xx2.length ? 0.0 : xx2[int2] - xx2[int2 - 1];
        if (length2 == 0.0) {
            TableDistAlgebra.sumJumpPlusJump(cdf1, int1, cdf2, int2, cdf);
            return;
        }
        double jump1 = (int1 == yy1.length ? 1.0 : yy1[int1]) - (int1 == 0 ? 0.0 : yy1[int1 - 1]);
        double slope2 = (yy2[int2] - yy2[int2 - 1]) / length2;
        double c = jump1 * slope2;
        double ctr1 = int1 == xx1.length ? xx1[int1 - 1] : xx1[int1];
        double ini2 = xx2[int2 - 1];
        double end2 = xx2[int2];
        double x1 = ctr1 + ini2;
        double x2 = ctr1 + end2;
        double[] xx = cdf.getXArray();
        double[] yy = cdf.getCDFArray();
        for (int i = 0; i < xx.length; ++i) {
            if (xx[i] >= x2) {
                int n = i;
                yy[n] = yy[n] + c * length2;
                continue;
            }
            if (!(xx[i] >= x1)) continue;
            int n = i;
            yy[n] = yy[n] + c * (xx[i] - x1);
        }
    }

    private static void sumJumpPlusJump(TableDist cdf1, int int1, TableDist cdf2, int int2, TableDist cdf) {
        double[] xx1 = cdf1.getXArray();
        double[] yy1 = cdf1.getCDFArray();
        double[] xx2 = cdf2.getXArray();
        double[] yy2 = cdf2.getCDFArray();
        if (xx1.length == 0 || xx2.length == 0) {
            return;
        }
        double jump1 = (int1 == yy1.length ? 1.0 : yy1[int1]) - (int1 == 0 ? 0.0 : yy1[int1 - 1]);
        double jump2 = (int2 == yy2.length ? 1.0 : yy2[int2]) - (int2 == 0 ? 0.0 : yy2[int2 - 1]);
        double c = jump1 * jump2;
        double ctr1 = int1 == xx1.length ? xx1[int1 - 1] : xx1[int1];
        double ctr2 = int2 == xx2.length ? xx2[int2 - 1] : xx2[int2];
        double x1 = ctr1 + ctr2;
        double[] xx = cdf.getXArray();
        double[] yy = cdf.getCDFArray();
        for (int i = 0; i < xx.length; ++i) {
            if (!(xx[i] > x1) && (xx[i] != x1 || i + 1 >= xx.length || !(xx[i + 1] > x1))) continue;
            int n = i;
            yy[n] = yy[n] + c;
        }
    }

    public static TableDist distSum(TableDist cdf1, TableDist cdf2) {
        int j;
        int i;
        if (cdf1 == null || cdf2 == null) {
            return null;
        }
        double[] xx1 = cdf1.getXArray();
        double[] xx2 = cdf2.getXArray();
        int nPts1 = xx1.length;
        int nPts2 = xx2.length;
        int nPts = nPts1 * nPts2;
        TableDist cdf = new TableDist(new double[nPts], new double[nPts]);
        double[] xx = cdf.getXArray();
        double[] yy = cdf.getCDFArray();
        if (cdf1.size() == 0 || cdf2.size() == 0) {
            return cdf;
        }
        int k = 0;
        for (i = 0; i < nPts1; ++i) {
            for (j = 0; j < nPts2; ++j) {
                xx[k] = xx1[i] + xx2[j];
                ++k;
            }
        }
        Arrays.sort(xx);
        Arrays.fill(yy, 0.0);
        for (i = 0; i <= nPts1; ++i) {
            for (j = 0; j <= nPts2; ++j) {
                TableDistAlgebra.sumIntervalPlusInterval(cdf1, i, cdf2, j, cdf);
            }
        }
        return cdf;
    }

    public static TableDist distSubtract(TableDist cdf1, TableDist cdf2) {
        if (cdf1 == null || cdf2 == null) {
            return null;
        }
        double[] xx2 = cdf2.getXArray();
        double[] yy2 = cdf2.getCDFArray();
        TableDist negcdf2 = (TableDist)cdf2.clone();
        double[] negxx2 = negcdf2.getXArray();
        double[] negyy2 = negcdf2.getCDFArray();
        for (int i = 0; i < negxx2.length; ++i) {
            negxx2[i] = -xx2[xx2.length - (i + 1)];
            negyy2[i] = 1.0 - yy2[yy2.length - (i + 1)];
        }
        TableDist cdf = TableDistAlgebra.distSum(cdf1, negcdf2);
        return cdf;
    }

    private static void prodIntervalTimesInterval(TableDist cdf1, int int1, TableDist cdf2, int int2, TableDist cdf) {
        double lengthlog2;
        double[] xx1 = cdf1.getXArray();
        double[] yy1 = cdf1.getCDFArray();
        double[] xx2 = cdf2.getXArray();
        double[] yy2 = cdf2.getCDFArray();
        if (xx1.length == 0 || xx2.length == 0) {
            return;
        }
        double lengthlog1 = int1 == 0 || int1 == xx1.length || xx1[int1] == xx1[int1 - 1] ? 1.0 : xx1[int1] / xx1[int1 - 1];
        double d = lengthlog2 = int2 == 0 || int2 == xx2.length || xx2[int2] == xx2[int2 - 1] ? 1.0 : xx2[int2] / xx2[int2 - 1];
        if (lengthlog2 < lengthlog1) {
            TableDistAlgebra.prodIntervalTimesInterval(cdf2, int2, cdf1, int1, cdf);
            return;
        }
        if (lengthlog1 == 1.0) {
            TableDistAlgebra.prodJumpTimesInterval(cdf1, int1, cdf2, int2, cdf);
            return;
        }
        double L1 = xx1[int1] - xx1[int1 - 1];
        double L2 = xx2[int2] - xx2[int2 - 1];
        double slope1 = (yy1[int1] - yy1[int1 - 1]) / L1;
        double slope2 = (yy2[int2] - yy2[int2 - 1]) / L2;
        double c = slope1 * slope2;
        double ini1 = xx1[int1 - 1];
        double end1 = xx1[int1];
        double ini2 = xx2[int2 - 1];
        double end2 = xx2[int2];
        double x1 = ini1 * ini2;
        double x2 = end1 * ini2;
        double x3 = ini1 * end2;
        double x4 = end1 * end2;
        double LL = x4 - x3 - x2 + x1;
        double cLog = Math.log(end1 / ini1);
        double[] xx = cdf.getXArray();
        double[] yy = cdf.getCDFArray();
        for (int i = 0; i < xx.length; ++i) {
            if (xx[i] >= x4) {
                int n = i;
                yy[n] = yy[n] + c * LL;
                continue;
            }
            if (xx[i] >= x3) {
                int n = i;
                yy[n] = yy[n] + c * (LL - (x4 - xx[i]) - (xx[i] == 0.0 ? 0.0 : xx[i] * Math.log(xx[i] / x4)));
                continue;
            }
            if (xx[i] >= x2) {
                int n = i;
                yy[n] = yy[n] + c * (0.5 * (LL + x1 - x2 + x3 - x4) + xx[i] * cLog);
                continue;
            }
            if (!(xx[i] >= x1)) continue;
            int n = i;
            yy[n] = yy[n] + c * (x1 - xx[i] + xx[i] * Math.log(xx[i] / x1));
        }
    }

    private static void prodJumpTimesInterval(TableDist cdf1, int int1, TableDist cdf2, int int2, TableDist cdf) {
        double lengthlog2;
        double[] xx1 = cdf1.getXArray();
        double[] yy1 = cdf1.getCDFArray();
        double[] xx2 = cdf2.getXArray();
        double[] yy2 = cdf2.getCDFArray();
        if (xx1.length == 0 || xx2.length == 0) {
            return;
        }
        double d = lengthlog2 = int2 == 0 || int2 == xx2.length || xx2[int2] == xx2[int2 - 1] ? 1.0 : xx2[int2] / xx2[int2 - 1];
        if (lengthlog2 == 1.0) {
            TableDistAlgebra.prodJumpTimesJump(cdf1, int1, cdf2, int2, cdf);
            return;
        }
        double jump1 = (int1 == yy1.length ? 1.0 : yy1[int1]) - (int1 == 0 ? 0.0 : yy1[int1 - 1]);
        double L2 = xx2[int2] - xx2[int2 - 1];
        double slope2 = (yy2[int2] - yy2[int2 - 1]) / L2;
        double c = jump1 * slope2;
        double ctr1 = int1 == xx1.length ? xx1[int1 - 1] : xx1[int1];
        double ini2 = xx2[int2 - 1];
        double end2 = xx2[int2];
        double x1 = ctr1 * ini2;
        double x2 = ctr1 * end2;
        double[] xx = cdf.getXArray();
        double[] yy = cdf.getCDFArray();
        for (int i = 0; i < xx.length; ++i) {
            if (xx[i] >= x2) {
                int n = i;
                yy[n] = yy[n] + c * L2;
                continue;
            }
            if (!(xx[i] >= x1)) continue;
            int n = i;
            yy[n] = yy[n] + c / ctr1 * (xx[i] - x1);
        }
    }

    private static void prodJumpTimesJump(TableDist cdf1, int int1, TableDist cdf2, int int2, TableDist cdf) {
        double[] xx1 = cdf1.getXArray();
        double[] yy1 = cdf1.getCDFArray();
        double[] xx2 = cdf2.getXArray();
        double[] yy2 = cdf2.getCDFArray();
        if (xx1.length == 0 || xx2.length == 0) {
            return;
        }
        double jump1 = (int1 == yy1.length ? 1.0 : yy1[int1]) - (int1 == 0 ? 0.0 : yy1[int1 - 1]);
        double jump2 = (int2 == yy2.length ? 1.0 : yy2[int2]) - (int2 == 0 ? 0.0 : yy2[int2 - 1]);
        double c = jump1 * jump2;
        double ctr1 = int1 == xx1.length ? xx1[int1 - 1] : xx1[int1];
        double ctr2 = int2 == xx2.length ? xx2[int2 - 1] : xx2[int2];
        double x1 = ctr1 * ctr2;
        double[] xx = cdf.getXArray();
        double[] yy = cdf.getCDFArray();
        for (int i = 0; i < xx.length; ++i) {
            if (!(xx[i] > x1) && (xx[i] != x1 || i + 1 >= xx.length || !(xx[i + 1] > x1))) continue;
            int n = i;
            yy[n] = yy[n] + c;
        }
    }

    private static TableDist[] extractNegPos(TableDist cdf, double cdf0) {
        int i;
        if (cdf == null) {
            return null;
        }
        double[] xx = cdf.getXArray();
        double[] yy = cdf.getCDFArray();
        int nPts = xx.length;
        int idx = Arrays.binarySearch(xx, 0.0);
        if (idx < 0) {
            idx = -idx - 1;
        }
        double[] xxNeg = null;
        double[] yyNeg = null;
        double[] xxPos = null;
        double[] yyPos = null;
        if (idx == 0) {
            xxNeg = new double[]{};
            yyNeg = new double[]{};
            xxPos = new double[nPts + 1];
            yyPos = new double[nPts + 1];
            for (i = 0; i < nPts; ++i) {
                xxPos[i] = xx[i];
                yyPos[i] = yy[i];
            }
            xxPos[nPts] = xx[nPts - 1];
            yyPos[nPts] = 1.0;
        } else if (idx == nPts) {
            xxNeg = new double[nPts + 1];
            yyNeg = new double[nPts + 1];
            for (i = 0; i < nPts; ++i) {
                xxNeg[i] = -xx[nPts - (i + 1)];
                yyNeg[i] = 1.0 - yy[nPts - (i + 1)];
            }
            xxNeg[nPts] = -xx[0];
            yyNeg[nPts] = 1.0;
            xxPos = new double[]{};
            yyPos = new double[]{};
        } else {
            xxNeg = new double[idx + 2];
            yyNeg = new double[idx + 2];
            xxNeg[0] = 0.0;
            yyNeg[0] = 0.0;
            for (i = 1; i < idx + 1; ++i) {
                xxNeg[i] = -xx[idx - i];
                yyNeg[i] = cdf0 - yy[idx - i];
            }
            xxNeg[idx + 1] = -xx[0];
            yyNeg[idx + 1] = cdf0 - 0.0;
            xxPos = new double[nPts - idx + 2];
            yyPos = new double[nPts - idx + 2];
            xxNeg[0] = 0.0;
            yyNeg[0] = 0.0;
            for (i = 1; i < nPts - idx + 1; ++i) {
                xxPos[i] = xx[idx + i - 1];
                yyPos[i] = yy[idx + i - 1] - cdf0;
            }
            xxPos[nPts - idx + 1] = xx[nPts - 1];
            yyPos[nPts - idx + 1] = 1.0 - cdf0;
        }
        TableDist cdfNeg = new TableDist(xxNeg, yyNeg);
        TableDist cdfPos = new TableDist(xxPos, yyPos);
        TableDist[] extract = new TableDist[]{cdfNeg, cdfPos};
        return extract;
    }

    private static TableDist distProdPlusProd(TableDist cdf1, TableDist cdf2, TableDist cdf3, TableDist cdf4) {
        int j;
        int i;
        if (cdf1 == null || cdf2 == null || cdf3 == null || cdf4 == null) {
            return null;
        }
        double[] xx1 = cdf1.getXArray();
        int nPts1 = xx1.length;
        double[] xx2 = cdf2.getXArray();
        int nPts2 = xx2.length;
        double[] xx3 = cdf3.getXArray();
        int nPts3 = xx3.length;
        double[] xx4 = cdf4.getXArray();
        int nPts4 = xx4.length;
        int nPts = nPts1 * nPts2 + nPts3 * nPts4;
        TableDist cdf = new TableDist(new double[nPts], new double[nPts]);
        double[] xx = cdf.getXArray();
        double[] yy = cdf.getCDFArray();
        int k = 0;
        for (i = 0; i < nPts1; ++i) {
            for (j = 0; j < nPts2; ++j) {
                xx[k] = xx1[i] * xx2[j];
                ++k;
            }
        }
        for (i = 0; i < nPts3; ++i) {
            for (j = 0; j < nPts4; ++j) {
                xx[k] = xx3[i] * xx4[j];
                ++k;
            }
        }
        Arrays.sort(xx);
        Arrays.fill(yy, 0.0);
        for (i = 0; i < nPts1; ++i) {
            for (j = 0; j < nPts2; ++j) {
                TableDistAlgebra.prodIntervalTimesInterval(cdf1, i, cdf2, j, cdf);
            }
        }
        for (i = 0; i < nPts3; ++i) {
            for (j = 0; j < nPts4; ++j) {
                TableDistAlgebra.prodIntervalTimesInterval(cdf3, i, cdf4, j, cdf);
            }
        }
        return cdf;
    }

    private static TableDist assembleParts(TableDist cdfNeg, TableDist cdfPos, double cdf0) {
        int i;
        if (cdfNeg == null || cdfPos == null) {
            return null;
        }
        double[] xxNeg = cdfNeg.getXArray();
        double[] yyNeg = cdfNeg.getCDFArray();
        double[] xxPos = cdfPos.getXArray();
        double[] yyPos = cdfPos.getCDFArray();
        int nPtsNeg = xxNeg.length;
        int nPtsPos = xxPos.length;
        int nPts = nPtsNeg + nPtsPos;
        TableDist cdf = new TableDist(new double[nPts], new double[nPts]);
        double[] xx = cdf.getXArray();
        double[] yy = cdf.getCDFArray();
        for (i = 0; i < nPtsNeg; ++i) {
            xx[i] = -xxNeg[nPtsNeg - (i + 1)];
            yy[i] = cdf0 - yyNeg[nPtsNeg - (i + 1)];
        }
        for (i = 0; i < nPtsPos; ++i) {
            xx[nPtsNeg + i] = xxPos[i];
            yy[nPtsNeg + i] = cdf0 + yyPos[i];
        }
        return cdf;
    }

    private static TableDist invertPart(TableDist cdf1, double cdf0) {
        double[] xx1 = cdf1.getXArray();
        double[] yy1 = cdf1.getCDFArray();
        int nPts = xx1.length;
        for (int i = nPts - 2; i >= 0; --i) {
            double ratio = xx1[i] / xx1[i + 1];
            if (ratio == 0.0) {
                for (int j = 0; j <= i; ++j) {
                    xx1[j] = 0.4 * xx1[i + 1];
                }
                break;
            }
            if (!(ratio < 0.4)) continue;
            double factor = 0.4 / ratio;
            int j = 0;
            while (j <= i) {
                int n = j++;
                xx1[n] = xx1[n] * factor;
            }
        }
        double[] xx = new double[nPts];
        double[] yy = new double[nPts];
        if (nPts > 0 && xx1[0] > 0.0) {
            for (int i = 0; i < nPts; ++i) {
                xx[i] = 1.0 / xx1[nPts - (i + 1)];
                yy[i] = cdf0 - yy1[nPts - (i + 1)];
            }
        }
        TableDist cdf = new TableDist(xx, yy);
        return cdf;
    }

    public static TableDist distProd(TableDist cdf1, TableDist cdf2) {
        if (cdf1 == null || cdf2 == null) {
            return null;
        }
        double cdf10 = cdf1.getCDF(0.0);
        TableDist[] cdf1NegPos = TableDistAlgebra.extractNegPos(cdf1, cdf10);
        TableDist cdf1Neg = cdf1NegPos[0];
        TableDist cdf1Pos = cdf1NegPos[1];
        double cdf20 = cdf2.getCDF(0.0);
        TableDist[] cdf2NegPos = TableDistAlgebra.extractNegPos(cdf2, cdf20);
        TableDist cdf2Neg = cdf2NegPos[0];
        TableDist cdf2Pos = cdf2NegPos[1];
        TableDist cdfNeg = TableDistAlgebra.distProdPlusProd(cdf1Neg, cdf2Pos, cdf1Pos, cdf2Neg);
        TableDist cdfPos = TableDistAlgebra.distProdPlusProd(cdf1Neg, cdf2Neg, cdf1Pos, cdf2Pos);
        double cdf0 = cdf10 * (1.0 - cdf20) + (1.0 - cdf10) * cdf20;
        TableDist cdf = TableDistAlgebra.assembleParts(cdfNeg, cdfPos, cdf0);
        return cdf;
    }

    public static TableDist distQuot(TableDist cdf1, TableDist cdf2) {
        if (cdf1 == null || cdf2 == null) {
            return null;
        }
        double cdf10 = cdf1.getCDF(0.0);
        TableDist[] cdf1NegPos = TableDistAlgebra.extractNegPos(cdf1, cdf10);
        TableDist cdf1Neg = cdf1NegPos[0];
        TableDist cdf1Pos = cdf1NegPos[1];
        double cdf20 = cdf2.getCDF(0.0);
        TableDist[] cdf2NegPos = TableDistAlgebra.extractNegPos(cdf2, cdf20);
        TableDist cdf2Neg = cdf2NegPos[0];
        TableDist cdf2Pos = cdf2NegPos[1];
        cdf2Neg = TableDistAlgebra.invertPart(cdf2Neg, cdf20);
        cdf2Pos = TableDistAlgebra.invertPart(cdf2Pos, 1.0 - cdf20);
        TableDist cdfNeg = TableDistAlgebra.distProdPlusProd(cdf1Neg, cdf2Pos, cdf1Pos, cdf2Neg);
        TableDist cdfPos = TableDistAlgebra.distProdPlusProd(cdf1Neg, cdf2Neg, cdf1Pos, cdf2Pos);
        double cdf0 = cdf10 * (1.0 - cdf20) + (1.0 - cdf10) * cdf20;
        TableDist cdf = TableDistAlgebra.assembleParts(cdfNeg, cdfPos, cdf0);
        return cdf;
    }

    public static TableDist distSumShort(TableDist cdf1, TableDist cdf2) {
        if (cdf1 == null || cdf2 == null) {
            return null;
        }
        int nPts1 = cdf1.size();
        int nPts2 = cdf2.size();
        return TableDistAlgebra.distSumShort(cdf1, cdf2, nPts1 + nPts2);
    }

    public static TableDist distSumShort(TableDist cdf1, TableDist cdf2, int len) {
        TableDist cdf = TableDistAlgebra.distSum(cdf1, cdf2);
        return TableDistAlgebra.makeShort(cdf, len);
    }

    public static TableDist distSubtractShort(TableDist cdf1, TableDist cdf2) {
        if (cdf1 == null || cdf2 == null) {
            return null;
        }
        int nPts1 = cdf1.size();
        int nPts2 = cdf2.size();
        return TableDistAlgebra.distSubtractShort(cdf1, cdf2, nPts1 + nPts2);
    }

    public static TableDist distSubtractShort(TableDist cdf1, TableDist cdf2, int len) {
        TableDist cdf = TableDistAlgebra.distSubtract(cdf1, cdf2);
        return TableDistAlgebra.makeShort(cdf, len);
    }

    public static TableDist distProdShort(TableDist cdf1, TableDist cdf2) {
        if (cdf1 == null || cdf2 == null) {
            return null;
        }
        int nPts1 = cdf1.size();
        int nPts2 = cdf2.size();
        return TableDistAlgebra.distProdShort(cdf1, cdf2, nPts1 + nPts2);
    }

    public static TableDist distProdShort(TableDist cdf1, TableDist cdf2, int len) {
        TableDist cdf = TableDistAlgebra.distProd(cdf1, cdf2);
        return TableDistAlgebra.makeShort(cdf, len);
    }

    public static TableDist distQuotShort(TableDist cdf1, TableDist cdf2) {
        if (cdf1 == null || cdf2 == null) {
            return null;
        }
        int nPts1 = cdf1.size();
        int nPts2 = cdf2.size();
        return TableDistAlgebra.distQuotShort(cdf1, cdf2, nPts1 + nPts2);
    }

    public static TableDist distQuotShort(TableDist cdf1, TableDist cdf2, int len) {
        TableDist cdf = TableDistAlgebra.distQuot(cdf1, cdf2);
        return TableDistAlgebra.makeShort(cdf, len);
    }

    public static TableDist makeShort(TableDist cdf, int len) {
        if (cdf == null) {
            return null;
        }
        TableDist cdfShort = new TableDist(new double[len], new double[len]);
        double[] xxShort = cdfShort.getXArray();
        double[] yyShort = cdfShort.getCDFArray();
        for (int j = 0; j < len; ++j) {
            yyShort[j] = (1.0 + (double)(2 * j)) / (2.0 * (double)len);
            xxShort[j] = cdf.invCDF(yyShort[j]);
        }
        return cdfShort;
    }

    public static void main(String[] args) {
        TableDist p1 = new TableDist(new double[5], new double[5]);
        double[] xx1 = p1.getXArray();
        double[] yy1 = p1.getCDFArray();
        xx1[0] = -2.0;
        yy1[0] = 0.0;
        xx1[1] = -1.0;
        yy1[1] = 0.25;
        xx1[2] = 0.0;
        yy1[2] = 0.5;
        xx1[3] = 1.0;
        yy1[3] = 0.75;
        xx1[4] = 2.0;
        yy1[4] = 1.0;
        TableDist p2 = new TableDist(new double[4], new double[4]);
        double[] xx2 = p2.getXArray();
        double[] yy2 = p2.getCDFArray();
        xx2[0] = 0.0;
        yy2[0] = 0.0;
        xx2[1] = 0.4;
        yy2[1] = 0.25;
        xx2[2] = 2.0;
        yy2[2] = 0.75;
        xx2[3] = 3.0;
        yy2[3] = 1.0;
        TableDist p3 = TableDistAlgebra.distQuot(p1, p2);
        System.out.println(p3.size());
        for (int i = 0; i < p3.size(); ++i) {
            System.out.println(p3.getXArray()[i] + " " + p3.getCDFArray()[i]);
        }
    }
}

