/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.ClipData;
import hec.statistics.ClipDist;
import hec.statistics.TriangDist;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;

public class TriangClipDist
extends TriangDist
implements ClipDist {
    private ClipData _clip = new ClipData(){

        @Override
        public void setMinVal(double minVal) {
            super.setMinVal(minVal);
            super.setMinProb(TriangClipDist.super.getCDF(minVal));
        }

        @Override
        public void setMinProb(double minProb) {
            super.setMinProb(minProb);
            TriangDist td = new TriangDist(TriangClipDist.this.getLeft(), TriangClipDist.this.getPeak(), TriangClipDist.this.getRight());
            super.setMinVal(td.invCDF(minProb));
        }

        @Override
        public void setMaxVal(double maxVal) {
            super.setMaxVal(maxVal);
            super.setMaxProb(TriangClipDist.super.getCDF(maxVal));
        }

        @Override
        public void setMaxProb(double maxProb) {
            super.setMaxProb(maxProb);
            TriangDist td = new TriangDist(TriangClipDist.this.getLeft(), TriangClipDist.this.getPeak(), TriangClipDist.this.getRight());
            super.setMaxVal(td.invCDF(maxProb));
        }
    };
    static final int COMPUTE_FLAG = 0;

    public TriangClipDist() {
    }

    public TriangClipDist(double left, double peak, double right) {
        super(left, peak, right);
    }

    @Override
    public ClipData getClipData() {
        return this._clip;
    }

    @Override
    public String[] getClipParamNames() {
        if (this.getClipData() == null) {
            return new String[0];
        }
        return this.getClipData().getClipParamNames();
    }

    @Override
    public double[] getClipParamVals() {
        if (this.getClipData() == null) {
            return new double[0];
        }
        return this.getClipData().getClipParamVals();
    }

    @Override
    public String getSummaryClip(String format) {
        if (this.getClipData() == null) {
            return "";
        }
        return this.getClipData().getSummary(format);
    }

    @Override
    public Object clone() {
        TriangClipDist clonedDist = (TriangClipDist)super.clone();
        clonedDist._clip = (ClipData)this._clip.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("TriangClipDistEnd")) {
                    return;
                }
                if (type.equals("Left")) {
                    this.setLeft(Double.parseDouble(param));
                } else if (type.equals("Peak")) {
                    this.setPeak(Double.parseDouble(param));
                } else if (type.equals("Right")) {
                    this.setRight(Double.parseDouble(param));
                } else if (type.equals("ClipDataBegin")) {
                    this._clip.read(reader);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read TriangClipDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "TriangClipDistBegin");
        TextFile.writeLine(writer, "Left:" + this.getLeft());
        TextFile.writeLine(writer, "Peak:" + this.getPeak());
        TextFile.writeLine(writer, "Right:" + this.getRight());
        this._clip.write(writer);
        TextFile.writeLine(writer, "TriangClipDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal() || this.getClipData().hasMaxClip() && value > this.getClipData().getMaxVal()) {
            return 0.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return super.getPDF(value) / rescale;
    }

    @Override
    public double getCDF(double value) {
        if (this.getClipData().hasMinClip() && value < this.getClipData().getMinVal()) {
            return 0.0;
        }
        if (this.getClipData().hasMaxClip() && value >= this.getClipData().getMaxVal()) {
            return 1.0;
        }
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return (super.getCDF(value) - minProb) / rescale;
    }

    @Override
    public double invCDF(double p) {
        TriangDist td = new TriangDist(this.getLeft(), this.getPeak(), this.getRight());
        double minProb = this.getClipData().hasMinClip() ? this.getClipData().getMinProb() : 0.0;
        double maxProb = this.getClipData().hasMaxClip() ? this.getClipData().getMaxProb() : 1.0;
        double rescale = maxProb - minProb;
        return td.invCDF(minProb + p * rescale);
    }
}

