/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.EquationSolverBiSearch;
import hec.statistics.LinearMoments;
import hec.statistics.MaximumLikelihood;
import hec.statistics.ProductMoments;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;

public class TriangDist
extends AbstractContDist {
    private double _left;
    private double _peak;
    private double _right;

    public TriangDist() {
        this(-1.0, 0.0, 1.0);
    }

    public TriangDist(double left, double peak, double right) {
        if (left > peak) {
            left = peak;
        }
        if (peak > right) {
            right = peak;
        }
        this._left = left;
        this._peak = peak;
        this._right = right;
    }

    public TriangDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public TriangDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        double b3;
        if (pm.getStDv() <= 0.0) {
            this.setLeft(Double.NaN);
            this.setPeak(Double.NaN);
            this.setRight(Double.NaN);
            return false;
        }
        double sqrt2 = Math.sqrt(2.0);
        double sqrt3 = Math.sqrt(3.0);
        double a3 = -5.0 * pm.getSkew();
        if (8.0 - a3 * a3 < 0.0) {
            a3 = Math.signum(a3) * 2.0 * sqrt2;
            b3 = 0.0;
        } else {
            b3 = Math.sqrt(8.0 - a3 * a3);
        }
        double angle = Math.atan2(b3, a3);
        double aa = Math.cos(angle / 3.0);
        double bb = Math.sin(angle / 3.0);
        this.setLeft(pm.getMean() - 2.0 * sqrt2 * pm.getStDv() * aa);
        this.setPeak(pm.getMean() + sqrt2 * pm.getStDv() * (aa - sqrt3 * bb));
        this.setRight(pm.getMean() + sqrt2 * pm.getStDv() * (aa + sqrt3 * bb));
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        if (lm.getL2() <= 0.0) {
            this.setLeft(Double.NaN);
            this.setPeak(Double.NaN);
            this.setRight(Double.NaN);
            return false;
        }
        double sqrt3 = Math.sqrt(3.0);
        double qTerm = Math.min(Math.max(-7.0 * lm.getT3(), -1.0), 1.0);
        double q2Term = qTerm * qTerm;
        double q4Term = q2Term * q2Term;
        double a3 = qTerm * (q2Term + 999.0);
        double b3 = Math.sqrt(970299.0 - 968598.0 * q2Term - 1701.0 * q4Term);
        double angle = Math.atan2(b3, a3);
        double aa = Math.cos(angle / 3.0);
        double bb = Math.sin(angle / 3.0);
        double p = (9.0 - qTerm + Math.sqrt(q2Term + 99.0) * (aa - sqrt3 * bb)) / 18.0;
        double s = 15.0 * lm.getL2() / (p * p - p + 2.0);
        this.setLeft(lm.getL1() - s * (1.0 + p) / 3.0);
        this.setPeak(lm.getL1() - s * (1.0 - 2.0 * p) / 3.0);
        this.setRight(lm.getL1() + s * (2.0 - p) / 3.0);
        return true;
    }

    @Override
    public boolean fitSampleData(MaximumLikelihood ml) {
        double l;
        final double[] data = Arrays.copyOf(ml.getSample(), ml.getSample().length);
        Arrays.sort(data);
        double eps = 1.0 / (double)data.length;
        this.setLeft(data[0] - eps);
        this.setPeak((data[0] + data[data.length - 1]) / 2.0);
        this.setRight(data[data.length - 1] + eps);
        double oldL = l = this.getLogLikelihood(data);
        this.fitPeak(ml.getSample(), eps);
        while (true) {
            EquationSolverBiSearch biSearch;
            double[] jac;
            if ((jac = this.getLogLikelihoodJacobian(data))[0] < 0.0) {
                double leftMax = this.getLeft();
                double leftMin = 0.0;
                while (jac[0] < 0.0) {
                    leftMin = leftMax - (this.getPeak() - this.getLeft());
                    this.setLeft(leftMin);
                    jac = this.getLogLikelihoodJacobian(data);
                }
                biSearch = new EquationSolverBiSearch(){

                    @Override
                    public double f(double x) {
                        TriangDist.this.setLeft(x);
                        double[] jac = TriangDist.this.getLogLikelihoodJacobian(data);
                        return jac[0];
                    }
                };
                biSearch.biSearch(0.0, leftMin, leftMax, 1.0E-8);
            }
            if ((jac = this.getLogLikelihoodJacobian(data))[2] > 0.0) {
                double rightMin = this.getRight();
                double rightMax = 0.0;
                while (jac[2] > 0.0) {
                    rightMax = rightMin + (this.getRight() - this.getPeak());
                    this.setRight(rightMax);
                    jac = this.getLogLikelihoodJacobian(data);
                }
                biSearch = new EquationSolverBiSearch(){

                    @Override
                    public double f(double x) {
                        TriangDist.this.setRight(x);
                        double[] jac = TriangDist.this.getLogLikelihoodJacobian(data);
                        return jac[2];
                    }
                };
                biSearch.biSearch(0.0, rightMin, rightMax, 1.0E-8);
            }
            this.fitPeak(ml.getSample(), eps);
            jac = this.getLogLikelihoodJacobian(data);
            double sum = 0.0;
            for (int i = 0; i < jac.length; ++i) {
                sum += jac[i];
            }
            if (Math.abs(sum) < eps) break;
            double[] hess = this.getLogLikelihoodHessian(data);
            if (this.getLeft() + jac[0] / hess[0] < data[0] - 1.0E-5) {
                this.setLeft(this.getLeft() + jac[0] / hess[0]);
            } else {
                this.setLeft(data[0] - 1.0E-5);
            }
            if (this.getRight() + jac[2] / hess[8] > data[data.length - 1] + 1.0E-5) {
                this.setRight(this.getRight() + jac[2] / hess[8]);
            } else {
                this.setRight(data[data.length - 1] + 1.0E-5);
            }
            if (this.getRight() <= this.getPeak()) {
                this.setPeak(this.getRight() - 0.001);
            } else if (this.getPeak() <= this.getLeft()) {
                this.setPeak(this.getLeft() + 0.001);
            }
            double lNew = this.getLogLikelihood(data);
            if (Math.abs(l - lNew) < 1.0 / (double)ml.getSample().length || Math.abs(oldL - lNew) < 1.0 / (double)ml.getSample().length) break;
            oldL = l;
            l = lNew;
        }
        return true;
    }

    private void fitPeak(double[] sample, double eps) {
        double lastIterPeak = Double.MAX_VALUE;
        int n = sample.length;
        for (int iter = 0; iter < 10000; ++iter) {
            double nl = 0.0;
            double nr = 0.0;
            for (int i = 0; i < n; ++i) {
                if (sample[i] < this.getPeak()) {
                    nl += 1.0;
                    continue;
                }
                nr += 1.0;
            }
            if (nr == 0.0 || nl == 0.0) {
                if (nr == 0.0) {
                    this.setPeak(this.getRight() - eps);
                    break;
                }
                this.setPeak(this.getLeft() + eps);
                break;
            }
            double newPeak = 2.0 * this.getPeak() - (nl * this.getRight() + nr * this.getLeft()) / (nr + nl);
            if (Math.abs(newPeak - this.getPeak()) < eps || Math.abs(lastIterPeak - newPeak) < eps) {
                this.setPeak(newPeak);
                break;
            }
            lastIterPeak = this.getPeak();
            this.setPeak(newPeak);
        }
    }

    public void setLeft(double left) {
        this._left = left;
    }

    public double getLeft() {
        return this._left;
    }

    public void setPeak(double peak) {
        this._peak = peak;
    }

    public double getPeak() {
        return this._peak;
    }

    public void setRight(double right) {
        this._right = right;
    }

    public double getRight() {
        return this._right;
    }

    @Override
    public String getType() {
        return "Triangular";
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Left", "Peak", "Right"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getLeft(), this.getPeak(), this.getRight()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setLeft(vals[0]);
        this.setPeak(vals[1]);
        this.setRight(vals[2]);
    }

    @Override
    public Object clone() {
        TriangDist clonedDist = (TriangDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("TriangDistEnd")) {
                    return;
                }
                if (type.equals("Left")) {
                    this.setLeft(Double.parseDouble(param));
                } else if (type.equals("Peak")) {
                    this.setPeak(Double.parseDouble(param));
                } else if (type.equals("Right")) {
                    this.setRight(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read TriangDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "TriangDistBegin");
        TextFile.writeLine(writer, "Left:" + this.getLeft());
        TextFile.writeLine(writer, "Peak:" + this.getPeak());
        TextFile.writeLine(writer, "Right:" + this.getRight());
        TextFile.writeLine(writer, "TriangDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (value <= this._left) {
            return 0.0;
        }
        if (value >= this._right) {
            return 0.0;
        }
        if (value < this._peak) {
            return 2.0 * (value - this._left) / (this._peak - this._left) / (this._right - this._left);
        }
        return 2.0 * (this._right - value) / (this._right - this._peak) / (this._right - this._left);
    }

    @Override
    public double getCDF(double value) {
        if (value <= this._left) {
            return 0.0;
        }
        if (value >= this._right) {
            return 1.0;
        }
        if (value < this._peak) {
            return (value - this._left) * (value - this._left) / (this._peak - this._left) / (this._right - this._left);
        }
        return 1.0 - (this._right - value) * (this._right - value) / (this._right - this._peak) / (this._right - this._left);
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return this._left;
        }
        if (p >= 1.0) {
            return this._right;
        }
        if (p < (this._peak - this._left) / (this._right - this._left)) {
            return this._left + Math.sqrt(p * (this._right - this._left) * (this._peak - this._left));
        }
        return this._right - Math.sqrt((1.0 - p) * (this._right - this._left) * (this._right - this._peak));
    }

    @Override
    public double[][] getParamBounds(double[] data) {
        Arrays.sort(data);
        double[][] retval = new double[2][3];
        retval[0][0] = data[0] - data[0] * 0.25;
        retval[1][0] = data[0];
        retval[0][2] = data[data.length - 1];
        retval[1][2] = data[data.length - 1] + data[data.length - 1] * 0.25;
        retval[0][1] = data[0];
        retval[1][1] = data[data.length - 1];
        return retval;
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        double nl = 0.0;
        double nr = 0.0;
        double sumLnXL = 0.0;
        double sumLnRX = 0.0;
        double retval = 0.0;
        int n = sample.length;
        for (int i = 0; i < n; ++i) {
            if (sample[i] < this.getPeak()) {
                nl += 1.0;
                sumLnXL += Math.log(sample[i] - this.getLeft());
                continue;
            }
            nr += 1.0;
            sumLnXL += Math.log(this.getRight() - sample[i]);
        }
        return (double)sample.length * Math.log(2.0) + sumLnXL - nl * Math.log(this.getPeak() - this.getLeft()) + sumLnRX - nr * Math.log(this.getRight() - this.getPeak()) - (double)sample.length * Math.log(this.getRight() - this.getLeft());
    }

    @Override
    public double[] getLogLikelihoodJacobian(double[] sample) {
        double nl = 0.0;
        double nr = 0.0;
        double sumXLInv = 0.0;
        double sumRXInv = 0.0;
        int n = sample.length;
        for (int i = 0; i < n; ++i) {
            if (sample[i] < this.getPeak()) {
                nl += 1.0;
                sumXLInv += 1.0 / (sample[i] - this.getLeft());
                continue;
            }
            nr += 1.0;
            sumRXInv += 1.0 / (this.getRight() - sample[i]);
        }
        return new double[]{nl / (this.getPeak() - this.getLeft()) - sumXLInv + (double)n / (this.getRight() - this.getLeft()), nr / (this.getRight() - this.getPeak()) - nl / (this.getPeak() - this.getLeft()), sumRXInv - nr / (this.getRight() - this.getPeak()) - (double)n / (this.getRight() - this.getLeft())};
    }

    @Override
    public double[] getLogLikelihoodHessian(double[] sample) {
        double nl = 0.0;
        double nr = 0.0;
        double sumXLInv2 = 0.0;
        double sumRXInv2 = 0.0;
        int n = sample.length;
        for (int i = 0; i < n; ++i) {
            if (sample[i] < this.getPeak()) {
                nl += 1.0;
                sumXLInv2 += 1.0 / ((sample[i] - this.getLeft()) * (sample[i] - this.getLeft()));
                continue;
            }
            nr += 1.0;
            sumRXInv2 += 1.0 / ((this.getRight() - sample[i]) * (this.getRight() - sample[i]));
        }
        double PL2Inv = 1.0 / ((this.getPeak() - this.getLeft()) * (this.getPeak() - this.getLeft()));
        double RP2Inv = 1.0 / ((this.getRight() - this.getPeak()) * (this.getRight() - this.getPeak()));
        double RL2Inv = 1.0 / ((this.getRight() - this.getLeft()) * (this.getRight() - this.getLeft()));
        double dldl = sumXLInv2 - nl * PL2Inv + (double)n * RL2Inv;
        double dldp = nl * PL2Inv;
        double dldr = (double)n * RL2Inv;
        double dpdl = dldp;
        double dpdp = -nr * RP2Inv - nl * PL2Inv;
        double dpdr = nr * RP2Inv;
        double drdl = dldr;
        double drdp = dpdr;
        double drdr = sumRXInv2 - nr * RP2Inv - (double)n * RL2Inv;
        return new double[]{dldl, dldp, dldr, dpdl, dpdp, dpdr, drdl, drdp, drdr};
    }
}

