/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics;

import hec.statistics.AbstractContDist;
import hec.statistics.LinearMoments;
import hec.statistics.MaximumLikelihood;
import hec.statistics.ProductMoments;
import hec.statistics.util.StringUtil;
import hec.statistics.util.TextFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;

public class UnifDist
extends AbstractContDist {
    public static final String NAME = "Uniform";
    private double _left;
    private double _right;

    public UnifDist() {
        this(0.0, 1.0);
    }

    public UnifDist(double left, double right) {
        if (left > right) {
            right = left;
        }
        this._left = left;
        this._right = right;
    }

    public UnifDist(double[] sample) {
        this.fitSampleData(sample);
    }

    public UnifDist(double[] sample, AbstractContDist.FittingMethod method) {
        this.fitSampleData(sample, method);
    }

    @Override
    public boolean fitSampleData(ProductMoments pm) {
        if (pm.getStDv() <= 0.0) {
            this.setLeft(Double.NaN);
            this.setRight(Double.NaN);
            return false;
        }
        this.setLeft(pm.getMean() - Math.sqrt(3.0) * pm.getStDv());
        this.setRight(pm.getMean() + Math.sqrt(3.0) * pm.getStDv());
        return true;
    }

    @Override
    public boolean fitSampleData(LinearMoments lm) {
        if (lm.getL2() <= 0.0) {
            this.setLeft(Double.NaN);
            this.setRight(Double.NaN);
            return false;
        }
        this.setLeft(lm.getL1() - 3.0 * lm.getL2());
        this.setRight(lm.getL1() + 3.0 * lm.getL2());
        return true;
    }

    public void setLeft(double left) {
        this._left = left;
    }

    public double getLeft() {
        return this._left;
    }

    public void setRight(double right) {
        this._right = right;
    }

    public double getRight() {
        return this._right;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public String[] getParamNames() {
        return new String[]{"Left", "Right"};
    }

    @Override
    public double[] getParamVals() {
        return new double[]{this.getLeft(), this.getRight()};
    }

    @Override
    public void setParamVals(double[] vals) {
        if (vals.length != this.getParamVals().length) {
            throw new IllegalArgumentException("Improper number of parameters for " + this.getClass().getName() + ". " + vals.length + " were provided but " + this.getParamVals().length + " were expected");
        }
        this.setLeft(vals[0]);
        this.setRight(vals[1]);
    }

    @Override
    public Object clone() {
        UnifDist clonedDist = (UnifDist)super.clone();
        return clonedDist;
    }

    @Override
    public void read(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    line = reader.readLine();
                    continue;
                }
                String type = StringUtil.getFirstToken(line, ":");
                String param = StringUtil.getSecondToken(line, ":");
                if (type.equals("UnifDistEnd")) {
                    return;
                }
                if (type.equals("Left")) {
                    this.setLeft(Double.parseDouble(param));
                } else if (type.equals("Right")) {
                    this.setRight(Double.parseDouble(param));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Failed to read UnifDist Data.   " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter writer) {
        TextFile.writeLine(writer, "UnifDistBegin");
        TextFile.writeLine(writer, "Left:" + this.getLeft());
        TextFile.writeLine(writer, "Right:" + this.getRight());
        TextFile.writeLine(writer, "UnifDistEnd");
    }

    @Override
    public double getPDF(double value) {
        if (value <= this._left) {
            return 0.0;
        }
        if (value >= this._right) {
            return 0.0;
        }
        return 1.0 / (this._right - this._left);
    }

    @Override
    public double getCDF(double value) {
        if (value <= this._left) {
            return 0.0;
        }
        if (value >= this._right) {
            return 1.0;
        }
        return (value - this._left) / (this._right - this._left);
    }

    @Override
    public double invCDF(double p) {
        if (p <= 0.0) {
            return this._left;
        }
        if (p >= 1.0) {
            return this._right;
        }
        return (1.0 - p) * this._left + p * this._right;
    }

    @Override
    public boolean fitSampleData(MaximumLikelihood ml) {
        double[] sorted = new double[ml.getSample().length];
        System.arraycopy(ml.getSample(), 0, sorted, 0, sorted.length);
        Arrays.sort(sorted);
        this.setLeft(sorted[0]);
        this.setRight(sorted[sorted.length - 1]);
        return true;
    }

    @Override
    public double getLogLikelihood(double[] sample) {
        double retval = 0.0;
        for (int i = 0; i < sample.length; ++i) {
            retval += Math.log(this.getPDF(sample[i]));
        }
        return retval;
    }
}

