/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.bootstrap;

import hec.statistics.AbstractContDist;
import hec.statistics.ComputationException;
import hec.statistics.ContDist;
import hec.statistics.NormalDist;
import hec.statistics.bootstrap.BootstrapAnalysisContainer;
import hec.statistics.bootstrap.bootstrapOutput;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BootstrapAnalysis {
    protected final ContDist _dist;
    protected final AbstractContDist.FittingMethod _method;
    protected final int _sampleSize;
    protected final double[] _confidenceLimitValues;
    protected final double _minConfLimit;
    protected final double _maxConfLimit;
    protected final double[] _probabilityOrdinates;
    protected final double _zAlpha;
    protected final double _relError;
    protected final int _minIter;
    protected final int _maxIter;
    protected Random _rnd;
    private final long seed = 12345L;
    protected BootstrapAnalysisContainer _bac;
    protected Lock[] _BootstrapLocks;
    protected Lock[] _UpdateLocks;
    private AtomicInteger _numIter = new AtomicInteger(0);
    private AtomicBoolean _converge = new AtomicBoolean(false);

    public double[] getOrdinates() {
        return this._probabilityOrdinates;
    }

    public int getNumIter() {
        return this._numIter.get();
    }

    public boolean getConverge() {
        return this._converge.get();
    }

    public BootstrapAnalysis(ContDist dist, AbstractContDist.FittingMethod method, int sampleSize, double[] confidenceLimitValues, double[] ordinates, double confidence, double relError, int minIter, int maxIter) {
        this._dist = dist;
        this._method = method;
        this._sampleSize = sampleSize;
        this._confidenceLimitValues = confidenceLimitValues;
        this._probabilityOrdinates = ordinates;
        this._relError = relError;
        this._minIter = minIter;
        this._maxIter = maxIter;
        NormalDist n = new NormalDist();
        this._zAlpha = n.invCDF(0.5 + 0.5 * confidence);
        double tmpmax = this._confidenceLimitValues[0];
        double tmpmin = this._confidenceLimitValues[0];
        for (double d : this._confidenceLimitValues) {
            if (d > tmpmax) {
                tmpmax = d;
            }
            if (!(d < tmpmin)) continue;
            tmpmin = d;
        }
        this._maxConfLimit = tmpmax;
        this._minConfLimit = tmpmin;
        this._rnd = new Random(12345L);
    }

    protected ContDist computeBootstrap() {
        double[] oneSampleSet = new double[this._sampleSize];
        int numOrdinates = this._probabilityOrdinates.length;
        double[] values = new double[numOrdinates];
        ContDist distFit = null;
        for (int j = 0; j < this._sampleSize; ++j) {
            oneSampleSet[j] = this._dist.invCDF(this._rnd.nextDouble());
        }
        try {
            distFit = (ContDist)this._dist.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        distFit.fitSampleData(oneSampleSet, this._method);
        return distFit;
    }

    public abstract bootstrapOutput processBootstrap(ContDist var1);

    public abstract bootstrapOutput processBootstrapSyncLock(ContDist var1);

    public abstract BootstrapAnalysisContainer initalize() throws ComputationException;

    public BootstrapAnalysisContainer compute() throws ComputationException {
        BootstrapAnalysisContainer bac;
        try {
            bac = this.initalize();
        }
        catch (ComputationException e) {
            throw new ComputationException("Compute Failed. Please check your input.", e);
        }
        this._bac = bac;
        this._numIter.set(this._minIter);
        this._BootstrapLocks = new Lock[this._probabilityOrdinates.length];
        this._UpdateLocks = new Lock[this._probabilityOrdinates.length];
        for (int k = 0; k < this._probabilityOrdinates.length; ++k) {
            this._BootstrapLocks[k] = new ReentrantLock();
            this._UpdateLocks[k] = new ReentrantLock();
        }
        this._converge.set(false);
        ForkJoinPool pool = new ForkJoinPool();
        SyncSample sample = new SyncSample(Runtime.getRuntime().availableProcessors());
        pool.invoke(sample);
        this._bac.setConvergenceReached(this._converge.get());
        this._bac.setMaximumIteration(this._maxIter);
        this._bac.setNumberIterations(this._numIter.get());
        return this._bac;
    }

    private class SyncSample
    extends RecursiveAction {
        private static final long serialVersionUID = 3524889643976333282L;
        private int _numForks;

        public SyncSample(int numForks) {
            this._numForks = numForks;
        }

        @Override
        protected void compute() {
            if (this._numForks <= 0) {
                while (BootstrapAnalysis.this._numIter.get() < BootstrapAnalysis.this._maxIter && !BootstrapAnalysis.this._converge.get()) {
                    bootstrapOutput out = BootstrapAnalysis.this.processBootstrapSyncLock(BootstrapAnalysis.this.computeBootstrap());
                    BootstrapAnalysis.this._bac.UpdateSyncLock(out, BootstrapAnalysis.this._UpdateLocks);
                    BootstrapAnalysis.this._numIter.incrementAndGet();
                    BootstrapAnalysis.this._converge.set(BootstrapAnalysis.this._bac.CheckConvergenceSyncLock(BootstrapAnalysis.this._minConfLimit, BootstrapAnalysis.this._maxConfLimit, BootstrapAnalysis.this._zAlpha, BootstrapAnalysis.this._relError, BootstrapAnalysis.this._UpdateLocks));
                }
            } else {
                ArrayList<SyncSample> subSamples = new ArrayList<SyncSample>();
                for (int i = 0; i < this._numForks; ++i) {
                    subSamples.add(new SyncSample(0));
                }
                SyncSample.invokeAll(subSamples);
            }
        }
    }
}

