/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.bootstrap;

import hec.statistics.AbstractContDist;
import hec.statistics.ComputationException;
import hec.statistics.ContDist;
import hec.statistics.bootstrap.BootstrapAnalysis;
import hec.statistics.bootstrap.BootstrapAnalysisContainer;
import hec.statistics.bootstrap.CombinedBootstrapOutput;
import hec.statistics.bootstrap.CombinedContainer;
import hec.statistics.bootstrap.bootstrapOutput;
import java.util.Arrays;

public class CombinedAnalysis
extends BootstrapAnalysis {
    private double[] _meanValues = null;
    private boolean _isComputeBinWidthsInLog = false;

    public CombinedAnalysis(ContDist dist, AbstractContDist.FittingMethod method, int sampleSize, double[] confidenceLimitValues, double[] ordinates, double confidence, double relError, int minIter, int maxIter) {
        super(dist, method, sampleSize, confidenceLimitValues, ordinates, confidence, relError, minIter, maxIter);
    }

    public CombinedAnalysis(double[] values, ContDist dist, AbstractContDist.FittingMethod method, int sampleSize, double[] confidenceLimitValues, double[] ordinates, double confidence, double relError, int minIter, int maxIter) {
        this(dist, method, sampleSize, confidenceLimitValues, ordinates, confidence, relError, minIter, maxIter);
        this._meanValues = values;
    }

    public CombinedAnalysis(boolean useLogSpace, ContDist dist, AbstractContDist.FittingMethod method, int sampleSize, double[] confidenceLimitValues, double[] ordinates, double confidence, double relError, int minIter, int maxIter) {
        this(dist, method, sampleSize, confidenceLimitValues, ordinates, confidence, relError, minIter, maxIter);
        this._isComputeBinWidthsInLog = useLogSpace;
    }

    public CombinedAnalysis(double[] values, boolean isComputeBinWidthsInLog, ContDist dist, AbstractContDist.FittingMethod method, int sampleSize, double[] confidenceLimitValues, double[] ordinates, double confidence, double relError, int minIter, int maxIter) {
        this(values, dist, method, sampleSize, confidenceLimitValues, ordinates, confidence, relError, minIter, maxIter);
        this._isComputeBinWidthsInLog = isComputeBinWidthsInLog;
    }

    @Override
    public bootstrapOutput processBootstrap(ContDist distFit) {
        double value = distFit.invCDF(this._rnd.nextDouble());
        int numOrdinates = this._probabilityOrdinates.length;
        double[] values = new double[numOrdinates];
        for (int k = 0; k < numOrdinates; ++k) {
            values[k] = distFit.invCDF(this._probabilityOrdinates[k]);
        }
        Arrays.sort(values);
        this.reverse(values);
        return new CombinedBootstrapOutput(value, values);
    }

    @Override
    public bootstrapOutput processBootstrapSyncLock(ContDist distFit) {
        int numOrdinates = this._probabilityOrdinates.length;
        double value = distFit.invCDF(this._rnd.nextDouble());
        double[] values = new double[numOrdinates];
        for (int k = 0; k < numOrdinates; ++k) {
            this._BootstrapLocks[k].lock();
            values[k] = distFit.invCDF(this._probabilityOrdinates[k]);
            this._BootstrapLocks[k].unlock();
        }
        Arrays.sort(values);
        this.reverse(values);
        return new CombinedBootstrapOutput(value, values);
    }

    @Override
    public BootstrapAnalysisContainer initalize() throws ComputationException {
        if (this._dist == null || this._sampleSize <= 0 || this._confidenceLimitValues == null || this._probabilityOrdinates == null || this._relError <= 0.0 || Math.abs(this._zAlpha) > 7.0 || this._minIter <= 0 || this._maxIter <= this._minIter) {
            return null;
        }
        CombinedBootstrapOutput[] initalData = new CombinedBootstrapOutput[this._minIter];
        double minVal = Double.MAX_VALUE;
        double maxVal = Double.MIN_VALUE;
        double[] tmpSamples = new double[this._minIter];
        for (int i = 0; i < this._minIter; ++i) {
            CombinedBootstrapOutput smpl = (CombinedBootstrapOutput)this.processBootstrap(this.computeBootstrap());
            double tmpVal = smpl.getValue();
            double[] tmpSmpl = smpl.getValues();
            Arrays.sort(tmpSmpl);
            tmpSamples[i] = tmpVal;
            if (tmpSmpl[tmpSmpl.length - 1] > maxVal) {
                maxVal = tmpSmpl[tmpSmpl.length - 1];
            }
            if (tmpSmpl[0] < minVal) {
                minVal = tmpSmpl[0];
            }
            this.reverse(tmpSmpl);
            initalData[i] = smpl;
        }
        if (this._meanValues == null) {
            if (this._isComputeBinWidthsInLog) {
                double logMax = Math.ceil(Math.log10(maxVal));
                double logMin = 0.0;
                if (!(minVal <= 0.0)) {
                    logMin = Math.floor(Math.log10(minVal));
                }
                int numBins = 40;
                this._meanValues = new double[40];
                double delta = (logMax - logMin) / (double)numBins;
                for (int i = 0; i < this._meanValues.length; ++i) {
                    this._meanValues[i] = Math.pow(10.0, logMin + delta * (double)i);
                }
            } else {
                int initMinBins = 40;
                int initMaxBins = 100;
                Arrays.sort(tmpSamples);
                int qIdx = (int)(this._minConfLimit * (double)this._minIter);
                double lowQVal = tmpSamples[qIdx];
                double prelimBinWidth = lowQVal * this._relError * 0.2;
                int numBins = (int)((maxVal - minVal) / prelimBinWidth);
                numBins = Math.min(Math.max(numBins, initMinBins), initMaxBins);
                double delta = (maxVal - minVal) / (double)initMinBins;
                this._meanValues = new double[initMinBins];
                for (int i = 0; i < initMinBins; ++i) {
                    this._meanValues[i] = minVal + delta * (double)i;
                }
            }
        } else {
            Arrays.sort(this._meanValues);
        }
        CombinedContainer bac = new CombinedContainer(this._meanValues, tmpSamples, initalData, this._probabilityOrdinates, this._minConfLimit, this._relError, this._confidenceLimitValues);
        return bac;
    }

    private void reverse(double[] array) {
        int i;
        double[] copyArray = new double[array.length];
        for (i = 0; i < array.length; ++i) {
            copyArray[i] = array[i];
        }
        for (i = 0; i < array.length; ++i) {
            array[i] = copyArray[array.length - i - 1];
        }
    }
}

