/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.bootstrap;

import hec.statistics.ComputationException;
import hec.statistics.ContDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.bootstrap.CombinedBootstrapOutput;
import hec.statistics.bootstrap.ConfidenceAnalysisContainer;
import hec.statistics.bootstrap.ConfidenceLimit;
import hec.statistics.bootstrap.HistDist;
import hec.statistics.bootstrap.ICreateConfidenceLimits;
import hec.statistics.bootstrap.ICreateMeanCurves;
import hec.statistics.bootstrap.bootstrapOutput;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

public class CombinedContainer
extends ConfidenceAnalysisContainer
implements ICreateConfidenceLimits,
ICreateMeanCurves {
    private double[] _values;
    private int[] _ExceedanceCounts;

    CombinedContainer(double[] values, double[] samples, CombinedBootstrapOutput[] initalData, double[] probabilityOrdinates, double minConfLimit, double relError, double[] confidenceLimitValues) throws ComputationException {
        super(confidenceLimitValues);
        int numOrdinates = initalData[0].getValues().length;
        this._probabilities = probabilityOrdinates;
        this._values = values;
        this._ExceedanceCounts = new int[values.length];
        int numSamples = samples.length;
        this._Histograms = new HistDist[numOrdinates];
        int initMinBins = 50;
        int initMaxBins = 10000;
        double[][] initData = new double[numOrdinates][numSamples];
        for (int i = 0; i < numSamples; ++i) {
            for (int k = 0; k < numOrdinates; ++k) {
                initData[k][i] = initalData[i].getValues()[k];
            }
            for (int j = 0; j < this._values.length; ++j) {
                if (!(this._values[j] > samples[i])) continue;
                int n = j;
                this._ExceedanceCounts[n] = this._ExceedanceCounts[n] + 1;
            }
        }
        for (int k = 0; k < numOrdinates; ++k) {
            Arrays.sort(initData[k]);
            double min = initData[k][0];
            double max = initData[k][numSamples - 1];
            int qIdx = (int)(minConfLimit * (double)numSamples);
            double lowQVal = initData[k][qIdx];
            double prelimBinWidth = lowQVal * relError * 0.2;
            int numBins = (int)((max - min) / prelimBinWidth);
            numBins = Math.min(Math.max(numBins, initMinBins), initMaxBins);
            this._Histograms[k] = new HistDist(numBins, min, max);
            this._Histograms[k].addObservations(initData[k]);
        }
    }

    public void Update(bootstrapOutput output) {
        int i;
        CombinedBootstrapOutput tmp = (CombinedBootstrapOutput)output;
        for (i = 0; i < this._values.length; ++i) {
            if (!(this._values[i] > tmp.getValue())) continue;
            int n = i;
            this._ExceedanceCounts[n] = this._ExceedanceCounts[n] + 1;
        }
        for (i = 0; i < this._Histograms.length; ++i) {
            this._Histograms[i].addObservation(tmp.getValues()[i]);
        }
    }

    public void UpdateSyncLock(bootstrapOutput output, Lock[] lock) {
        int i;
        CombinedBootstrapOutput tmp = (CombinedBootstrapOutput)output;
        for (i = 0; i < this._values.length; ++i) {
            if (!(this._values[i] > tmp.getValue())) continue;
            int n = i;
            this._ExceedanceCounts[n] = this._ExceedanceCounts[n] + 1;
        }
        for (i = 0; i < this._Histograms.length; ++i) {
            lock[i].lock();
            this._Histograms[i].addObservation(tmp.getValues()[i]);
            lock[i].unlock();
        }
    }

    @Override
    public boolean CheckConvergenceSyncLock(double minConfLimit, double maxConfLimit, double zAlpha, double relativeError, Lock[] lock) {
        for (int i = 0; i < this._Histograms.length; ++i) {
            if (this._Histograms[i].getConverged()) continue;
            lock[i].lock();
            if (!this._Histograms[i].testForConvergence(minConfLimit, maxConfLimit, zAlpha, relativeError)) {
                lock[i].unlock();
                return false;
            }
            lock[i].unlock();
        }
        return true;
    }

    @Override
    public void WriteToConsole(double[] confidenceLimitProbabilities) {
        int i;
        ConfidenceLimit[] limits = this.CreateConfidenceLimits(confidenceLimitProbabilities);
        System.out.println("ConfidenceLimits:");
        Object header = "Probability,";
        for (i = 0; i < confidenceLimitProbabilities.length - 1; ++i) {
            header = (String)header + confidenceLimitProbabilities[i] + ",";
        }
        header = (String)header + confidenceLimitProbabilities[confidenceLimitProbabilities.length - 1];
        System.out.println((String)header);
        for (i = 0; i < limits.length; ++i) {
            header = limits[i].getProbabilityOrdinate() + ",";
            for (int j = 0; j < confidenceLimitProbabilities.length - 1; ++j) {
                header = (String)header + limits[i].getValues()[j] + ",";
            }
            header = (String)header + limits[i].getValues()[confidenceLimitProbabilities.length - 1];
            System.out.println((String)header);
        }
    }

    @Override
    public EmpiricalDist CreateMeanCurve() {
        double[] probs = new double[this._values.length];
        int numObs = this._Histograms[0].getNumObs();
        for (int i = 0; i < this._values.length; ++i) {
            probs[i] = (double)this._ExceedanceCounts[i] / (double)numObs;
        }
        return new EmpiricalDist(probs, this._values);
    }

    @Override
    public double[] getExpectedProbability() {
        return this._values;
    }

    @Override
    public double[] getExpectedProbability(double[] probabilities) {
        double[] retval = new double[probabilities.length];
        EmpiricalDist dist = this.CreateMeanCurve();
        double[] values = dist.getCumProbs();
        Arrays.sort(values);
        double minValue = values[0];
        double maxValue = values[values.length - 1];
        for (int i = 0; i < probabilities.length; ++i) {
            retval[i] = probabilities[i] < minValue || probabilities[i] > maxValue ? Double.NaN : dist.invCDF(probabilities[i]);
        }
        return retval;
    }

    @Override
    public double[] getExpectedProbabilityOrdinates() {
        double[] retval = new double[this._values.length];
        EmpiricalDist dist = this.CreateMeanCurve();
        double[] values = dist.getValues();
        Arrays.sort(values);
        double minValue = values[0];
        double maxValue = values[values.length - 1];
        for (int i = 0; i < this._values.length; ++i) {
            retval[i] = this._values[i] < minValue || this._values[i] > maxValue ? Double.NaN : dist.getCDF(this._values[i]);
        }
        return retval;
    }

    @Override
    public void WriteToConsole(ContDist medianDist) {
        EmpiricalDist dist = this.CreateMeanCurve();
        System.out.println("Mean Curve:");
        System.out.println("Probability,Median,Mean");
        for (int i = 0; i < dist.size(); ++i) {
            System.out.println(dist.getCumProb(i) + "," + medianDist.invCDF(dist.getCumProb(i)) + "," + dist.getValue(i));
        }
    }
}

