/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.bootstrap;

import hec.statistics.AbstractContDist;
import hec.statistics.ComputationException;
import hec.statistics.ContDist;
import hec.statistics.LogPearson3Dist;
import hec.statistics.NormalDist;
import hec.statistics.bootstrap.HistDist;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Confidence {
    private ContDist _dist;
    private AbstractContDist.FittingMethod _method;
    private int _sampleSize;
    private double[] _confidenceLimitValues;
    private double _minConfLimit;
    private double _maxConfLimit;
    private double[] _probabilityOrdinates;
    private double[] _independentVariableOrdinates;
    private double _confidence;
    private double _zAlpha;
    private double _relError;
    private int _minIter;
    private int _maxIter;
    private boolean _sampleProbabilityOrdinates = true;
    private boolean _keepOutputsInProbabilitySpace = false;
    private Lock[] _locks;
    private HistDist[] _ordHistDists;
    private AtomicInteger _numIter = new AtomicInteger(0);
    private AtomicBoolean _converge = new AtomicBoolean(false);
    private double[][] _confidenceLimitCurves;
    private int[] _exceedanceCountsByIndependantVariables;
    private final long seed = 12345L;

    public double[] getOrdinates() {
        return this._probabilityOrdinates;
    }

    public double[] getIndependentVariableOrdinates() {
        return this._independentVariableOrdinates;
    }

    public HistDist[] getOrdinateHistograms() {
        return this._ordHistDists;
    }

    public int getNumIter() {
        return this._numIter.get();
    }

    public boolean getConverge() {
        return this._converge.get();
    }

    public double[][] getConfidenceLimitCurves() throws ComputationException {
        return this.getConfidenceLimitCurves(true);
    }

    public double[][] getConfidenceLimitCurves(boolean sampleProbabilityOrdinates) throws ComputationException {
        if (this._confidenceLimitCurves == null || this._sampleProbabilityOrdinates != sampleProbabilityOrdinates) {
            this._sampleProbabilityOrdinates = sampleProbabilityOrdinates;
            this.computeConfidenceCurves();
        }
        return this._confidenceLimitCurves;
    }

    public Confidence(ContDist dist, AbstractContDist.FittingMethod method, int sampleSize, double[] confidenceLimitValues, double[] ordinates, double confidence, double relError, int minIter, int maxIter) {
        this._dist = dist;
        this._method = method;
        this._sampleSize = sampleSize;
        this._confidenceLimitValues = confidenceLimitValues;
        this._probabilityOrdinates = ordinates;
        this._confidence = confidence;
        this._relError = relError;
        this._minIter = minIter;
        this._maxIter = maxIter;
        this._exceedanceCountsByIndependantVariables = new int[this._probabilityOrdinates.length];
        if (this._dist != null && this._probabilityOrdinates != null) {
            this._independentVariableOrdinates = new double[this._probabilityOrdinates.length];
            for (int i = 0; i < this._probabilityOrdinates.length; ++i) {
                this._independentVariableOrdinates[i] = this._dist.invCDF(this._probabilityOrdinates[i]);
            }
        }
    }

    public void computeConfidenceCurves() throws ComputationException {
        int k;
        if (this._dist == null || this._sampleSize <= 0 || this._confidenceLimitValues == null || this._probabilityOrdinates == null || this._relError <= 0.0 || this._confidence >= 1.0 || this._minIter <= 0 || this._maxIter <= this._minIter) {
            return;
        }
        NormalDist n = new NormalDist();
        this._zAlpha = n.invCDF(0.5 + 0.5 * this._confidence);
        Random rnd = new Random(12345L);
        int initMinBins = 50;
        int initMaxBins = 10000;
        int numOrdinates = this._probabilityOrdinates.length;
        double[][] initData = new double[numOrdinates][this._minIter];
        double[] oneSampleSet = new double[this._sampleSize];
        ContDist distFit = null;
        for (int i = 0; i < this._minIter; ++i) {
            for (int j = 0; j < this._sampleSize; ++j) {
                oneSampleSet[j] = this._dist.invCDF(rnd.nextDouble());
            }
            try {
                distFit = (ContDist)this._dist.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            distFit.fitSampleData(oneSampleSet, this._method);
            double tmpcdf = distFit.invCDF(rnd.nextDouble());
            for (int k2 = 0; k2 < numOrdinates; ++k2) {
                initData[k2][i] = this.getSampledValue(distFit, k2);
                if (!(tmpcdf > this._independentVariableOrdinates[k2])) continue;
                int n2 = k2;
                this._exceedanceCountsByIndependantVariables[n2] = this._exceedanceCountsByIndependantVariables[n2] + 1;
            }
        }
        this._minConfLimit = this._confidenceLimitValues[0];
        this._maxConfLimit = this._confidenceLimitValues[0];
        for (double d : this._confidenceLimitValues) {
            if (d > this._maxConfLimit) {
                this._maxConfLimit = d;
            }
            if (!(d < this._minConfLimit)) continue;
            this._minConfLimit = d;
        }
        this._ordHistDists = new HistDist[numOrdinates];
        for (k = 0; k < numOrdinates; ++k) {
            Arrays.sort(initData[k]);
            double min = initData[k][0];
            double max = initData[k][this._minIter - 1];
            int qIdx = (int)(this._minConfLimit * (double)this._minIter);
            double lowQVal = initData[k][qIdx];
            double prelimBinWidth = lowQVal * this._relError * 0.2;
            int numBins = (int)((max - min) / prelimBinWidth);
            numBins = Math.min(Math.max(numBins, initMinBins), initMaxBins);
            this._ordHistDists[k] = new HistDist(numBins, min, max);
            this._ordHistDists[k].addObservations(initData[k]);
        }
        this._numIter.set(this._minIter);
        this._locks = new Lock[numOrdinates];
        for (k = 0; k < numOrdinates; ++k) {
            this._locks[k] = new ReentrantLock();
        }
        this._converge.set(false);
        ForkJoinPool pool = new ForkJoinPool();
        SyncSample sample = new SyncSample(Runtime.getRuntime().availableProcessors());
        pool.invoke(sample);
        int numCurves = this._confidenceLimitValues.length;
        this._confidenceLimitCurves = new double[numCurves][numOrdinates];
        for (int j = 0; j < numCurves; ++j) {
            for (int k3 = 0; k3 < numOrdinates; ++k3) {
                this._confidenceLimitCurves[j][k3] = this.getConfidenceCurveValue(k3, j);
            }
        }
    }

    private double getConfidenceCurveValue(int ordinate, int curve) {
        if (this._sampleProbabilityOrdinates || this._keepOutputsInProbabilitySpace) {
            return this._ordHistDists[ordinate].invCDF(this._confidenceLimitValues[curve]);
        }
        return this._dist.invCDF(this._ordHistDists[ordinate].invCDF(this._confidenceLimitValues[curve]));
    }

    private double getSampledValue(ContDist distFit, int k) {
        return distFit.invCDF(this._probabilityOrdinates[k]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncAddObservation(int k, double observation) {
        this._locks[k].lock();
        try {
            boolean bl = this._ordHistDists[k].addObservation(observation);
            return bl;
        }
        finally {
            this._locks[k].unlock();
        }
    }

    private boolean syncAllOrdinatesConverged() {
        if (this._ordHistDists == null) {
            return true;
        }
        int numOrdinates = this._ordHistDists.length;
        for (int k = 0; k < numOrdinates; ++k) {
            if (this.syncOrdinateConverged(k)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncOrdinateConverged(int k) {
        HistDist histDist = this._ordHistDists[k];
        this._locks[k].lock();
        try {
            double qVal = histDist.invCDF(this._minConfLimit);
            double qSlope = histDist.getPDF(qVal);
            double variance = this._minConfLimit * (1.0 - this._minConfLimit) / ((double)histDist.getNumObs() * qSlope * qSlope);
            if (!(Math.abs(this._zAlpha * Math.sqrt(variance) / qVal) <= this._relError * 0.5)) {
                boolean bl = false;
                return bl;
            }
            qVal = histDist.invCDF(this._maxConfLimit);
            qSlope = histDist.getPDF(qVal);
            variance = this._maxConfLimit * (1.0 - this._maxConfLimit) / ((double)histDist.getNumObs() * qSlope * qSlope);
            if (!(Math.abs(this._zAlpha * Math.sqrt(variance) / qVal) <= this._relError * 0.5)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this._locks[k].unlock();
        }
        return true;
    }

    public static double[][] computeWithEmpirical(double[] prob, double[] values, int years, double lowerConfidenceLevel, double upperConfidenceLevel) {
        return null;
    }

    public static void main(String[] args) throws ComputationException {
        int n = Runtime.getRuntime().availableProcessors();
        System.out.println("Processors: " + n);
        LogPearson3Dist lp3 = new LogPearson3Dist(3.031, 0.661, -0.87);
        long startTime = System.currentTimeMillis();
        double[] probs = new double[]{0.001, 0.01, 0.1, 0.5, 0.9, 0.99, 0.999};
        Confidence cf = new Confidence(lp3, AbstractContDist.FittingMethod.ProductMoments, 80, new double[]{0.05, 0.95}, probs, 0.9, 0.05, 100, 1000000);
        double[][] probabilityParameterCurves = cf.getConfidenceLimitCurves(true);
        double[] probabilityParameterExpectedProbability = cf.getExpectedProbability();
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        System.out.println("Compute Time(s): " + (double)totalTime / 1000.0);
        System.out.println("Iterations     : " + cf.getNumIter());
        System.out.println("Time(ms)/iter  : " + (double)totalTime / (double)cf.getNumIter());
        System.out.println("Probability,lower,mean,invcdf,upper");
        for (int i = 0; i < probabilityParameterExpectedProbability.length; ++i) {
            System.out.println(probs[i] + "," + probabilityParameterCurves[0][i] + "," + (1.0 - probabilityParameterExpectedProbability[i]) + "," + lp3.invCDF(probs[i]) + "," + probabilityParameterCurves[1][i]);
        }
        System.out.println("done");
    }

    private double[] getExpectedProbability() {
        double[] retval = new double[this._probabilityOrdinates.length];
        for (int k = 0; k < retval.length; ++k) {
            retval[k] = (double)this._exceedanceCountsByIndependantVariables[k] / (double)this._ordHistDists[k].getNumObs();
        }
        return retval;
    }

    private class SyncSample
    extends RecursiveAction {
        private static final long serialVersionUID = 3524889643976333282L;
        private int _numForks;

        public SyncSample(int numForks) {
            this._numForks = numForks;
        }

        @Override
        protected void compute() {
            if (this._numForks <= 0) {
                Random rnd = new Random(12345L);
                double[] oneSampleSet = new double[Confidence.this._sampleSize];
                int numOrdinates = Confidence.this._ordHistDists.length;
                ContDist distFit = null;
                try {
                    distFit = (ContDist)Confidence.this._dist.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                while (Confidence.this._numIter.get() < Confidence.this._maxIter && !Confidence.this._converge.get()) {
                    for (int j = 0; j < Confidence.this._sampleSize; ++j) {
                        oneSampleSet[j] = Confidence.this._dist.invCDF(rnd.nextDouble());
                    }
                    distFit.fitSampleData(oneSampleSet, Confidence.this._method);
                    double tmpcdf = distFit.invCDF(rnd.nextDouble());
                    for (int k = 0; k < numOrdinates; ++k) {
                        double obs = Confidence.this.getSampledValue(distFit, k);
                        Confidence.this.syncAddObservation(k, obs);
                        if (!(tmpcdf > Confidence.this._independentVariableOrdinates[k])) continue;
                        int n = k;
                        Confidence.this._exceedanceCountsByIndependantVariables[n] = Confidence.this._exceedanceCountsByIndependantVariables[n] + 1;
                    }
                    Confidence.this._numIter.incrementAndGet();
                    Confidence.this._converge.set(Confidence.this.syncAllOrdinatesConverged());
                }
            } else {
                ArrayList<SyncSample> subSamples = new ArrayList<SyncSample>();
                for (int i = 0; i < this._numForks; ++i) {
                    subSamples.add(new SyncSample(0));
                }
                SyncSample.invokeAll(subSamples);
            }
        }
    }
}

