/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.bootstrap;

import hec.statistics.bootstrap.BootstrapAnalysisContainer;
import hec.statistics.bootstrap.ConfidenceLimit;
import hec.statistics.bootstrap.HistDist;
import hec.statistics.bootstrap.ICreateConfidenceLimits;

public abstract class ConfidenceAnalysisContainer
extends BootstrapAnalysisContainer
implements ICreateConfidenceLimits {
    protected HistDist[] _Histograms;
    protected double[] _probabilities;
    private double[] _limits;

    public ConfidenceAnalysisContainer(double[] confidenceLimitValues) {
        this._limits = confidenceLimitValues;
    }

    @Override
    public double[][] getConfidenceLimitCurves() {
        double[][] confidenceLimitCurves = new double[this._limits.length][this._Histograms.length];
        for (int j = 0; j < this._limits.length; ++j) {
            for (int k = 0; k < this._Histograms.length; ++k) {
                confidenceLimitCurves[j][k] = this._Histograms[k].invCDF(this._limits[j]);
            }
        }
        return confidenceLimitCurves;
    }

    @Override
    public double[] getOrdinates() {
        return this._probabilities;
    }

    @Override
    public ConfidenceLimit[] CreateConfidenceLimits(double[] confidenceLimitProbabilities) {
        ConfidenceLimit[] ret = new ConfidenceLimit[this._Histograms.length];
        for (int i = 0; i < this._Histograms.length; ++i) {
            ret[i] = new ConfidenceLimit(this._probabilities[i]);
            ret[i].setConfidenceValues(this._Histograms[i], confidenceLimitProbabilities);
        }
        return ret;
    }
}

