/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.bootstrap;

import hec.statistics.ComputationException;
import hec.statistics.bootstrap.ConfidenceAnalysisContainer;
import hec.statistics.bootstrap.ConfidenceLimit;
import hec.statistics.bootstrap.ConfidenceLimitBootstrapOutput;
import hec.statistics.bootstrap.HistDist;
import hec.statistics.bootstrap.ICreateConfidenceLimits;
import hec.statistics.bootstrap.bootstrapOutput;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

public class ConfidenceContainer
extends ConfidenceAnalysisContainer
implements ICreateConfidenceLimits {
    public ConfidenceContainer(ConfidenceLimitBootstrapOutput[] initalData, double[] probabilities, double minConfLimit, double relativeError, double[] confidenceLimitValues) throws ComputationException {
        super(confidenceLimitValues);
        int numOrdinates = initalData[0].getValues().length;
        this._probabilities = probabilities;
        int numSamples = initalData.length;
        this._Histograms = new HistDist[numOrdinates];
        int initMinBins = 50;
        int initMaxBins = 10000;
        double[][] initData = new double[numOrdinates][numSamples];
        for (int i = 0; i < numSamples; ++i) {
            for (int k = 0; k < numOrdinates; ++k) {
                initData[k][i] = initalData[i].getValues()[k];
            }
        }
        for (int k = 0; k < numOrdinates; ++k) {
            Arrays.sort(initData[k]);
            double min = initData[k][0];
            double max = initData[k][numSamples - 1];
            int qIdx = (int)(minConfLimit * (double)numSamples);
            double lowQVal = initData[k][qIdx];
            double prelimBinWidth = lowQVal * relativeError * 0.2;
            int numBins = (int)((max - min) / prelimBinWidth);
            numBins = Math.min(Math.max(numBins, initMinBins), initMaxBins);
            this._Histograms[k] = new HistDist(numBins, min, max);
            this._Histograms[k].addObservations(initData[k]);
        }
    }

    public void Update(bootstrapOutput output) {
        ConfidenceLimitBootstrapOutput tmp = (ConfidenceLimitBootstrapOutput)output;
        for (int i = 0; i < this._Histograms.length; ++i) {
            this._Histograms[i].addObservation(tmp.getValues()[i]);
        }
    }

    public void UpdateSyncLock(bootstrapOutput output, Lock[] lock) {
        ConfidenceLimitBootstrapOutput tmp = (ConfidenceLimitBootstrapOutput)output;
        for (int i = 0; i < this._Histograms.length; ++i) {
            lock[i].lock();
            this._Histograms[i].addObservation(tmp.getValues()[i]);
            lock[i].unlock();
        }
    }

    @Override
    public boolean CheckConvergenceSyncLock(double minConfLimit, double maxConfLimit, double zAlpha, double relativeError, Lock[] lock) {
        for (int i = 0; i < this._Histograms.length; ++i) {
            if (this._Histograms[i].getConverged()) continue;
            lock[i].lock();
            if (!this._Histograms[i].testForConvergence(minConfLimit, maxConfLimit, zAlpha, relativeError)) {
                lock[i].unlock();
                return false;
            }
            lock[i].unlock();
        }
        return true;
    }

    @Override
    public void WriteToConsole(double[] confidenceLimitProbabilities) {
        int i;
        ConfidenceLimit[] limits = this.CreateConfidenceLimits(confidenceLimitProbabilities);
        System.out.println("ConfidenceLimits:");
        Object header = "Probability,";
        for (i = 0; i < confidenceLimitProbabilities.length - 1; ++i) {
            header = (String)header + confidenceLimitProbabilities[i] + ",";
        }
        header = (String)header + confidenceLimitProbabilities[confidenceLimitProbabilities.length - 1];
        System.out.println((String)header);
        for (i = 0; i < limits.length; ++i) {
            header = limits[i].getProbabilityOrdinate() + ",";
            for (int j = 0; j < confidenceLimitProbabilities.length - 1; ++j) {
                header = (String)header + limits[i].getValues()[j] + ",";
            }
            header = (String)header + limits[i].getValues()[confidenceLimitProbabilities.length - 1];
            System.out.println((String)header);
        }
    }
}

