/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.bootstrap;

import hec.statistics.AbstractContDist;
import hec.statistics.ComputationException;
import hec.statistics.ContDist;
import hec.statistics.bootstrap.BootstrapAnalysis;
import hec.statistics.bootstrap.BootstrapAnalysisContainer;
import hec.statistics.bootstrap.ConfidenceContainer;
import hec.statistics.bootstrap.ConfidenceLimitBootstrapOutput;
import hec.statistics.bootstrap.bootstrapOutput;

public class ConfidenceLimitAnalysis
extends BootstrapAnalysis {
    public ConfidenceLimitAnalysis(ContDist dist, AbstractContDist.FittingMethod method, int sampleSize, double[] confidenceLimitValues, double[] ordinates, double confidence, double relError, int minIter, int maxIter) {
        super(dist, method, sampleSize, confidenceLimitValues, ordinates, confidence, relError, minIter, maxIter);
    }

    @Override
    public bootstrapOutput processBootstrap(ContDist distFit) {
        int numOrdinates = this._probabilityOrdinates.length;
        double[] values = new double[numOrdinates];
        for (int k = 0; k < numOrdinates; ++k) {
            values[k] = distFit.invCDF(this._probabilityOrdinates[k]);
        }
        return new ConfidenceLimitBootstrapOutput(values);
    }

    @Override
    public bootstrapOutput processBootstrapSyncLock(ContDist distFit) {
        int numOrdinates = this._probabilityOrdinates.length;
        double[] values = new double[numOrdinates];
        for (int k = 0; k < numOrdinates; ++k) {
            this._BootstrapLocks[k].lock();
            values[k] = distFit.invCDF(this._probabilityOrdinates[k]);
            this._BootstrapLocks[k].unlock();
        }
        return new ConfidenceLimitBootstrapOutput(values);
    }

    @Override
    public BootstrapAnalysisContainer initalize() throws ComputationException {
        if (this._dist == null || this._sampleSize <= 0 || this._confidenceLimitValues == null || this._probabilityOrdinates == null || this._relError <= 0.0 || Math.abs(this._zAlpha) > 7.0 || this._minIter <= 0 || this._maxIter <= this._minIter) {
            return null;
        }
        ConfidenceLimitBootstrapOutput[] initalData = new ConfidenceLimitBootstrapOutput[this._minIter];
        for (int i = 0; i < this._minIter; ++i) {
            initalData[i] = (ConfidenceLimitBootstrapOutput)this.processBootstrap(this.computeBootstrap());
        }
        ConfidenceContainer bac = new ConfidenceContainer(initalData, this._probabilityOrdinates, this._minConfLimit, this._relError, this._confidenceLimitValues);
        return bac;
    }
}

