/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.bootstrap;

import hec.statistics.AbstractContDist;
import hec.statistics.ComputationException;
import hec.statistics.ContDist;
import hec.statistics.bootstrap.BootstrapAnalysis;
import hec.statistics.bootstrap.BootstrapAnalysisContainer;
import hec.statistics.bootstrap.ExpectedProbabilityBootstrapOutput;
import hec.statistics.bootstrap.ExpectedProbabilityContainer;
import hec.statistics.bootstrap.bootstrapOutput;
import java.util.Arrays;

public class ExpectedProbabilityAnalysis
extends BootstrapAnalysis {
    private double[] _Values = null;
    private boolean _useLogSpace = false;

    public ExpectedProbabilityAnalysis(ContDist dist, AbstractContDist.FittingMethod method, int sampleSize, double[] confidenceLimitValues, double[] ordinates, double confidence, double relError, int minIter, int maxIter) {
        super(dist, method, sampleSize, confidenceLimitValues, ordinates, confidence, relError, minIter, maxIter);
    }

    public ExpectedProbabilityAnalysis(double[] values, ContDist dist, AbstractContDist.FittingMethod method, int sampleSize, double[] confidenceLimitValues, double[] ordinates, double confidence, double relError, int minIter, int maxIter) {
        this(dist, method, sampleSize, confidenceLimitValues, ordinates, confidence, relError, minIter, maxIter);
        this._Values = values;
    }

    public ExpectedProbabilityAnalysis(boolean useLogSpace, ContDist dist, AbstractContDist.FittingMethod method, int sampleSize, double[] confidenceLimitValues, double[] ordinates, double confidence, double relError, int minIter, int maxIter) {
        this(dist, method, sampleSize, confidenceLimitValues, ordinates, confidence, relError, minIter, maxIter);
        this._useLogSpace = useLogSpace;
    }

    public ExpectedProbabilityAnalysis(boolean useLogSpace, double[] values, ContDist dist, AbstractContDist.FittingMethod method, int sampleSize, double[] confidenceLimitValues, double[] ordinates, double confidence, double relError, int minIter, int maxIter) {
        this(dist, method, sampleSize, confidenceLimitValues, ordinates, confidence, relError, minIter, maxIter);
        this._Values = values;
        this._useLogSpace = useLogSpace;
    }

    @Override
    public bootstrapOutput processBootstrap(ContDist distFit) {
        return new ExpectedProbabilityBootstrapOutput(distFit.invCDF(this._rnd.nextDouble()));
    }

    @Override
    public bootstrapOutput processBootstrapSyncLock(ContDist distFit) {
        this._BootstrapLocks[0].lock();
        bootstrapOutput tmp = this.processBootstrap(distFit);
        this._BootstrapLocks[0].unlock();
        return tmp;
    }

    @Override
    public BootstrapAnalysisContainer initalize() throws ComputationException {
        double minVal = Double.MAX_VALUE;
        double maxVal = Double.MIN_VALUE;
        double[] tmpSamples = new double[this._minIter];
        for (int i = 0; i < this._minIter; ++i) {
            double tmpVal;
            ExpectedProbabilityBootstrapOutput smpl = (ExpectedProbabilityBootstrapOutput)this.processBootstrap(this.computeBootstrap());
            tmpSamples[i] = tmpVal = smpl.getValue();
            if (tmpVal > maxVal) {
                maxVal = tmpVal;
            }
            if (!(tmpVal < minVal)) continue;
            minVal = tmpVal;
        }
        if (this._Values == null) {
            if (this._useLogSpace) {
                double logMax = Math.ceil(Math.log10(maxVal));
                double logMin = 0.0;
                if (!(minVal <= 0.0)) {
                    logMin = Math.floor(Math.log10(minVal));
                }
                int numBins = 40;
                this._Values = new double[40];
                double delta = (logMax - logMin) / (double)numBins;
                for (int i = 0; i < this._Values.length; ++i) {
                    this._Values[i] = Math.pow(10.0, logMin + delta * (double)i);
                }
            } else {
                int initMinBins = 40;
                int initMaxBins = 100;
                Arrays.sort(tmpSamples);
                double min = tmpSamples[0];
                double max = tmpSamples[this._minIter - 1];
                int qIdx = (int)(this._minConfLimit * (double)this._minIter);
                double lowQVal = tmpSamples[qIdx];
                double prelimBinWidth = lowQVal * this._relError * 0.2;
                int numBins = (int)((max - min) / prelimBinWidth);
                numBins = Math.min(Math.max(numBins, initMinBins), initMaxBins);
                this._Values = new double[numBins];
                for (int i = 0; i < numBins; ++i) {
                    this._Values[i] = this._dist.invCDF(((double)i + 0.5) / (double)numBins);
                }
            }
        }
        ExpectedProbabilityContainer ret = new ExpectedProbabilityContainer(this._Values, tmpSamples, this._minConfLimit, this._relError, this._probabilityOrdinates);
        return ret;
    }
}

