/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.bootstrap;

import hec.statistics.ComputationException;
import hec.statistics.ContDist;
import hec.statistics.EmpiricalDist;
import hec.statistics.bootstrap.BootstrapAnalysisContainer;
import hec.statistics.bootstrap.ExpectedProbabilityBootstrapOutput;
import hec.statistics.bootstrap.HistDist;
import hec.statistics.bootstrap.ICreateMeanCurves;
import hec.statistics.bootstrap.bootstrapOutput;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

public class ExpectedProbabilityContainer
extends BootstrapAnalysisContainer
implements ICreateMeanCurves {
    private double[] _values;
    private HistDist _Histogram;
    private int[] _ExceedanceCounts;
    private double[] _probabilityOrdinates;

    public ExpectedProbabilityContainer(double[] values, double[] samples, double minConfLimit, double relativeError, double[] probabilityOrdinates) throws ComputationException {
        this._probabilityOrdinates = probabilityOrdinates;
        this._values = values;
        this._ExceedanceCounts = new int[values.length];
        int numSamples = samples.length;
        for (int i = 0; i < numSamples; ++i) {
            for (int j = 0; j < this._values.length; ++j) {
                if (!(this._values[j] > samples[i])) continue;
                int n = j;
                this._ExceedanceCounts[n] = this._ExceedanceCounts[n] + 1;
            }
        }
        int initMinBins = 40;
        int initMaxBins = 100;
        Arrays.sort(samples);
        double min = samples[0];
        double max = samples[numSamples - 1];
        int qIdx = (int)(minConfLimit * (double)numSamples);
        double lowQVal = samples[qIdx];
        double prelimBinWidth = lowQVal * relativeError * 0.2;
        int numBins = (int)((max - min) / prelimBinWidth);
        numBins = Math.min(Math.max(numBins, initMinBins), initMaxBins);
        this._Histogram = new HistDist(numBins, min, max);
        this._Histogram.addObservations(samples);
    }

    public void Update(bootstrapOutput output) {
        ExpectedProbabilityBootstrapOutput tmp = (ExpectedProbabilityBootstrapOutput)output;
        this._Histogram.addObservation(tmp.getValue());
        for (int i = 0; i < this._values.length; ++i) {
            if (!(this._values[i] > tmp.getValue())) continue;
            int n = i;
            this._ExceedanceCounts[n] = this._ExceedanceCounts[n] + 1;
        }
    }

    public void UpdateSyncLock(bootstrapOutput output, Lock[] lock) {
        lock[0].lock();
        this.Update(output);
        lock[0].unlock();
    }

    @Override
    public boolean CheckConvergenceSyncLock(double minConfLimit, double maxConfLimit, double zAlpha, double relativeError, Lock[] lock) {
        if (!this._Histogram.getConverged()) {
            return this._Histogram.testForConvergence(minConfLimit, maxConfLimit, zAlpha, relativeError);
        }
        return true;
    }

    @Override
    public EmpiricalDist CreateMeanCurve() {
        double[] probs = new double[this._values.length];
        int numObs = this._Histogram.getNumObs();
        for (int i = 0; i < this._values.length; ++i) {
            probs[i] = (double)this._ExceedanceCounts[i] / (double)numObs;
        }
        return new EmpiricalDist(probs, this._values);
    }

    @Override
    public double[] getExpectedProbability() {
        return this._values;
    }

    @Override
    public double[] getExpectedProbability(double[] probabilities) {
        double[] retval = new double[probabilities.length];
        EmpiricalDist dist = this.CreateMeanCurve();
        for (int i = 0; i < probabilities.length; ++i) {
            retval[i] = dist.invCDF(probabilities[i]);
        }
        return retval;
    }

    @Override
    public void WriteToConsole(ContDist medianDist) {
        EmpiricalDist dist = this.CreateMeanCurve();
        System.out.println("Mean Curve:");
        System.out.println("Probability,Median,Mean");
        for (int i = 0; i < dist.size(); ++i) {
            System.out.println(dist.getCumProb(i) + "," + medianDist.invCDF(dist.getCumProb(i)) + "," + dist.getValue(i));
        }
    }

    @Override
    public double[] getExpectedProbabilityOrdinates() {
        double[] retval = new double[this._values.length];
        EmpiricalDist dist = this.CreateMeanCurve();
        for (int i = 0; i < this._values.length; ++i) {
            retval[i] = dist.getCDF(this._values[i]);
        }
        return retval;
    }
}

