/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.bootstrap;

import hec.statistics.ComputationException;
import java.util.Arrays;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class HistDist {
    private int[] _bins;
    private double _binWidth = 0.0;
    private double _min;
    private double _max;
    private int _numObs = 0;
    private double _mean = 0.0;
    private int _convergedIteration = 0;
    private boolean _converged = false;

    public HistDist(int numBins, double min, double max) throws ComputationException {
        if (!NumericalConstants.isValidValue((double)min) || !NumericalConstants.isValidValue((double)max)) {
            throw new ComputationException("Invalid min or max bounds to develop histogram.");
        }
        if (numBins <= 0 || min > max) {
            return;
        }
        this._min = min;
        this._max = max;
        this._binWidth = (max - min) / (double)numBins;
        this._bins = new int[numBins];
        Arrays.fill(this._bins, 0);
    }

    public int getNumObs() {
        return this._numObs;
    }

    public boolean getConverged() {
        return this._converged;
    }

    public int getConvergedIteration() {
        return this._convergedIteration;
    }

    public boolean addObservation(double obs) {
        int numBinsToAdd;
        if (this._binWidth <= 0.0 || Double.isInfinite(obs) || Double.isNaN(obs)) {
            return false;
        }
        if (obs < this._min) {
            numBinsToAdd = (int)Math.ceil((this._min - obs) / this._binWidth);
            int[] oldBins = this._bins;
            this._bins = new int[oldBins.length + numBinsToAdd];
            Arrays.fill(this._bins, 0);
            System.arraycopy(oldBins, 0, this._bins, numBinsToAdd, oldBins.length);
            this._min -= (double)numBinsToAdd * this._binWidth;
        } else if (obs > this._max) {
            numBinsToAdd = (int)Math.ceil((obs - this._max) / this._binWidth);
            int[] oldBins = this._bins;
            this._bins = new int[oldBins.length + numBinsToAdd];
            Arrays.fill(this._bins, 0);
            System.arraycopy(oldBins, 0, this._bins, 0, oldBins.length);
            this._max += (double)numBinsToAdd * this._binWidth;
        }
        int idx = (int)((obs - this._min) / this._binWidth);
        int n = idx = idx < this._bins.length ? idx : this._bins.length - 1;
        this._bins[n] = this._bins[n] + 1;
        ++this._numObs;
        this.recomputeMean(obs);
        return true;
    }

    private void recomputeMean(double obs) {
        this._mean += (obs - this._mean) / (double)this._numObs;
    }

    public boolean addObservations(double[] obsArray) {
        if (obsArray == null) {
            return false;
        }
        int num = obsArray.length;
        for (int i = 0; i < num; ++i) {
            if (this.addObservation(obsArray[i])) continue;
            return false;
        }
        return true;
    }

    public double invCDF(double q) {
        if (this._numObs <= 0 || q <= 0.0) {
            return this._min;
        }
        if (q >= 1.0) {
            return this._max;
        }
        double qObs = q * (double)this._numObs;
        if (q <= 0.5) {
            int binObs;
            int idx = 0;
            int cumObs = binObs = this._bins[idx];
            while (qObs > (double)cumObs) {
                binObs = this._bins[++idx];
                cumObs += binObs;
            }
            return this._min + this._binWidth * ((double)(idx + 1) - ((double)cumObs - qObs) / (double)binObs);
        }
        int idx = this._bins.length - 1;
        int binObs = this._bins[idx];
        int cumObs = this._numObs - binObs;
        while (qObs < (double)cumObs) {
            binObs = this._bins[--idx];
            cumObs -= binObs;
        }
        return this._max - this._binWidth * ((double)(this._bins.length - idx) + (qObs - (double)cumObs) / (double)binObs);
    }

    public double getCDF(double val) {
        if (this._numObs <= 0 || val <= this._min) {
            return 0.0;
        }
        if (val >= this._max) {
            return 1.0;
        }
        double dIdx = (val - this._min) / this._binWidth;
        if (dIdx <= 0.0) {
            return 0.0;
        }
        if (dIdx >= (double)this._bins.length) {
            return 1.0;
        }
        if (dIdx <= (double)(this._bins.length / 2)) {
            int idx = (int)Math.floor(dIdx);
            double cumObs = 0.0;
            for (int i = 0; i < idx; ++i) {
                cumObs += (double)this._bins[i];
            }
            return (cumObs += (dIdx - (double)idx) * (double)this._bins[idx]) / (double)this._numObs;
        }
        int idx = (int)Math.floor(dIdx);
        double cumObs = this._numObs;
        for (int i = this._bins.length - 1; i > idx; --i) {
            cumObs -= (double)this._bins[i];
        }
        return (cumObs -= ((double)(idx + 1) - dIdx) * (double)this._bins[idx]) / (double)this._numObs;
    }

    public double getPDF(double val) {
        int idx = (int)((val - this._min) / this._binWidth);
        if (idx < 0 || idx >= this._bins.length) {
            return 0.0;
        }
        return (double)this._bins[idx] / (this._binWidth * (double)this._numObs);
    }

    public boolean testForConvergence(double minConfLimit, double maxConfLimit, double zAlpha, double relativeError) {
        if (this._converged) {
            return this._converged;
        }
        double qVal = this.invCDF(minConfLimit);
        double qSlope = this.getPDF(qVal);
        double variance = minConfLimit * (1.0 - minConfLimit) / ((double)this.getNumObs() * qSlope * qSlope);
        if (!(Math.abs(zAlpha * Math.sqrt(variance) / qVal) <= relativeError * 0.5)) {
            return this._converged;
        }
        qVal = this.invCDF(maxConfLimit);
        qSlope = this.getPDF(qVal);
        variance = maxConfLimit * (1.0 - maxConfLimit) / ((double)this.getNumObs() * qSlope * qSlope);
        if (!(Math.abs(zAlpha * Math.sqrt(variance) / qVal) <= relativeError * 0.5)) {
            return this._converged;
        }
        this._converged = true;
        this._convergedIteration = this._numObs;
        return this._converged;
    }
}

