/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.bootstrap.fixedsize;

import hec.statistics.ContDist;
import hec.statistics.NormalDist;
import hec.statistics.bootstrap.fixedsize.RealizedUncertainDistributionOrdinates;

public class BootstrapConfidenceLimits {
    private static final NormalDist NORMAL = new NormalDist();
    private RealizedUncertainDistributionOrdinates _realizedOrdinates;
    private ContDist _originalDist;
    private double[] _confidenceLimits;
    private double[] _quantiles;

    public BootstrapConfidenceLimits(RealizedUncertainDistributionOrdinates rudo, ContDist dist) {
        this._realizedOrdinates = rudo;
        this._originalDist = dist;
    }

    public double[][] getConfidenceIntervals(double[] confidenceLimits, double[] quantiles, BootstrapConfidenceLimitType type) {
        switch (type) {
            case UNADJUSTED: {
                return this.getUnadjustedConfidenceIntervals(confidenceLimits, quantiles);
            }
            case BIASCORRECTED: {
                return this.getBiasCorrectedCurves(confidenceLimits, quantiles, false);
            }
            case BIASCORRECTEDANDACCELERATED: {
                return this.getBiasCorrectedCurves(confidenceLimits, quantiles, true);
            }
            case STUDENTTBOOTSTRAP: {
                throw new UnsupportedOperationException("Student-t Bootstrap confidences limits not yet supported");
            }
        }
        throw new UnsupportedOperationException("Unknown confidence limit type: " + type.name());
    }

    private double[][] getUnadjustedConfidenceIntervals(double[] confidenceLimits, double[] quantiles) {
        this._confidenceLimits = confidenceLimits;
        this._quantiles = quantiles;
        double[][] retval = new double[this._confidenceLimits.length][this._quantiles.length];
        for (int clIndex = 0; clIndex < this._confidenceLimits.length; ++clIndex) {
            retval[clIndex] = this.getRealizedDistribution().invCDF(quantiles, this._confidenceLimits[clIndex]);
        }
        return retval;
    }

    private RealizedUncertainDistributionOrdinates getRealizedDistribution() {
        return this._realizedOrdinates;
    }

    private double[][] getBiasCorrectedCurves(double[] confidenceLimits, double[] quantiles, boolean applyAcceleration) {
        this._quantiles = quantiles;
        this._confidenceLimits = confidenceLimits;
        double[] values = new double[this._quantiles.length];
        for (int i = 0; i < this._quantiles.length; ++i) {
            values[i] = this._originalDist.invCDF(this._quantiles[i]);
        }
        double[] bias = this.getRealizedDistribution().getCDF(quantiles, values);
        double[] z0 = this.computez0(bias);
        double[] z = this.computez();
        double[] a = applyAcceleration ? this.getAcceleration() : new double[this._quantiles.length];
        double[][] biasCorrection = this.getBiasCorrection(z, z0, a);
        return this.getBiasCorrectedCurves(biasCorrection);
    }

    private double[][] getBiasCorrection(double[] z, double[] z0, double[] a) {
        double[][] retval = new double[z.length][z0.length];
        for (int i = 0; i < z.length; ++i) {
            for (int j = 0; j < z0.length; ++j) {
                retval[i][j] = this.getBiasCorrection(z[i], z0[j], a[j]);
            }
        }
        return retval;
    }

    private double getBiasCorrection(double z, double z0, double a) {
        double value = a * (z0 + z);
        if (value >= 1.0) {
            return 1.0;
        }
        return NORMAL.getCDF(z0 + (z0 + z) / (1.0 - a * (z0 + z)));
    }

    private double[] computez0(double[] bias) {
        double[] retval = new double[bias.length];
        for (int i = 0; i < bias.length; ++i) {
            retval[i] = NORMAL.invCDF(bias[i]);
        }
        return retval;
    }

    private double[] computez() {
        double[] retval = new double[this._confidenceLimits.length];
        for (int i = 0; i < this._confidenceLimits.length; ++i) {
            retval[i] = NORMAL.invCDF(this._confidenceLimits[i]);
        }
        return retval;
    }

    private double[][] getBiasCorrectedCurves(double[][] biasCorrection) {
        double[][] retval = new double[biasCorrection.length][biasCorrection[0].length];
        for (int i = 0; i < biasCorrection.length; ++i) {
            retval[i] = this.getRealizedDistribution().invCDF(this._quantiles, biasCorrection[i]);
        }
        return retval;
    }

    private double[] getAcceleration() {
        double[] retval = this.getRealizedDistribution().computeCrossDistributionSkewness(this._quantiles);
        int i = 0;
        while (i < retval.length) {
            int n = i++;
            retval[n] = retval[n] * 0.16666666666666666;
        }
        return retval;
    }

    public static enum BootstrapConfidenceLimitType {
        UNADJUSTED,
        BIASCORRECTED,
        BIASCORRECTEDANDACCELERATED,
        STUDENTTBOOTSTRAP;

    }
}

