/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.bootstrap.fixedsize;

import hec.statistics.AbstractContDist;
import hec.statistics.ContDist;
import hec.statistics.EnsembleDistribution;
import hec.statistics.LogPearson3Dist;
import hec.statistics.bootstrap.fixedsize.BootstrapConfidenceLimits;
import hec.statistics.bootstrap.fixedsize.RealizedUncertainDistributionOrdinates;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class FixedSizeBootstrap {
    private final int _numberOfRealizations;
    private final EnsembleDistribution _dist;
    private ContDist _originalDist;
    private RealizedUncertainDistributionOrdinates _realizedDistributionSpace = null;
    private BootstrapConfidenceLimits _confidenceLimitsCalculator = null;
    private final int _numThreads;
    private final AbstractContDist.FittingMethod _fittingMethod;
    private final int seed = 12345;

    public FixedSizeBootstrap(int numberOfRealizations, int numThreads, AbstractContDist.FittingMethod method) {
        this._numberOfRealizations = numberOfRealizations;
        this._dist = new EnsembleDistribution(numberOfRealizations);
        this._numThreads = numThreads;
        this._fittingMethod = method;
    }

    public void compute(ContDist dist, int equivalentRecordLength) {
        this._originalDist = dist;
        this._realizedDistributionSpace = null;
        this._confidenceLimitsCalculator = null;
        this._dist.clear();
        ForkJoinPool myPool = new ForkJoinPool(this._numThreads);
        try {
            ((ForkJoinTask)myPool.submit(() -> IntStream.range(0, this._numberOfRealizations).parallel().forEach(i -> {
                Random rnd = new Random(12345 + i);
                double[] sample = new double[equivalentRecordLength];
                this.generateSampledData(rnd, dist, sample);
                try {
                    ContDist realizationDist = (ContDist)dist.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    boolean wasSuccessful = realizationDist.fitSampleData(sample, this._fittingMethod);
                    if (wasSuccessful && this.isFittedDistributionAcceptable(realizationDist)) {
                        this._dist.add(realizationDist);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    Logger.getLogger(FixedSizeBootstrap.class.getName()).log(Level.WARNING, "Bootstrap threadpool interrupted", e);
                }
            }))).get();
            myPool.shutdown();
        }
        catch (InterruptedException | ExecutionException e) {
            Logger.getLogger(FixedSizeBootstrap.class.getName()).log(Level.SEVERE, "Bootstrap failed!", e);
            Thread.currentThread().interrupt();
        }
    }

    public boolean isFittedDistributionAcceptable(ContDist dist) {
        boolean retval = true;
        for (double value : dist.getParamVals()) {
            if (NumericalConstants.isValidValue((double)value)) continue;
            retval = false;
            break;
        }
        if (retval && dist instanceof LogPearson3Dist) {
            retval = ((LogPearson3Dist)dist).getSkew() < 1.41 && ((LogPearson3Dist)dist).getSkew() > -1.41;
        }
        return retval;
    }

    public double[][] getConfidenceIntervals(double[] confidenceLimits, double[] quantiles, BootstrapConfidenceLimits.BootstrapConfidenceLimitType type) {
        return this.getConfidenceLimitsCalculator().getConfidenceIntervals(confidenceLimits, quantiles, type);
    }

    private void generateSampledData(Random rnd, ContDist dist, double[] sample) {
        for (int i = 0; i < sample.length; ++i) {
            sample[i] = dist.invCDF(rnd.nextDouble());
        }
    }

    public double getExpectedProbability(double cumulativeProbability) {
        return this._dist.invCDF(cumulativeProbability);
    }

    private RealizedUncertainDistributionOrdinates getRealizedDistribution() {
        if (this._realizedDistributionSpace == null) {
            this._realizedDistributionSpace = new RealizedUncertainDistributionOrdinates(this._dist, this._numThreads);
        }
        return this._realizedDistributionSpace;
    }

    private BootstrapConfidenceLimits getConfidenceLimitsCalculator() {
        if (this._confidenceLimitsCalculator == null) {
            this._confidenceLimitsCalculator = new BootstrapConfidenceLimits(this.getRealizedDistribution(), this._originalDist);
        }
        return this._confidenceLimitsCalculator;
    }

    public double invCDF(double d) {
        return this._dist.invCDF(d);
    }
}

