/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.bootstrap.fixedsize;

import hec.statistics.EnsembleDistribution;
import hec.statistics.bootstrap.fixedsize.FixedSizeBootstrap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public class RealizedUncertainDistributionOrdinates {
    private double[] _quantiles;
    private double[][] _realizedDistributionSpace = null;
    private final EnsembleDistribution _distributions;
    private int _numThreads;

    public RealizedUncertainDistributionOrdinates(EnsembleDistribution distributions, int numThreads) {
        this._numThreads = numThreads;
        this._distributions = distributions;
    }

    public double[] invCDF(double[] quantiles, double cumulativeProbability) {
        this.computeRealizedDistributionSpace(quantiles);
        double[] retval = new double[this._quantiles.length];
        for (int i = 0; i < this._quantiles.length; ++i) {
            retval[i] = this.invCDF(i, cumulativeProbability);
        }
        return retval;
    }

    public double[] invCDF(double[] quantiles, double[] cumulativeProbabilities) {
        this.computeRealizedDistributionSpace(quantiles);
        double[] retval = new double[quantiles.length];
        for (int i = 0; i < quantiles.length; ++i) {
            retval[i] = this.invCDF(i, cumulativeProbabilities[i]);
        }
        return retval;
    }

    private void computeRealizedDistributionSpace(double[] quantiles) {
        if (this.doesRealizationNeedToBeRecomputed(quantiles)) {
            this._quantiles = quantiles;
            this._realizedDistributionSpace = new double[this._quantiles.length][this._distributions.size()];
            ForkJoinPool myPool = new ForkJoinPool(this._numThreads);
            try {
                ((ForkJoinTask)myPool.submit(() -> IntStream.range(0, this._quantiles.length).parallel().forEach(i -> {
                    this._realizedDistributionSpace[i] = this._distributions.getVerticalCrossDistributionSample(this._quantiles[i]);
                }))).get();
                myPool.shutdown();
            }
            catch (InterruptedException | ExecutionException e) {
                Logger.getLogger(FixedSizeBootstrap.class.getName()).log(Level.SEVERE, "Bootstrap failed!", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean doesRealizationNeedToBeRecomputed(double[] quantiles) {
        boolean retval = false;
        retval = this._realizedDistributionSpace == null || this._quantiles == null ? true : this.areArraysInconsistent(this._quantiles, quantiles);
        return retval;
    }

    private boolean areArraysInconsistent(double[] existing, double[] incoming) {
        boolean retval = false;
        if (existing.length != incoming.length) {
            retval = true;
        } else {
            for (int i = 0; i < existing.length; ++i) {
                if (Double.compare(existing[i], incoming[i]) == 0) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    public double[] getCDF(double[] quantiles, double[] values) {
        this.computeRealizedDistributionSpace(quantiles);
        double[] retval = new double[this._quantiles.length];
        for (int i = 0; i < this._quantiles.length; ++i) {
            for (int j = 0; j < this._realizedDistributionSpace[i].length; ++j) {
                if (!(this._realizedDistributionSpace[i][j] <= values[i])) continue;
                int n = i;
                retval[n] = retval[n] + 1.0;
            }
            int n = i;
            retval[n] = retval[n] / (double)this._realizedDistributionSpace[i].length;
        }
        return retval;
    }

    private double invCDF(int quantileIndex, double cumulativeProbability) {
        int index = (int)Math.round(cumulativeProbability * (double)this._realizedDistributionSpace[quantileIndex].length);
        if (index >= this._realizedDistributionSpace[quantileIndex].length) {
            index = this._realizedDistributionSpace[quantileIndex].length - 1;
        } else if (index < 0) {
            index = 0;
        }
        return this._realizedDistributionSpace[quantileIndex][index];
    }

    public double[] computeCrossDistributionSkewness(double[] quantiles) {
        this.computeRealizedDistributionSpace(quantiles);
        double[] retval = new double[this._quantiles.length];
        for (int k = 0; k < this._quantiles.length; ++k) {
            retval[k] = this.skewness(this._realizedDistributionSpace[k]);
        }
        return retval;
    }

    private double skewness(double[] data) {
        double mean = 0.0;
        for (double v : data) {
            mean += v;
        }
        mean /= (double)data.length;
        int n = data.length;
        double s2 = 0.0;
        double s3 = 0.0;
        for (double v : data) {
            double xm = v - mean;
            s2 += xm * xm;
            s3 += xm * xm * xm;
        }
        double m2 = s2 / (double)n;
        double m3 = s3 / (double)n;
        double g = m3 / Math.pow(m2, 1.5);
        double a = Math.sqrt(n) * Math.sqrt(n - 1);
        double b = (double)n - 2.0;
        return a / b * g;
    }
}

